/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.threadlocal;

import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.plugin.threadlocal.ThreadLocals;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.StaticFieldElement;

public class ThreadLocalBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public ThreadLocalBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value load(Value handle, ReadAccessMode accessMode) {
        return super.load(this.transform(handle), accessMode);
    }

    public Node store(Value handle, Value value, WriteAccessMode accessMode) {
        return super.store(this.transform(handle), value, accessMode);
    }

    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        return super.readModifyWrite(this.transform(pointer), op, update, readMode, writeMode);
    }

    public Value cmpAndSwap(Value handle, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        return super.cmpAndSwap(this.transform(handle), expect, update, readMode, writeMode, strength);
    }

    private Value transform(Value pointer) {
        if (pointer instanceof StaticFieldLiteral) {
            StaticFieldLiteral sfl = (StaticFieldLiteral)pointer;
            StaticFieldElement fieldElement = sfl.getVariableElement();
            boolean isTL = fieldElement.hasAllModifiersOf(524288);
            if (this.getCurrentElement() instanceof InitializerElement && isTL) {
                this.ctxt.warning((Element)fieldElement, "Initialization of thread locals is not yet supported", new Object[0]);
                return this.getLiteralFactory().literalOf(fieldElement);
            }
            if (isTL) {
                ThreadLocals threadLocals = ThreadLocals.get(this.ctxt);
                InstanceFieldElement threadLocalField = threadLocals.getThreadLocalField(fieldElement);
                if (threadLocalField == null) {
                    this.ctxt.error((Element)fieldElement, "Internal: Thread local field was not registered", new Object[0]);
                    return this.getLiteralFactory().literalOf(fieldElement);
                }
                return this.instanceFieldOf(this.load(this.currentThread(), (ReadAccessMode)AccessModes.SingleUnshared), threadLocalField);
            }
            return pointer;
        }
        return pointer;
    }
}

