/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.CompilationContext;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;
import org.qbicc.facts.core.ExecutableReachabilityFacts;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.reachability.BuildtimeHeapAnalyzer;
import org.qbicc.plugin.reachability.InstanceMethodReachabilityFacts;
import org.qbicc.plugin.reachability.ReachabilityAnalysis;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.plugin.reachability.TypeReachabilityFacts;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;

public final class RapidTypeAnalysis
implements ReachabilityAnalysis {
    private final ReachabilityInfo info;
    private final CompilationContext ctxt;
    private final BuildtimeHeapAnalyzer heapAnalyzer = new BuildtimeHeapAnalyzer();
    private final Set<LoadedTypeDefinition> instantiatedClasses = ConcurrentHashMap.newKeySet();
    private final Set<MethodElement> deferredDispatchableMethods = ConcurrentHashMap.newKeySet();
    private final Set<MethodElement> deferredExactMethods = ConcurrentHashMap.newKeySet();

    RapidTypeAnalysis(ReachabilityInfo info, CompilationContext ctxt) {
        this.info = info;
        this.ctxt = ctxt;
    }

    @Override
    public synchronized void processArrayElementType(ObjectType elemType) {
        if (elemType instanceof ClassObjectType) {
            this.info.addReachableClass(elemType.getDefinition().load());
        } else if (elemType instanceof InterfaceObjectType) {
            this.info.addReachableInterface(elemType.getDefinition().load());
        }
    }

    @Override
    public synchronized void processBuildtimeInstantiatedObjectType(LoadedTypeDefinition ltd, ExecutableElement currentElement) {
        this.processInstantiatedClass(ltd, true, currentElement);
    }

    @Override
    public synchronized void processReachableObject(VmObject object, ExecutableElement currentElement) {
        this.heapAnalyzer.traceHeap(this.ctxt, (ReachabilityAnalysis)this, object, currentElement);
    }

    @Override
    public synchronized void processReachableRuntimeInitializer(InitializerElement target, ExecutableElement currentElement) {
        if (!this.ctxt.wasEnqueued((ExecutableElement)target)) {
            ReachabilityInfo.LOGGER.debugf("Adding <rtinit> %s (potentially invoked from %s)", (Object)target, (Object)currentElement);
            this.ctxt.enqueue((ExecutableElement)target);
        }
    }

    @Override
    public synchronized void processReachableExactInvocation(InvokableElement target, ExecutableElement currentElement) {
        StaticMethodElement me;
        if (target instanceof StaticMethodElement) {
            me = (StaticMethodElement)target;
            Facts.get((CompilationContext)this.ctxt).discover((Object)me, (Fact)ExecutableReachabilityFacts.IS_INVOKED);
        } else if (target instanceof InstanceMethodElement) {
            InstanceMethodElement me2 = (InstanceMethodElement)target;
            Facts.get((CompilationContext)this.ctxt).discover((Object)me2, (Fact)InstanceMethodReachabilityFacts.IS_PROVISIONALLY_INVOKED);
        } else if (target instanceof ConstructorElement) {
            ConstructorElement ce = (ConstructorElement)target;
            Facts.get((CompilationContext)this.ctxt).discover((Object)ce, (Fact)ExecutableReachabilityFacts.IS_INVOKED);
        }
        if (!this.ctxt.wasEnqueued((ExecutableElement)target)) {
            this.processReachableType(target.getEnclosingType().load(), currentElement);
            if (target instanceof MethodElement && !(me = (MethodElement)target).isStatic()) {
                if (this.deferredExactMethods.contains(me)) {
                    return;
                }
                LoadedTypeDefinition definingClass = me.getEnclosingType().load();
                if (!definingClass.isInterface() && !this.hasInstantiatedSubclass(definingClass)) {
                    this.deferredExactMethods.add((MethodElement)me);
                    ReachabilityInfo.LOGGER.debugf("Deferring method %s (invoked exactly in %s, but no instantiated receiver)", (Object)target, (Object)currentElement);
                    return;
                }
                this.info.addInvokableInstanceMethod((MethodElement)me);
            }
            ReachabilityInfo.LOGGER.debugf("Adding %s %s (invoked exactly in %s)", (Object)(target instanceof ConstructorElement ? "<init>" : "method"), (Object)target, (Object)currentElement);
            this.ctxt.enqueue((ExecutableElement)target);
        }
    }

    @Override
    public synchronized void processReachableDispatchedInvocation(MethodElement target, ExecutableElement currentElement) {
        this.info.addDispatchableMethod(target);
        if (!this.info.isInvokableInstanceMethod(target) && !this.deferredDispatchableMethods.contains(target)) {
            if (this.hasInstantiatedReceiver(target)) {
                ReachabilityInfo.LOGGER.debugf("Adding dispatched method %s (invoked in %s)", (Object)target, (Object)currentElement);
                this.info.addInvokableInstanceMethod(target);
                this.ctxt.enqueue((ExecutableElement)target);
            } else {
                ReachabilityInfo.LOGGER.debugf("Deferring method %s (dispatched to in %s, but no instantiated receiver)", (Object)target, (Object)currentElement);
                this.deferredDispatchableMethods.add(target);
            }
        }
    }

    @Override
    public synchronized void processReachableStaticFieldAccess(StaticFieldElement field, ExecutableElement currentElement) {
        if (!this.info.isAccessedStaticField((FieldElement)field)) {
            this.processReachableType(field.getEnclosingType().load(), null);
            this.info.addAccessedStaticField((FieldElement)field);
            this.heapAnalyzer.traceHeap(this.ctxt, (ReachabilityAnalysis)this, field, currentElement);
        }
    }

    @Override
    public synchronized void processReachableType(LoadedTypeDefinition ltd, ExecutableElement currentElement) {
        this.info.addReachableType(ltd);
    }

    @Override
    public synchronized void processInstantiatedClass(LoadedTypeDefinition type, boolean onHeapType, ExecutableElement currentElement) {
        if (this.instantiatedClasses.contains(type)) {
            return;
        }
        if (onHeapType) {
            ReachabilityInfo.LOGGER.debugf("Adding class %s (heap reachable from %s)", (Object)type.getDescriptor(), (Object)currentElement);
            Facts.get((CompilationContext)this.ctxt).discover((Object)type, (Fact)TypeReachabilityFacts.IS_ON_HEAP);
        } else {
            ReachabilityInfo.LOGGER.debugf("Adding class %s (instantiated in %s)", (Object)type.getDescriptor(), (Object)currentElement);
            Facts.get((CompilationContext)this.ctxt).discover((Object)type, (Fact)TypeReachabilityFacts.IS_INSTANTIATED, (Fact)TypeReachabilityFacts.IS_ON_HEAP);
        }
        this.info.addReachableClass(type);
        this.instantiatedClasses.add(type);
        ArrayList<MethodElement> toRemove = new ArrayList<MethodElement>();
        for (MethodElement dm : this.deferredExactMethods) {
            if (!type.isSubtypeOf(dm.getEnclosingType().load())) continue;
            ReachabilityInfo.LOGGER.debugf("\tDeferred exact method %s is now invokable)", (Object)dm);
            toRemove.add(dm);
            this.info.addInvokableInstanceMethod(dm);
            this.ctxt.enqueue((ExecutableElement)dm);
        }
        toRemove.forEach(this.deferredExactMethods::remove);
        toRemove.clear();
        for (MethodElement dm : this.deferredDispatchableMethods) {
            MethodElement cand;
            if (!type.isSubtypeOf(dm.getEnclosingType().load()) || (cand = type.resolveMethodElementVirtual(type.getContext(), dm.getName(), dm.getDescriptor())) == null || !cand.equals(dm)) continue;
            ReachabilityInfo.LOGGER.debugf("\tDeferred dispatchable method %s is now invokable)", (Object)dm);
            toRemove.add(dm);
            this.info.addInvokableInstanceMethod(dm);
            this.ctxt.enqueue((ExecutableElement)dm);
        }
        toRemove.forEach(this.deferredDispatchableMethods::remove);
    }

    @Override
    public void clear() {
        this.instantiatedClasses.clear();
        this.deferredDispatchableMethods.clear();
        this.deferredExactMethods.clear();
        this.heapAnalyzer.clear();
    }

    @Override
    public void reportStats() {
        ReachabilityInfo.LOGGER.debugf("  Instantiated classes:          %s", this.instantiatedClasses.size());
        ReachabilityInfo.LOGGER.debugf("  Deferred dispatchable methods: %s", this.deferredDispatchableMethods.size());
        ReachabilityInfo.LOGGER.debugf("  Deferred exact methods:        %s", this.deferredExactMethods.size());
    }

    private boolean hasInstantiatedSubclass(LoadedTypeDefinition ltd) {
        if (this.instantiatedClasses.contains(ltd)) {
            return true;
        }
        boolean[] ans = new boolean[]{false};
        this.info.visitReachableSubclassesPreOrder(ltd, sc -> {
            if (this.instantiatedClasses.contains(sc)) {
                ans[0] = true;
            }
        });
        return ans[0];
    }

    private boolean hasInstantiatedReceiver(MethodElement target) {
        LoadedTypeDefinition definingType = target.getEnclosingType().load();
        if (this.instantiatedClasses.contains(definingType)) {
            return true;
        }
        boolean[] ans = new boolean[]{false};
        this.info.visitReachableSubclassesPreOrder(definingType, sc -> {
            MethodElement cand;
            if (this.instantiatedClasses.contains(sc) && (cand = sc.resolveMethodElementVirtual(definingType.getContext(), target.getName(), target.getDescriptor())) != null && cand.equals(target)) {
                ans[0] = true;
            }
        });
        return ans[0];
    }
}

