/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qbicc.plugin.patcher.ConstructorDeleteInfo;
import org.qbicc.plugin.patcher.ConstructorPatchInfo;
import org.qbicc.plugin.patcher.FieldDeleteInfo;
import org.qbicc.plugin.patcher.FieldPatchInfo;
import org.qbicc.plugin.patcher.InitializerPatchInfo;
import org.qbicc.plugin.patcher.MethodBodyPatchInfo;
import org.qbicc.plugin.patcher.MethodDeleteInfo;
import org.qbicc.plugin.patcher.MethodPatchInfo;
import org.qbicc.plugin.patcher.RuntimeInitializerPatchInfo;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

final class ClassPatchInfo {
    private static final byte[] EMPTY_DIGEST = new byte[32];
    static final ClassPatchInfo EMPTY = new ClassPatchInfo(0);
    private boolean committed;
    private Map<String, FieldPatchInfo> annotatedFields = Map.of();
    private Map<String, FieldPatchInfo> replacedFields = Map.of();
    private List<FieldPatchInfo> injectedFields = List.of();
    private Map<String, FieldDeleteInfo> deletedFields = Map.of();
    private Map<String, RuntimeInitializerPatchInfo> runtimeInitFields = Map.of();
    private Map<MethodDescriptor, ConstructorPatchInfo> annotatedConstructors = Map.of();
    private Map<MethodDescriptor, ConstructorPatchInfo> replacedConstructors = Map.of();
    private List<ConstructorPatchInfo> injectedConstructors = List.of();
    private Map<MethodDescriptor, ConstructorDeleteInfo> deletedConstructors = Map.of();
    private Map<String, Map<MethodDescriptor, MethodPatchInfo>> annotatedMethods = Map.of();
    private Map<String, Map<MethodDescriptor, MethodPatchInfo>> replacedMethods = Map.of();
    private List<MethodPatchInfo> injectedMethods = List.of();
    private Map<String, Map<MethodDescriptor, MethodDeleteInfo>> deletedMethods = Map.of();
    private InitializerPatchInfo replacedInitializer;
    private boolean deletedInitializer;
    private Map<String, Map<MethodDescriptor, MethodBodyPatchInfo>> methodBodyReplacedMethods = Map.of();
    private List<Annotation> addedClassAnnotations = List.of();
    private byte[] digest = EMPTY_DIGEST;

    ClassPatchInfo() {
    }

    ClassPatchInfo(int ignored) {
        this();
        this.committed = true;
    }

    ClassPatchInfo(String internalName) {
        this();
    }

    void commit() {
        assert (Thread.holdsLock(this));
        this.committed = true;
    }

    byte[] getDigest() {
        return this.digest;
    }

    FieldDeleteInfo getDeletedFieldInfo(String name, TypeDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        FieldDeleteInfo info = this.deletedFields.get(name);
        return info == null ? null : (info.getDescriptor().equals(descriptor) ? info : null);
    }

    ConstructorDeleteInfo getDeletedConstructorInfo(MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return this.deletedConstructors.get(descriptor);
    }

    MethodDeleteInfo getDeletedMethodInfo(String name, MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return (MethodDeleteInfo)this.deletedMethods.getOrDefault(name, Map.of()).get(descriptor);
    }

    boolean isDeletedInitializer() {
        assert (Thread.holdsLock(this));
        return this.deletedInitializer;
    }

    FieldPatchInfo getReplacementFieldInfo(String fieldName, TypeDescriptor descriptor) {
        FieldPatchInfo fieldPatchInfo = this.replacedFields.get(fieldName);
        return fieldPatchInfo != null && fieldPatchInfo.getDescriptor().equals(descriptor) ? fieldPatchInfo : null;
    }

    ConstructorPatchInfo getReplacementConstructorInfo(MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return this.replacedConstructors.get(descriptor);
    }

    MethodPatchInfo getReplacementMethodInfo(String name, MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return (MethodPatchInfo)this.replacedMethods.getOrDefault(name, Map.of()).get(descriptor);
    }

    MethodBodyPatchInfo getReplacementMethodBodyInfo(String name, MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return (MethodBodyPatchInfo)this.methodBodyReplacedMethods.getOrDefault(name, Map.of()).get(descriptor);
    }

    InitializerPatchInfo getReplacementInitializerInfo() {
        assert (Thread.holdsLock(this));
        return this.replacedInitializer;
    }

    List<Annotation> getAddedClassAnnotations() {
        assert (Thread.holdsLock(this));
        return this.addedClassAnnotations;
    }

    List<FieldPatchInfo> getInjectedFields() {
        assert (Thread.holdsLock(this));
        return this.injectedFields;
    }

    List<ConstructorPatchInfo> getInjectedConstructors() {
        assert (Thread.holdsLock(this));
        return this.injectedConstructors;
    }

    List<MethodPatchInfo> getInjectedMethods() {
        assert (Thread.holdsLock(this));
        return this.injectedMethods;
    }

    RuntimeInitializerPatchInfo getRuntimeInitFieldInfo(String fieldName, TypeDescriptor descriptor) {
        RuntimeInitializerPatchInfo rtInitPatchInfo = this.runtimeInitFields.get(fieldName);
        return rtInitPatchInfo != null && rtInitPatchInfo.getDescriptor().equals(descriptor) ? rtInitPatchInfo : null;
    }

    FieldPatchInfo getAnnotatedFieldInfo(String fieldName, TypeDescriptor descriptor) {
        FieldPatchInfo fieldPatchInfo = this.annotatedFields.get(fieldName);
        return fieldPatchInfo != null && fieldPatchInfo.getDescriptor().equals(descriptor) ? fieldPatchInfo : null;
    }

    ConstructorPatchInfo getAnnotatedConstructorInfo(MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return this.annotatedConstructors.get(descriptor);
    }

    MethodPatchInfo getAnnotatedMethodInfo(String name, MethodDescriptor descriptor) {
        assert (Thread.holdsLock(this));
        return (MethodPatchInfo)this.annotatedMethods.getOrDefault(name, Map.of()).get(descriptor);
    }

    void addField(FieldPatchInfo fieldPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        for (FieldPatchInfo injectedField : this.injectedFields) {
            if (!injectedField.getName().equals(fieldPatchInfo.getName())) continue;
            return;
        }
        this.injectedFields = this.listWith(this.injectedFields, fieldPatchInfo);
    }

    void deleteField(String name, TypeDescriptor descriptor, String internalName, Annotation annotation) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.deletedFields = this.mapWith(this.deletedFields, name, new FieldDeleteInfo(internalName, descriptor, name, annotation));
    }

    void replaceField(FieldPatchInfo fieldPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        String name = fieldPatchInfo.getName();
        this.replacedFields = this.mapWith(this.replacedFields, name, fieldPatchInfo);
    }

    void annotateField(FieldPatchInfo fieldPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        String name = fieldPatchInfo.getName();
        this.annotatedFields = this.mapWith(this.annotatedFields, name, fieldPatchInfo);
    }

    void runtimeInitField(RuntimeInitializerPatchInfo runtimeInitPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        String name = runtimeInitPatchInfo.getName();
        this.runtimeInitFields = this.mapWith(this.runtimeInitFields, name, runtimeInitPatchInfo);
    }

    void addConstructor(ConstructorPatchInfo constructorPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        for (ConstructorPatchInfo injectedConstructor : this.injectedConstructors) {
            if (!injectedConstructor.getDescriptor().equals(constructorPatchInfo.getDescriptor())) continue;
            return;
        }
        this.injectedConstructors = this.listWith(this.injectedConstructors, constructorPatchInfo);
    }

    void deleteConstructor(MethodDescriptor descriptor, String internalName, Annotation annotation) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.deletedConstructors = this.mapWith(this.deletedConstructors, descriptor, new ConstructorDeleteInfo(internalName, descriptor, annotation));
    }

    void replaceConstructor(ConstructorPatchInfo constructorPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        MethodDescriptor descriptor = constructorPatchInfo.getDescriptor();
        this.replacedConstructors = this.mapWith(this.replacedConstructors, descriptor, constructorPatchInfo);
    }

    void annotateConstructor(ConstructorPatchInfo constructorPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        MethodDescriptor descriptor = constructorPatchInfo.getDescriptor();
        this.annotatedConstructors = this.mapWith(this.annotatedConstructors, descriptor, constructorPatchInfo);
    }

    void addMethod(MethodPatchInfo methodPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.injectedMethods = this.listWith(this.injectedMethods, methodPatchInfo);
        for (MethodPatchInfo injectedMethod : this.injectedMethods) {
            if (!injectedMethod.getName().equals(methodPatchInfo.getName()) || !injectedMethod.getDescriptor().equals(methodPatchInfo.getDescriptor())) continue;
            return;
        }
    }

    void deleteMethod(String name, MethodDescriptor descriptor, String internalName, Annotation annotation) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.deletedMethods = this.mapWith(this.deletedMethods, name, this.mapWith(this.deletedMethods.getOrDefault(name, Map.of()), descriptor, new MethodDeleteInfo(internalName, name, descriptor, annotation)));
    }

    void replaceMethod(MethodPatchInfo methodPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        String name = methodPatchInfo.getName();
        MethodDescriptor descriptor = methodPatchInfo.getDescriptor();
        this.replacedMethods = this.mapWith(this.replacedMethods, name, this.mapWith(this.replacedMethods.getOrDefault(name, Map.of()), descriptor, methodPatchInfo));
    }

    void annotateMethod(MethodPatchInfo methodPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        String name = methodPatchInfo.getName();
        MethodDescriptor descriptor = methodPatchInfo.getDescriptor();
        this.annotatedMethods = this.mapWith(this.annotatedMethods, name, this.mapWith(this.annotatedMethods.getOrDefault(name, Map.of()), descriptor, methodPatchInfo));
    }

    void replaceMethodBody(String name, MethodDescriptor descriptor, MethodBodyFactory methodBodyFactory, int index) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.methodBodyReplacedMethods = this.mapWith(this.methodBodyReplacedMethods, name, this.mapWith(this.methodBodyReplacedMethods.getOrDefault(name, Map.of()), descriptor, new MethodBodyPatchInfo(methodBodyFactory, index)));
    }

    void deleteInitializer() {
        assert (Thread.holdsLock(this));
        this.deletedInitializer = true;
    }

    void replaceInitializer(InitializerPatchInfo initializerPatchInfo) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.replacedInitializer = initializerPatchInfo;
    }

    void addClassAnnotation(Annotation annotation) {
        assert (Thread.holdsLock(this));
        this.checkCommitted();
        this.addedClassAnnotations = this.listWith(this.addedClassAnnotations, annotation);
    }

    void setDigest(byte[] digest) {
        Assert.checkNotNullParam((String)"digest", (Object)digest);
        this.checkCommitted();
        this.digest = digest;
    }

    private void checkCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Class already loaded");
        }
    }

    private <K, V> Map<K, V> mapWith(Map<K, V> orig, K key, V val) {
        int size = orig.size();
        if (orig instanceof HashMap) {
            orig.put(key, val);
            return orig;
        }
        if (size == 0 || size == 1 && orig.containsKey(key)) {
            return Map.of(key, val);
        }
        HashMap<K, V> map = new HashMap<K, V>(orig);
        map.put(key, val);
        return map;
    }

    private <E> Set<E> setWith(Set<E> orig, E elem) {
        int size = orig.size();
        if (orig instanceof HashSet) {
            orig.add(elem);
            return orig;
        }
        if (size == 0 || size == 1 && orig.contains(elem)) {
            return Set.of(elem);
        }
        HashSet<E> set = new HashSet<E>(orig);
        set.add(elem);
        return set;
    }

    private <E> List<E> listWith(List<E> orig, E elem) {
        int size = orig.size();
        if (orig instanceof ArrayList) {
            orig.add(elem);
            return orig;
        }
        if (size == 0) {
            return List.of(elem);
        }
        if (size == 1) {
            return List.of(orig.get(0), elem);
        }
        if (size == 2) {
            return List.of(orig.get(0), orig.get(1), elem);
        }
        ArrayList<E> list = new ArrayList<E>(orig);
        list.add(elem);
        return list;
    }
}

