/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import java.util.List;
import java.util.Map;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class AccessorBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final Map<BaseTypeDescriptor, String> GETTER_NAMES = Map.of(BaseTypeDescriptor.B, "getAsByte", BaseTypeDescriptor.C, "getAsChar", BaseTypeDescriptor.D, "getAsDouble", BaseTypeDescriptor.F, "getAsFloat", BaseTypeDescriptor.I, "getAsInt", BaseTypeDescriptor.J, "getAsLong", BaseTypeDescriptor.S, "getAsShort", BaseTypeDescriptor.Z, "getAsBoolean");
    private final CompilationContext ctxt = this.getContext();

    public AccessorBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        StaticFieldLiteral staticField;
        StaticFieldElement field;
        VmObject accessor;
        if (pointer instanceof StaticFieldLiteral && (accessor = this.getAccessor((FieldElement)(field = (staticField = (StaticFieldLiteral)pointer).getVariableElement()))) != null) {
            BasicBlockBuilder fb = this.getFirstBuilder();
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            TypeDescriptor fieldDesc = field.getTypeDescriptor();
            String getter = GETTER_NAMES.getOrDefault(fieldDesc, "get");
            MethodDescriptor desc = MethodDescriptor.synthesize((ClassContext)accessor.getVmClass().getTypeDefinition().getContext(), (TypeDescriptor)fieldDesc, List.of());
            ObjectLiteral accessorValue = lf.literalOf(accessor);
            return fb.call(fb.lookupVirtualMethod((Value)accessorValue, accessor.getVmClass().getTypeDefinition().getDescriptor(), getter, desc), (Value)accessorValue, List.of());
        }
        return super.load(pointer, accessMode);
    }

    public Node store(Value pointer, Value value, WriteAccessMode accessMode) {
        StaticFieldLiteral staticField;
        StaticFieldElement field;
        VmObject accessor;
        if (pointer instanceof StaticFieldLiteral && (accessor = this.getAccessor((FieldElement)(field = (staticField = (StaticFieldLiteral)pointer).getVariableElement()))) != null) {
            BasicBlockBuilder fb = this.getFirstBuilder();
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            TypeDescriptor fieldDesc = field.getTypeDescriptor();
            MethodDescriptor desc = MethodDescriptor.synthesize((ClassContext)accessor.getVmClass().getTypeDefinition().getContext(), (TypeDescriptor)BaseTypeDescriptor.V, List.of(fieldDesc));
            ObjectLiteral accessorValue = lf.literalOf(accessor);
            return fb.call(fb.lookupVirtualMethod((Value)accessorValue, accessor.getVmClass().getTypeDefinition().getDescriptor(), "set", desc), (Value)accessorValue, List.of(value));
        }
        return super.store(pointer, value, accessMode);
    }

    public Value cmpAndSwap(Value target, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        this.checkAtomicAccessor(target);
        return super.cmpAndSwap(target, expect, update, readMode, writeMode, strength);
    }

    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        if (op == ReadModifyWrite.Op.SET) {
            StaticFieldLiteral sfl;
            if (pointer instanceof StaticFieldLiteral && this.getAccessor((FieldElement)(sfl = (StaticFieldLiteral)pointer).getVariableElement()) != null) {
                if (AccessModes.GlobalPlain.includes((AccessMode)readMode) || AccessModes.GlobalPlain.includes((AccessMode)writeMode)) {
                    Value loaded = this.load(pointer, readMode);
                    this.store(pointer, update, writeMode);
                    return loaded;
                }
                this.atomicNotAllowed();
            }
        } else {
            this.checkAtomicAccessor(pointer);
        }
        return super.readModifyWrite(pointer, op, update, readMode, writeMode);
    }

    private void checkAtomicAccessor(Value pointer) {
        StaticFieldLiteral sfl;
        if (pointer instanceof StaticFieldLiteral && this.getAccessor((FieldElement)(sfl = (StaticFieldLiteral)pointer).getVariableElement()) != null) {
            this.atomicNotAllowed();
        }
    }

    private void atomicNotAllowed() {
        this.ctxt.error(this.getLocation(), "Atomic operation not supported for fields with accessors", new Object[0]);
    }

    private VmObject getAccessor(FieldElement fieldElement) {
        return Patcher.get(this.ctxt).lookUpAccessor(fieldElement);
    }
}

