/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.PhaseAttachmentKey;
import org.qbicc.graph.Call;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.type.definition.element.ExecutableElement;

final class EscapeAnalysisState {
    private static final PhaseAttachmentKey<EscapeAnalysisState> KEY = new PhaseAttachmentKey();
    private final Map<ExecutableElement, List<Call>> callGraph = new ConcurrentHashMap<ExecutableElement, List<Call>>();
    private final Map<ExecutableElement, ConnectionGraph> connectionGraphs = new ConcurrentHashMap<ExecutableElement, ConnectionGraph>();

    EscapeAnalysisState() {
    }

    ConnectionGraph getConnectionGraph(ExecutableElement element) {
        return this.connectionGraphs.get(element);
    }

    Collection<ExecutableElement> getMethodsVisited() {
        return this.connectionGraphs.keySet();
    }

    List<Call> getCallees(ExecutableElement element) {
        List<Call> callees = this.callGraph.get(element);
        return callees != null ? callees : Collections.emptyList();
    }

    void addMethod(ExecutableElement element, ConnectionGraph connectionGraph) {
        this.connectionGraphs.put(element, connectionGraph);
    }

    void addCall(ExecutableElement from, Call to) {
        this.callGraph.computeIfAbsent(from, k -> new ArrayList()).add(to);
    }

    boolean isNotEscapingMethod(New new_, ExecutableElement element) {
        ConnectionGraph connectionGraph = this.connectionGraphs.get(element);
        return connectionGraph != null && connectionGraph.getEscapeValue((Node)new_).isNoEscape();
    }

    static EscapeAnalysisState get(CompilationContext ctxt) {
        EscapeAnalysisState appearing;
        EscapeAnalysisState state = (EscapeAnalysisState)ctxt.getAttachment(KEY);
        if (state == null && (appearing = (EscapeAnalysisState)ctxt.putAttachmentIfAbsent(KEY, (Object)(state = new EscapeAnalysisState()))) != null) {
            state = appearing;
        }
        return state;
    }

    static EscapeAnalysisState getPrevious(CompilationContext ctxt) {
        return (EscapeAnalysisState)ctxt.getPreviousPhaseAttachment(KEY);
    }
}

