/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.Collection;
import java.util.Objects;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Store;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.plugin.dot.Disassembler;
import org.qbicc.plugin.dot.DotAttributes;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.opt.ea.EscapeValue;

public final class EscapeAnalysisDotVisitor
implements NodeVisitor.Delegating<Disassembler, Void, Void, Void> {
    private final NodeVisitor<Disassembler, Void, Void, Void> delegate;
    private final EscapeAnalysisState escapeAnalysisState;

    public EscapeAnalysisDotVisitor(CompilationContext ctxt, NodeVisitor<Disassembler, Void, Void, Void> delegate) {
        this.delegate = delegate;
        this.escapeAnalysisState = EscapeAnalysisState.get(ctxt);
    }

    public NodeVisitor<Disassembler, Void, Void, Void> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public Void visit(Disassembler param, New node) {
        this.decorate(param, (Node)node);
        return (Void)this.delegate.visit((Object)param, node);
    }

    public Void visit(Disassembler param, Store node) {
        Value pointer = node.getPointer();
        if (pointer instanceof StaticFieldLiteral || pointer instanceof InstanceFieldOf) {
            this.decorate(param, (Node)pointer);
        }
        return (Void)this.delegate.visit((Object)param, node);
    }

    public Void visit(Disassembler param, BlockParameter node) {
        this.decorate(param, (Node)node);
        return (Void)this.delegate.visit((Object)param, node);
    }

    private void decorate(Disassembler param, Node node) {
        ConnectionGraph connectionGraph = this.getConnectionGraph(param);
        param.setLineColor(this.nodeType((EscapeValue)connectionGraph.getEscapeValue((Node)node)).fillColor);
        this.addFieldEdges(param, node, connectionGraph);
        this.addPointsToEdge(param, node, connectionGraph);
    }

    private void addPointsToEdge(Disassembler param, Node node, ConnectionGraph connectionGraph) {
        Value pointsTo = connectionGraph.getPointsToEdge(node);
        if (Objects.nonNull(pointsTo)) {
            param.addCellEdge(node, (Node)pointsTo, "P", (DotAttributes)EdgeType.POINTS_TO);
        }
    }

    private void addFieldEdges(Disassembler param, Node node, ConnectionGraph connectionGraph) {
        Collection<InstanceFieldOf> fields = connectionGraph.getFieldEdges(node);
        for (InstanceFieldOf field : fields) {
            param.addCellEdge(node, (Node)field, "F", (DotAttributes)EdgeType.FIELD);
        }
    }

    private ConnectionGraph getConnectionGraph(Disassembler disassembler) {
        return this.escapeAnalysisState.getConnectionGraph(disassembler.getElement());
    }

    private NodeType nodeType(EscapeValue value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case EscapeValue.GLOBAL_ESCAPE -> NodeType.GLOBAL_ESCAPE;
            case EscapeValue.ARG_ESCAPE -> NodeType.ARG_ESCAPE;
            case EscapeValue.NO_ESCAPE -> NodeType.NO_ESCAPE;
            case EscapeValue.UNKNOWN -> NodeType.UNKNOWN;
        };
    }

    private static enum NodeType {
        GLOBAL_ESCAPE("lightsalmon"),
        ARG_ESCAPE("lightcyan3"),
        NO_ESCAPE("lightblue1"),
        UNKNOWN("lightpink1");

        final String fillColor;

        private NodeType(String fillColor) {
            this.fillColor = fillColor;
        }
    }

    private static enum EdgeType implements DotAttributes
    {
        POINTS_TO("gray", "solid"),
        FIELD("gray", "dashed");

        final String color;
        final String style;

        private EdgeType(String color, String style) {
            this.color = color;
            this.style = style;
        }

        public String color() {
            return this.color;
        }

        public String style() {
            return this.style;
        }

        public String portPos() {
            return this == FIELD ? "w" : "e";
        }
    }
}

