/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.ByteOffsetPointer;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.ElementOf;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.Node;
import org.qbicc.graph.OffsetPointer;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;

public class LocalMemoryTrackingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private Map<Node, Value> knownValues = new HashMap<Node, Value>();

    public LocalMemoryTrackingBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Node begin(BlockLabel blockLabel) {
        this.knownValues.clear();
        return super.begin(blockLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BasicBlock begin(BlockLabel blockLabel, T arg, BiConsumer<T, BasicBlockBuilder> maker) {
        Map<Node, Value> oldKnownValues = this.knownValues;
        this.knownValues = new HashMap<Node, Value>();
        try {
            BasicBlock basicBlock = super.begin(blockLabel, arg, maker);
            return basicBlock;
        }
        finally {
            this.knownValues = oldKnownValues;
        }
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        if (!AccessModes.GlobalPlain.includes((AccessMode)accessMode)) {
            this.knownValues.clear();
        } else {
            Value value = this.knownValues.get(pointer);
            if (value != null) {
                return value;
            }
        }
        Value loaded = super.load(pointer, accessMode);
        this.knownValues.put((Node)pointer, loaded);
        return loaded;
    }

    public Node store(Value pointer, Value value, WriteAccessMode accessMode) {
        Value root = LocalMemoryTrackingBasicBlockBuilder.findRoot(pointer);
        this.knownValues.keySet().removeIf(k -> {
            Value ptr;
            return k instanceof Value && !LocalMemoryTrackingBasicBlockBuilder.hasSameRoot(ptr = (Value)k, root);
        });
        this.knownValues.put((Node)pointer, value);
        return super.store(pointer, value, accessMode);
    }

    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        this.knownValues.clear();
        return super.readModifyWrite(pointer, op, update, readMode, writeMode);
    }

    public Value cmpAndSwap(Value pointer, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        this.knownValues.clear();
        return super.cmpAndSwap(pointer, expect, update, readMode, writeMode, strength);
    }

    public Node fence(GlobalAccessMode fenceType) {
        this.knownValues.clear();
        return super.fence(fenceType);
    }

    public Node monitorEnter(Value obj) {
        this.knownValues.clear();
        return super.monitorEnter(obj);
    }

    public Node monitorExit(Value obj) {
        this.knownValues.clear();
        return super.monitorExit(obj);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        this.knownValues.clear();
        return super.call(targetPtr, receiver, arguments);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        this.knownValues.clear();
        return super.callNoReturn(targetPtr, receiver, arguments);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        this.knownValues.clear();
        return super.invokeNoReturn(targetPtr, receiver, arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        this.knownValues.clear();
        return super.tailCall(targetPtr, receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        this.knownValues.clear();
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    private static Value findRoot(Value pointer) {
        if (pointer instanceof MemberOf) {
            MemberOf mo = (MemberOf)pointer;
            return LocalMemoryTrackingBasicBlockBuilder.findRoot(mo.getStructurePointer());
        }
        if (pointer instanceof ElementOf) {
            ElementOf eo = (ElementOf)pointer;
            return LocalMemoryTrackingBasicBlockBuilder.findRoot(eo.getArrayPointer());
        }
        if (pointer instanceof InstanceFieldOf) {
            InstanceFieldOf ifo = (InstanceFieldOf)pointer;
            return LocalMemoryTrackingBasicBlockBuilder.findRoot(ifo.getInstance());
        }
        if (pointer instanceof DecodeReference) {
            DecodeReference dr = (DecodeReference)pointer;
            return LocalMemoryTrackingBasicBlockBuilder.findRoot(dr.getInput());
        }
        if (pointer instanceof OffsetPointer) {
            OffsetPointer op = (OffsetPointer)pointer;
            return LocalMemoryTrackingBasicBlockBuilder.findRoot(op.getBasePointer());
        }
        if (pointer instanceof ByteOffsetPointer) {
            ByteOffsetPointer bop = (ByteOffsetPointer)pointer;
            return LocalMemoryTrackingBasicBlockBuilder.findRoot(bop.getBasePointer());
        }
        return pointer;
    }

    private static boolean hasSameRoot(Value pointer, Value root) {
        return LocalMemoryTrackingBasicBlockBuilder.findRoot(pointer).equals(root);
    }
}

