/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.coreclasses.HeaderBits;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.BoundTypeArgument;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.NestedClassTypeSignature;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.TopLevelClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.generic.Variance;

public class NativeTypeResolver
implements DescriptorTypeResolver.Delegating {
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final DescriptorTypeResolver delegate;

    public NativeTypeResolver(ClassContext classCtxt, DescriptorTypeResolver delegate) {
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.delegate = delegate;
    }

    public DescriptorTypeResolver getDelegate() {
        return this.delegate;
    }

    public ValueType resolveTypeFromClassName(String packageName, String internalName) {
        String rewrittenName;
        String string = rewrittenName = internalName.endsWith("$_native") ? internalName.substring(0, internalName.length() - "$_native".length()) : internalName;
        if (packageName.equals(Native.NATIVE_PKG)) {
            if (rewrittenName.equals(Native.TYPE_ID)) {
                return this.classCtxt.findDefinedType("java/lang/Object").load().getClassType().getReference().getTypeType();
            }
            if (rewrittenName.equals(Native.HEADER_TYPE)) {
                return HeaderBits.get((CompilationContext)this.ctxt).getHeaderType();
            }
            if (rewrittenName.equals(Native.REFERENCE)) {
                return this.classCtxt.resolveTypeFromClassName("java/lang", "Object");
            }
            if (rewrittenName.equals(Native.VOID)) {
                return this.ctxt.getTypeSystem().getVoidType();
            }
            if (rewrittenName.equals(Native.OBJECT)) {
                return this.ctxt.getTypeSystem().getVariadicType();
            }
            if (rewrittenName.equals(Native.PTR)) {
                return this.ctxt.getTypeSystem().getVoidType().getPointer();
            }
        }
        NativeInfo nativeInfo = NativeInfo.get(this.ctxt);
        DefinedTypeDefinition definedType = this.classCtxt.findDefinedType(packageName + "/" + rewrittenName);
        if (definedType == null) {
            return this.delegate.resolveTypeFromClassName(packageName, rewrittenName);
        }
        ValueType valueType = nativeInfo.resolveNativeType(definedType);
        return valueType == null ? this.delegate.resolveTypeFromClassName(packageName, rewrittenName) : valueType;
    }

    public ValueType resolveTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        ClassTypeDescriptor ctd;
        if (descriptor instanceof ClassTypeDescriptor && (ctd = (ClassTypeDescriptor)descriptor).packageAndClassNameEquals(Native.NATIVE_PKG, Native.REFERENCE)) {
            TopLevelClassTypeSignature tl;
            NestedClassTypeSignature nc;
            if (signature instanceof NestedClassTypeSignature && (nc = (NestedClassTypeSignature)signature).getIdentifier().equals("reference")) {
                TopLevelClassTypeSignature cts;
                ClassTypeSignature classTypeSignature = nc.getEnclosing();
                if (classTypeSignature instanceof TopLevelClassTypeSignature && (cts = (TopLevelClassTypeSignature)classTypeSignature).getPackageName().equals(Native.NATIVE_PKG) && cts.getIdentifier().equals(Native.C_NATIVE)) {
                    return this.getReferenceType(paramCtxt, (ClassTypeSignature)nc);
                }
            } else if (signature instanceof TopLevelClassTypeSignature && (tl = (TopLevelClassTypeSignature)signature).getPackageName().equals(Native.NATIVE_PKG) && tl.getIdentifier().equals(Native.REFERENCE)) {
                return this.getReferenceType(paramCtxt, (ClassTypeSignature)tl);
            }
            return ((ObjectType)this.classCtxt.resolveTypeFromClassName("java/lang", "Object")).getReference();
        }
        return this.delegate.resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
    }

    private ReferenceType getReferenceType(TypeParameterContext paramCtxt, ClassTypeSignature sig) {
        BoundTypeArgument bta;
        Variance variance;
        TypeArgument typeArgument;
        List typeArguments = sig.getTypeArguments();
        if (typeArguments.size() == 1 && (typeArgument = (TypeArgument)typeArguments.get(0)) instanceof BoundTypeArgument && ((variance = (bta = (BoundTypeArgument)typeArgument).getVariance()) == Variance.COVARIANT || variance == Variance.INVARIANT)) {
            ReferenceTypeSignature bound = bta.getBound();
            TypeDescriptor boundDesc = bound.asDescriptor(this.classCtxt);
            ValueType nestedType = this.classCtxt.resolveTypeFromDescriptor(boundDesc, paramCtxt, (TypeSignature)bound);
            if (nestedType instanceof ObjectType) {
                ObjectType ot = (ObjectType)nestedType;
                return ot.getReference();
            }
            this.ctxt.error("Cannot convert %s into an object type", new Object[]{nestedType});
        }
        return ((ObjectType)this.classCtxt.resolveTypeFromClassName("java/lang", "Object")).getReference();
    }
}

