/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;

public class NativeTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final DefinedTypeDefinition.Builder delegate;
    private boolean isNative;
    private boolean isInternalNative;

    public NativeTypeBuilder(ClassContext classCtxt, DefinedTypeDefinition.Builder delegate) {
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.delegate = delegate;
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void setSuperClassName(String superClassInternalName) {
        if (superClassInternalName != null && (superClassInternalName.equals(Native.OBJECT_INT_NAME) || superClassInternalName.equals(Native.STRUCT_INT_NAME) || superClassInternalName.equals(Native.UNION_INT_NAME) || superClassInternalName.equals(Native.WORD_INT_NAME) || superClassInternalName.equals(Native.PTR_INT_NAME))) {
            this.isNative = true;
        }
        this.getDelegate().setSuperClassName(superClassInternalName);
    }

    public void addConstructor(ConstructorResolver resolver, int index, MethodDescriptor descriptor) {
        if (!this.isNative) {
            this.delegate.addConstructor(resolver, index, descriptor);
        }
    }

    public void setInvisibleAnnotations(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            String annClassName;
            ClassTypeDescriptor desc = annotation.getDescriptor();
            if (!desc.getPackageName().equals(Native.NATIVE_PKG) || !(annClassName = desc.getClassName()).equals(Native.ANN_INTERNAL)) continue;
            this.isInternalNative = true;
            break;
        }
        this.getDelegate().setInvisibleAnnotations(annotations);
    }

    public DefinedTypeDefinition build() {
        DefinedTypeDefinition builtType = this.getDelegate().build();
        if (this.isInternalNative) {
            NativeInfo.get((CompilationContext)this.ctxt).internalNativeTypes.put(builtType, new AtomicReference());
        } else if (this.isNative && !builtType.isAbstract()) {
            NativeInfo.get((CompilationContext)this.ctxt).nativeTypes.put(builtType, new AtomicReference());
        }
        return builtType;
    }
}

