/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.native_.Native;
import org.qbicc.type.CompoundType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;

public final class NativeLayout {
    private static final AttachmentKey<NativeLayout> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Map<LoadedTypeDefinition, CompoundType> layouts = new ConcurrentHashMap<LoadedTypeDefinition, CompoundType>();

    private NativeLayout(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static NativeLayout get(CompilationContext ctxt) {
        NativeLayout appearing;
        NativeLayout layout = (NativeLayout)ctxt.getAttachment(KEY);
        if (layout == null && (appearing = (NativeLayout)ctxt.putAttachmentIfAbsent(KEY, (Object)(layout = new NativeLayout(ctxt)))) != null) {
            layout = appearing;
        }
        return layout;
    }

    public CompoundType getLayoutInfo(DefinedTypeDefinition type) {
        LoadedTypeDefinition validated = type.load();
        CompoundType layoutInfo = this.layouts.get(validated);
        if (layoutInfo != null) {
            return layoutInfo;
        }
        String internalName = type.getInternalName();
        int lastSep = Math.max(internalName.lastIndexOf(47), internalName.lastIndexOf(36));
        String simpleName = lastSep == -1 ? internalName : internalName.substring(lastSep + 1);
        CompoundType compoundType = this.ctxt.getTypeSystem().getCompoundType(CompoundType.Tag.NONE, simpleName, () -> {
            int minAlignment = this.ctxt.getTypeSystem().getPointerAlignment();
            BitSet allocated = new BitSet();
            int cnt = validated.getFieldCount();
            HashMap<FieldElement, CompoundType.Member> fieldToMember = new HashMap<FieldElement, CompoundType.Member>(cnt);
            int previousFieldOffset = 0;
            ConditionEvaluation conditionEvaluation = ConditionEvaluation.get((CompilationContext)this.ctxt);
            block0: for (int i = 0; i < cnt; ++i) {
                int idx;
                FieldElement field = validated.getField(i);
                if (field.isStatic()) continue;
                TypeSystem ts = this.ctxt.getTypeSystem();
                ValueType fieldType = field.getType();
                int size2 = (int)fieldType.getSize();
                int align2 = fieldType.getAlign();
                String fieldName = field.getName();
                boolean nameOverridden = false;
                block1: for (Annotation annotation : field.getInvisibleAnnotations()) {
                    ClassTypeDescriptor annDesc = annotation.getDescriptor();
                    if (!annDesc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                    if (annDesc.getClassName().equals(Native.ANN_NAME) && !nameOverridden) {
                        if (!conditionEvaluation.evaluateConditions(validated.getContext(), (Locatable)type, annotation)) continue;
                        fieldName = ((StringAnnotationValue)annotation.getValue("value")).getString();
                        nameOverridden = true;
                        continue;
                    }
                    if (annDesc.getClassName().equals(Native.ANN_NAME_LIST) && !nameOverridden) {
                        AnnotationValue patt3985$temp = annotation.getValue("value");
                        if (!(patt3985$temp instanceof ArrayAnnotationValue)) continue;
                        ArrayAnnotationValue aav = (ArrayAnnotationValue)patt3985$temp;
                        int annCnt = aav.getElementCount();
                        for (int j = 0; j < annCnt; ++j) {
                            Annotation nested;
                            ClassTypeDescriptor nestedDesc;
                            AnnotationValue patt4216$temp = aav.getValue(j);
                            if (!(patt4216$temp instanceof Annotation) || !(nestedDesc = (nested = (Annotation)patt4216$temp).getDescriptor()).getPackageName().equals(Native.NATIVE_PKG) || !nestedDesc.getClassName().equals(Native.ANN_NAME) || !conditionEvaluation.evaluateConditions(validated.getContext(), (Locatable)type, nested)) continue;
                            fieldName = ((StringAnnotationValue)nested.getValue("value")).getString();
                            nameOverridden = true;
                            continue block1;
                        }
                        continue;
                    }
                    if (!annDesc.getClassName().equals(Native.ANN_INCOMPLETE) || !conditionEvaluation.evaluateConditions(type.getContext(), (Locatable)field, annotation)) continue;
                    continue block0;
                }
                if (size2 != 0) {
                    idx = this.find(allocated, align2, size2, previousFieldOffset);
                    allocated.set(idx, idx + size2);
                } else {
                    idx = this.find(allocated, align2, ts.getMaxAlignment(), previousFieldOffset);
                }
                CompoundType.Member member = ts.getCompoundTypeMember(fieldName, fieldType, idx, align2);
                if (member.getAlign() > minAlignment) {
                    minAlignment = member.getAlign();
                }
                fieldToMember.put(field, member);
                previousFieldOffset = member.getOffset();
            }
            Object[] membersArray = (CompoundType.Member[])fieldToMember.values().toArray(CompoundType.Member[]::new);
            Arrays.sort(membersArray);
            return List.of(membersArray);
        });
        CompoundType appearing = this.layouts.putIfAbsent(validated, compoundType);
        return appearing != null ? appearing : compoundType;
    }

    private int find(BitSet bitSet, int alignment, int size2, int searchIdx) {
        assert (Integer.bitCount(alignment) == 1);
        int mask = alignment - 1;
        int i = bitSet.nextClearBit(searchIdx);
        int amt = mask - (i - 1 & mask);
        while (amt > 0) {
            i = bitSet.nextClearBit(i + amt);
            amt = mask - (i - 1 & mask);
        }
        return i;
    }
}

