/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.context.Locatable;
import org.qbicc.driver.Driver;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.probe.CProbe;
import org.qbicc.machine.probe.Qualifier;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.linker.Linker;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeDataInfo;
import org.qbicc.plugin.native_.NativeFunctionInfo;
import org.qbicc.plugin.native_.NativeLayout;
import org.qbicc.plugin.native_.ProbeUtils;
import org.qbicc.type.CompoundType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnionType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.ClassAnnotationValue;
import org.qbicc.type.annotation.IntAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.annotation.type.TypeAnnotation;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.AnyTypeArgument;
import org.qbicc.type.generic.BoundTypeArgument;
import org.qbicc.type.generic.ClassSignature;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.Signature;
import org.qbicc.type.generic.TopLevelClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.generic.Variance;

final class NativeInfo {
    static final AttachmentKey<NativeInfo> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    final ClassTypeDescriptor cNativeDesc;
    final ClassTypeDescriptor ptrDesc;
    final ClassTypeDescriptor wordDesc;
    final ClassTypeDescriptor cObjectDesc;
    final Map<TypeDescriptor, Map<String, Map<MethodDescriptor, NativeFunctionInfo>>> nativeFunctions = new ConcurrentHashMap<TypeDescriptor, Map<String, Map<MethodDescriptor, NativeFunctionInfo>>>();
    final Map<TypeDescriptor, Map<String, Map<MethodDescriptor, MethodElement>>> nativeBindings = new ConcurrentHashMap<TypeDescriptor, Map<String, Map<MethodDescriptor, MethodElement>>>();
    final Map<FieldElement, FieldElement> nativeFieldBindings = new ConcurrentHashMap<FieldElement, FieldElement>();
    final Map<TypeDescriptor, Map<String, NativeDataInfo>> nativeFields = new ConcurrentHashMap<TypeDescriptor, Map<String, NativeDataInfo>>();
    final Map<DefinedTypeDefinition, AtomicReference<ValueType>> nativeTypes = new ConcurrentHashMap<DefinedTypeDefinition, AtomicReference<ValueType>>();
    final Map<DefinedTypeDefinition, AtomicReference<ValueType>> internalNativeTypes = new ConcurrentHashMap<DefinedTypeDefinition, AtomicReference<ValueType>>();
    final Map<DefinedTypeDefinition, InstanceMethodElement> functionalInterfaceMethods = new ConcurrentHashMap<DefinedTypeDefinition, InstanceMethodElement>();
    final Set<InitializerElement> initializers = ConcurrentHashMap.newKeySet();
    final Map<DefinedTypeDefinition, List<FunctionAndPriority>> globalCtors = new ConcurrentHashMap<DefinedTypeDefinition, List<FunctionAndPriority>>();
    final Map<DefinedTypeDefinition, List<FunctionAndPriority>> globalDtors = new ConcurrentHashMap<DefinedTypeDefinition, List<FunctionAndPriority>>();

    private NativeInfo(CompilationContext ctxt) {
        this.ctxt = ctxt;
        ClassContext classContext = ctxt.getBootstrapClassContext();
        this.cNativeDesc = ClassTypeDescriptor.parseClassConstant((ClassContext)classContext, (ByteBuffer)ByteBuffer.wrap(Native.C_NATIVE_INT_NAME.getBytes(StandardCharsets.UTF_8)));
        this.ptrDesc = ClassTypeDescriptor.parseClassConstant((ClassContext)classContext, (ByteBuffer)ByteBuffer.wrap(Native.PTR_INT_NAME.getBytes(StandardCharsets.UTF_8)));
        this.wordDesc = ClassTypeDescriptor.parseClassConstant((ClassContext)classContext, (ByteBuffer)ByteBuffer.wrap(Native.WORD_INT_NAME.getBytes(StandardCharsets.UTF_8)));
        this.cObjectDesc = ClassTypeDescriptor.parseClassConstant((ClassContext)classContext, (ByteBuffer)ByteBuffer.wrap(Native.OBJECT_INT_NAME.getBytes(StandardCharsets.UTF_8)));
    }

    static NativeInfo get(CompilationContext ctxt) {
        NativeInfo appearing;
        NativeInfo nativeInfo = (NativeInfo)ctxt.getAttachment(KEY);
        if (nativeInfo == null && (appearing = (NativeInfo)ctxt.putAttachmentIfAbsent(KEY, (Object)(nativeInfo = new NativeInfo(ctxt)))) != null) {
            nativeInfo = appearing;
        }
        return nativeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueType resolveInternalNativeType(DefinedTypeDefinition definedType) {
        AtomicReference<ValueType> ref = this.internalNativeTypes.get(definedType);
        if (ref == null) {
            return null;
        }
        ClassContext classContext = definedType.getContext();
        CompilationContext ctxt = classContext.getCompilationContext();
        ValueType resolved = ref.get();
        if (resolved == null) {
            AtomicReference<ValueType> atomicReference = ref;
            synchronized (atomicReference) {
                resolved = ref.get();
                if (resolved == null) {
                    LoadedTypeDefinition validated = definedType.load();
                    resolved = NativeLayout.get(ctxt).getLayoutInfo((DefinedTypeDefinition)validated);
                    ref.set(resolved);
                }
            }
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueType resolveNativeType(DefinedTypeDefinition definedType) {
        AtomicReference<ValueType> ref = this.nativeTypes.get(definedType);
        if (ref == null) {
            return null;
        }
        ClassContext classContext = definedType.getContext();
        CompilationContext ctxt = classContext.getCompilationContext();
        ConditionEvaluation conditionEvaluation = ConditionEvaluation.get((CompilationContext)ctxt);
        Object resolved = ref.get();
        if (resolved == null) {
            AtomicReference<ValueType> atomicReference = ref;
            synchronized (atomicReference) {
                resolved = ref.get();
                if (resolved == null) {
                    if (definedType.getSuperClassInternalName().equals(Native.PTR_INT_NAME)) {
                        resolved = this.decodePointerType(definedType);
                        ref.set((ValueType)resolved);
                    } else {
                        CompoundType.Tag ctTag;
                        CProbe.Builder pb = CProbe.builder();
                        String simpleName = null;
                        Qualifier q = Qualifier.NONE;
                        boolean incomplete2 = false;
                        int annotatedAlign = 0;
                        boolean union2 = definedType.getSuperClassInternalName().equals(Native.UNION_INT_NAME);
                        this.processEnclosingType(classContext, pb, definedType);
                        ProbeUtils.ProbeProcessor pp = new ProbeUtils.ProbeProcessor(classContext, (Locatable)definedType);
                        block5: for (Annotation annotation : definedType.getInvisibleAnnotations()) {
                            AnnotationValue resolvedType2;
                            Annotation nested;
                            ClassTypeDescriptor nestedDesc;
                            int i;
                            ArrayAnnotationValue aav;
                            ClassTypeDescriptor annDesc = annotation.getDescriptor();
                            if (pp.processAnnotation(annotation) || !annDesc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                            if (annDesc.getClassName().equals(Native.ANN_NAME) && simpleName == null) {
                                if (!conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, annotation)) continue;
                                simpleName = ((StringAnnotationValue)annotation.getValue("value")).getString();
                                continue;
                            }
                            if (annDesc.getClassName().equals(Native.ANN_NAME_LIST) && simpleName == null) {
                                AnnotationValue annotationValue = annotation.getValue("value");
                                if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
                                aav = (ArrayAnnotationValue)annotationValue;
                                int cnt = aav.getElementCount();
                                for (i = 0; i < cnt; ++i) {
                                    AnnotationValue annotationValue2 = aav.getValue(i);
                                    if (!(annotationValue2 instanceof Annotation) || !(nestedDesc = (nested = (Annotation)annotationValue2).getDescriptor()).getPackageName().equals(Native.NATIVE_PKG) || !nestedDesc.getClassName().equals(Native.ANN_NAME) || !conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, nested)) continue;
                                    simpleName = ((StringAnnotationValue)nested.getValue("value")).getString();
                                    continue block5;
                                }
                                continue;
                            }
                            if (annDesc.getClassName().equals(Native.ANN_INCOMPLETE)) {
                                if (!conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, annotation)) continue;
                                incomplete2 = true;
                                continue;
                            }
                            if (annDesc.getClassName().equals(Native.ANN_ALIGN) && annotatedAlign == 0) {
                                if (!conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, annotation) || (annotatedAlign = ((IntAnnotationValue)annotation.getValue("value")).intValue()) != Integer.MAX_VALUE) continue;
                                annotatedAlign = ctxt.getTypeSystem().getMaxAlignment();
                                continue;
                            }
                            if (annDesc.getClassName().equals(Native.ANN_ALIGN_LIST) && annotatedAlign == 0) {
                                AnnotationValue cnt = annotation.getValue("value");
                                if (!(cnt instanceof ArrayAnnotationValue)) continue;
                                aav = (ArrayAnnotationValue)cnt;
                                int cnt2 = aav.getElementCount();
                                for (i = 0; i < cnt2; ++i) {
                                    nestedDesc = aav.getValue(i);
                                    if (!(nestedDesc instanceof Annotation) || !(nestedDesc = (nested = (Annotation)nestedDesc).getDescriptor()).getPackageName().equals(Native.NATIVE_PKG) || !nestedDesc.getClassName().equals(Native.ANN_ALIGN) || !conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, nested)) continue;
                                    annotatedAlign = ((IntAnnotationValue)nested.getValue("value")).intValue();
                                    if (annotatedAlign != Integer.MAX_VALUE) continue block5;
                                    annotatedAlign = ctxt.getTypeSystem().getMaxAlignment();
                                    continue block5;
                                }
                                continue;
                            }
                            if (annDesc.getClassName().equals(Native.ANN_ALIGN_AS) && annotatedAlign == 0) {
                                AnnotationValue cnt2 = annotation.getValue("value");
                                if (!(cnt2 instanceof ClassAnnotationValue)) continue;
                                ClassAnnotationValue cav = (ClassAnnotationValue)cnt2;
                                if (!conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, annotation)) continue;
                                ValueType resolvedType2 = classContext.resolveTypeFromDescriptor(cav.getDescriptor(), (TypeParameterContext)definedType, TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)definedType.getDescriptor()));
                                annotatedAlign = resolvedType2.getAlign();
                                continue;
                            }
                            if (!annDesc.getClassName().equals(Native.ANN_ALIGN_AS_LIST) || annotatedAlign != 0 || !((resolvedType2 = annotation.getValue("value")) instanceof ArrayAnnotationValue)) continue;
                            aav = (ArrayAnnotationValue)resolvedType2;
                            int cnt = aav.getElementCount();
                            for (i = 0; i < cnt && annotatedAlign == 0; ++i) {
                                AnnotationValue annotationValue;
                                nestedDesc = aav.getValue(i);
                                if (!(nestedDesc instanceof Annotation) || !(nestedDesc = (nested = (Annotation)nestedDesc).getDescriptor()).packageAndClassNameEquals(Native.NATIVE_PKG, Native.ANN_ALIGN_AS) || !((annotationValue = nested.getValue("value")) instanceof ClassAnnotationValue)) continue;
                                ClassAnnotationValue cav = (ClassAnnotationValue)annotationValue;
                                if (!conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, nested)) continue;
                                ValueType resolvedType3 = classContext.resolveTypeFromDescriptor(cav.getDescriptor(), (TypeParameterContext)definedType, TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)definedType.getDescriptor()));
                                annotatedAlign = resolvedType3.getAlign();
                                continue block5;
                            }
                        }
                        pp.accept(pb);
                        if (simpleName == null) {
                            String fullName = definedType.getInternalName();
                            int idx = fullName.lastIndexOf(47);
                            simpleName = idx == -1 ? fullName : fullName.substring(idx + 1);
                            idx = simpleName.lastIndexOf(36);
                            String string = simpleName = idx == -1 ? simpleName : simpleName.substring(idx + 1);
                            if (simpleName.startsWith("struct_") && !union2) {
                                q = Qualifier.STRUCT;
                                simpleName = simpleName.substring(7);
                            } else if (simpleName.startsWith("union_") && union2) {
                                q = Qualifier.UNION;
                                simpleName = simpleName.substring(6);
                            }
                        }
                        LoadedTypeDefinition vt = definedType.load();
                        int fc = vt.getFieldCount();
                        TypeSystem ts = ctxt.getTypeSystem();
                        CProbe.Type.Builder tb = CProbe.Type.builder();
                        tb.setName(simpleName);
                        tb.setQualifier(q);
                        if (!union2) {
                            block9: for (int i = 0; i < fc; ++i) {
                                FieldElement field = vt.getField(i);
                                boolean nameOverridden = false;
                                String fieldName = field.getName();
                                if (field.isStatic()) continue;
                                block10: for (Annotation annotation : field.getInvisibleAnnotations()) {
                                    ClassTypeDescriptor annDesc = annotation.getDescriptor();
                                    if (!annDesc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                                    if (annDesc.getClassName().equals(Native.ANN_NAME) && !nameOverridden) {
                                        if (!conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, annotation)) continue;
                                        fieldName = ((StringAnnotationValue)annotation.getValue("value")).getString();
                                        nameOverridden = true;
                                        continue;
                                    }
                                    if (annDesc.getClassName().equals(Native.ANN_NAME_LIST) && !nameOverridden) {
                                        AnnotationValue annotationValue = annotation.getValue("value");
                                        if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
                                        ArrayAnnotationValue aav = (ArrayAnnotationValue)annotationValue;
                                        int cnt = aav.getElementCount();
                                        for (int j = 0; j < cnt; ++j) {
                                            Annotation nested;
                                            ClassTypeDescriptor nestedDesc;
                                            AnnotationValue annotationValue3 = aav.getValue(j);
                                            if (!(annotationValue3 instanceof Annotation) || !(nestedDesc = (nested = (Annotation)annotationValue3).getDescriptor()).getPackageName().equals(Native.NATIVE_PKG) || !nestedDesc.getClassName().equals(Native.ANN_NAME) || !conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, nested)) continue;
                                            fieldName = ((StringAnnotationValue)nested.getValue("value")).getString();
                                            nameOverridden = true;
                                            continue block10;
                                        }
                                        continue;
                                    }
                                    if (!annDesc.getClassName().equals(Native.ANN_INCOMPLETE) || !conditionEvaluation.evaluateConditions(classContext, (Locatable)definedType, annotation)) continue;
                                    continue block9;
                                }
                                tb.addMember(fieldName);
                            }
                        }
                        UnionType.Tag utTag = q == Qualifier.NONE ? UnionType.Tag.NONE : UnionType.Tag.UNION;
                        CompoundType.Tag tag = ctTag = q == Qualifier.NONE ? CompoundType.Tag.NONE : CompoundType.Tag.STRUCT;
                        if (incomplete2) {
                            resolved = ts.getIncompleteCompoundType(ctTag, simpleName);
                        } else {
                            CProbe.Type probeType = tb.build();
                            pb.probeType(probeType);
                            CProbe probe = pb.build();
                            try {
                                CProbe.Result result = probe.run((CToolChain)ctxt.getAttachment(Driver.C_TOOL_CHAIN_KEY), (ObjectFileProvider)ctxt.getAttachment(Driver.OBJ_PROVIDER_TOOL_KEY), (DiagnosticContext)ctxt);
                                if (result != null) {
                                    int align2;
                                    CProbe.Type.Info typeInfo = result.getTypeInfo(probeType);
                                    long size2 = typeInfo.getSize();
                                    int n = align2 = annotatedAlign != 0 ? annotatedAlign : (int)typeInfo.getAlign();
                                    resolved = typeInfo.isFloating() ? (size2 == 4L ? ts.getFloat32Type() : (size2 == 8L ? ts.getFloat64Type() : ts.getCompoundType(ctTag, simpleName, size2, align2, List::of))) : (typeInfo.isSigned() ? (size2 == 1L ? ts.getSignedInteger8Type() : (size2 == 2L ? ts.getSignedInteger16Type() : (size2 == 4L ? ts.getSignedInteger32Type() : (size2 == 8L ? ts.getSignedInteger64Type() : ts.getCompoundType(ctTag, simpleName, size2, align2, List::of))))) : (typeInfo.isUnsigned() ? (size2 == 1L ? ts.getUnsignedInteger8Type() : (size2 == 2L ? ts.getUnsignedInteger16Type() : (size2 == 4L ? ts.getUnsignedInteger32Type() : (size2 == 8L ? ts.getUnsignedInteger64Type() : ts.getCompoundType(ctTag, simpleName, size2, align2, List::of))))) : (union2 ? ts.getUnionType(utTag, simpleName, () -> {
                                        ArrayList<UnionType.Member> list = new ArrayList<UnionType.Member>();
                                        for (int i = 0; i < fc; ++i) {
                                            FieldElement field = vt.getField(i);
                                            if (field.isStatic()) continue;
                                            ValueType type = field.getType();
                                            list.add(ts.getUnionTypeMember(field.getName(), type));
                                        }
                                        return List.copyOf(list);
                                    }) : ts.getCompoundType(ctTag, simpleName, size2, align2, () -> {
                                        ArrayList<Object> list = new ArrayList<Object>();
                                        for (int i = 0; i < fc; ++i) {
                                            FieldElement field = vt.getField(i);
                                            if (field.isStatic()) continue;
                                            ValueType type = field.getType();
                                            String name = field.getName();
                                            CProbe.Type.Info member = result.getTypeInfoOfMember(probeType, name);
                                            list.add(ts.getProbedCompoundTypeMember(name, type, (int)member.getOffset()));
                                        }
                                        list.sort(Comparator.naturalOrder());
                                        return List.copyOf(list);
                                    }))));
                                }
                                ref.set((ValueType)resolved);
                            }
                            catch (IOException e) {
                                ctxt.error((Throwable)e, "Failed to define native type " + simpleName, new Object[0]);
                                return ts.getPoisonType();
                            }
                        }
                    }
                }
            }
        }
        return resolved;
    }

    private void processEnclosingType(ClassContext classContext, CProbe.Builder builder, DefinedTypeDefinition definedType) {
        String enclosingName = definedType.getEnclosingClassInternalName();
        if (enclosingName != null) {
            DefinedTypeDefinition enclosingType = classContext.findDefinedType(enclosingName);
            this.processEnclosingType(classContext, builder, enclosingType);
            ProbeUtils.ProbeProcessor pp = new ProbeUtils.ProbeProcessor(classContext, (Locatable)definedType);
            for (Annotation annotation : enclosingType.getInvisibleAnnotations()) {
                pp.processAnnotation(annotation);
            }
            pp.accept(builder);
        }
    }

    private ValueType decodePointerType(DefinedTypeDefinition definedType) {
        TopLevelClassTypeSignature tlBound;
        ReferenceTypeSignature bound;
        List typeArguments;
        ClassTypeSignature classTypeSignature;
        TypeSystem ts = this.ctxt.getTypeSystem();
        if (definedType.internalNameEquals("org/qbicc/runtime/CNative$function_ptr")) {
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of()).getPointer();
        }
        Signature signature = definedType.getSignature();
        if (signature instanceof ClassSignature) {
            ClassSignature cs = (ClassSignature)signature;
            classTypeSignature = cs.getSuperClassSignature();
        } else {
            classTypeSignature = null;
        }
        ClassTypeSignature superClassSignature = classTypeSignature;
        List list = typeArguments = superClassSignature == null ? List.of() : superClassSignature.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return ts.getVoidType().getPointer();
        }
        TypeArgument ptrArg = (TypeArgument)typeArguments.get(0);
        if (ptrArg.equals((TypeArgument)AnyTypeArgument.INSTANCE)) {
            return ts.getVoidType().getPointer();
        }
        BoundTypeArgument boundArg = (BoundTypeArgument)ptrArg;
        Variance variance = boundArg.getVariance();
        if (variance != Variance.INVARIANT) {
            this.ctxt.error("Invalid pointer type variance", new Object[0]);
        }
        if ((bound = boundArg.getBound()) instanceof TopLevelClassTypeSignature && (tlBound = (TopLevelClassTypeSignature)bound).getPackageName().equals(Native.NATIVE_PKG) && tlBound.getIdentifier().equals("CNative$object") && this.isArgConst(definedType)) {
            return ts.getVoidType().getPointer().withConstPointee();
        }
        ClassContext classContext = definedType.getContext();
        ValueType pointeeType = classContext.resolveTypeFromDescriptor(bound.asDescriptor(classContext), (TypeParameterContext)definedType, (TypeSignature)bound);
        return pointeeType.getPointer();
    }

    private boolean isArgConst(DefinedTypeDefinition definedType) {
        for (TypeAnnotation next : definedType.getVisibleTypeAnnotations().onTypeArgument(0)) {
            if (!next.getAnnotation().getDescriptor().packageAndClassNameEquals(Native.NATIVE_PKG, Native.ANN_CONST)) continue;
            return true;
        }
        return false;
    }

    public ValueType getNativeType(DefinedTypeDefinition def) {
        AtomicReference<ValueType> ref = this.nativeTypes.get(def);
        return ref == null ? null : ref.get();
    }

    public boolean isNativeType(DefinedTypeDefinition enclosingType) {
        return this.nativeTypes.containsKey(enclosingType);
    }

    public ValueType getTypeOfFunctionalInterface(DefinedTypeDefinition definedType, ClassTypeSignature sig) {
        InstanceMethodElement method = this.getFunctionalInterfaceMethod(definedType);
        if (method == null) {
            this.ctxt.error("No functional interface method on \"%s\"", new Object[]{definedType});
            return this.ctxt.getTypeSystem().getFunctionType((ValueType)this.ctxt.getTypeSystem().getVoidType(), List.of());
        }
        return this.ctxt.getTypeSystem().getFunctionType(method.getType().getReturnType(), method.getType().getParameterTypes());
    }

    public InstanceMethodElement getFunctionalInterfaceMethod(DefinedTypeDefinition definedType) {
        InstanceMethodElement fiData = this.functionalInterfaceMethods.get(definedType);
        if (fiData != null) {
            return fiData;
        }
        try {
            fiData = this.computeFunctionalInterfaceMethod(definedType.load(), new HashSet<LoadedTypeDefinition>(), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (fiData != null) {
            InstanceMethodElement appearing = this.functionalInterfaceMethods.putIfAbsent(definedType, fiData);
            if (appearing != null) {
                return appearing;
            }
        } else {
            this.ctxt.error("Interface \"%s\" is not a functional interface", new Object[]{definedType.getInternalName()});
        }
        return fiData;
    }

    private InstanceMethodElement computeFunctionalInterfaceMethod(LoadedTypeDefinition type, HashSet<LoadedTypeDefinition> visited, InstanceMethodElement found) {
        if (visited.add(type)) {
            int methodCount = type.getMethodCount();
            for (int i = 0; i < methodCount; ++i) {
                MethodElement method = type.getMethod(i);
                if (!method.isAbstract() || !method.isPublic() || !(method instanceof InstanceMethodElement)) continue;
                InstanceMethodElement ime = (InstanceMethodElement)method;
                InstanceMethodType methodType = ime.getType();
                if (found == null) {
                    found = ime;
                    continue;
                }
                InstanceMethodType foundType = found.getType();
                if (foundType.getReturnType().equals(methodType.getReturnType()) && foundType.getParameterTypes().equals(methodType.getParameterTypes())) continue;
                throw new IllegalArgumentException();
            }
            int intCnt = type.getInterfaceCount();
            for (int i = 0; i < intCnt; ++i) {
                found = this.computeFunctionalInterfaceMethod(type.getInterface(i), visited, found);
            }
        }
        return found;
    }

    public NativeFunctionInfo getFunctionInfo(TypeDescriptor owner, String name2, MethodDescriptor descriptor) {
        return (NativeFunctionInfo)this.nativeFunctions.getOrDefault(owner, Map.of()).getOrDefault(name2, Map.of()).get(descriptor);
    }

    public void registerFunctionInfo(TypeDescriptor owner, String name2, MethodDescriptor descriptor, NativeFunctionInfo info) {
        this.nativeFunctions.computeIfAbsent(owner, NativeInfo::newMap).computeIfAbsent(name2, NativeInfo::newMap).put(descriptor, info);
    }

    private static <K, V> Map<K, V> newMap(Object key) {
        return new ConcurrentHashMap();
    }

    public boolean registerInitializer(InitializerElement initializerElement) {
        return this.initializers.add(initializerElement);
    }

    public void registerNativeBinding(MethodElement origMethod, MethodElement nativeMethod) {
        this.nativeBindings.computeIfAbsent(origMethod.getEnclosingType().getDescriptor(), NativeInfo::newMap).computeIfAbsent(origMethod.getName(), NativeInfo::newMap).put(origMethod.getDescriptor(), nativeMethod);
    }

    public void registerNativeBinding(FieldElement origField, FieldElement mappedField) {
        this.nativeFieldBindings.put(origField, mappedField);
    }

    public MethodElement getNativeBinding(TypeDescriptor owner, String name2, MethodDescriptor descriptor) {
        return (MethodElement)this.nativeBindings.getOrDefault(owner, Map.of()).getOrDefault(name2, Map.of()).get(descriptor);
    }

    public MethodElement getNativeBinding(MethodElement original) {
        return this.getNativeBinding(original.getEnclosingType().getDescriptor(), original.getName(), original.getDescriptor());
    }

    public FieldElement getNativeBinding(FieldElement original) {
        return this.nativeFieldBindings.get(original);
    }

    void registerLibrary(String library) {
        Linker.get((CompilationContext)this.ctxt).addLibrary(library);
    }

    public void registerFieldInfo(TypeDescriptor owner, String name2, NativeDataInfo info) {
        this.nativeFields.computeIfAbsent(owner, NativeInfo::newMap).put(name2, info);
    }

    public NativeDataInfo getFieldInfo(TypeDescriptor owner, String name2) {
        return (NativeDataInfo)this.nativeFields.getOrDefault(owner, Map.of()).get(name2);
    }

    public void registerGlobalConstructor(FunctionElement element, int priority) {
        this.registerGlobalXtor(this.globalCtors, element, priority);
    }

    public void registerGlobalDestructor(FunctionElement element, int priority) {
        this.registerGlobalXtor(this.globalDtors, element, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerGlobalXtor(Map<DefinedTypeDefinition, List<FunctionAndPriority>> map, FunctionElement element, int priority) {
        List list;
        Assert.checkNotNullParam((String)"element", (Object)element);
        List list2 = list = map.computeIfAbsent(element.getEnclosingType(), NativeInfo::createList);
        synchronized (list2) {
            list.add(new FunctionAndPriority(element, priority));
        }
    }

    private static List<FunctionAndPriority> createList(DefinedTypeDefinition ignored) {
        return new ArrayList<FunctionAndPriority>();
    }

    public List<FunctionAndPriority> getGlobalConstructors() {
        return this.getGlobalXtors(this.globalCtors);
    }

    public List<FunctionAndPriority> getGlobalDestructors() {
        return this.getGlobalXtors(this.globalDtors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FunctionAndPriority> getGlobalXtors(Map<DefinedTypeDefinition, List<FunctionAndPriority>> map) {
        ArrayList<FunctionAndPriority> list = new ArrayList<FunctionAndPriority>();
        Iterator<List<FunctionAndPriority>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List<FunctionAndPriority> subList;
            List<FunctionAndPriority> list2 = subList = iterator.next();
            synchronized (list2) {
                list.addAll(subList);
            }
        }
        return list;
    }

    public record FunctionAndPriority(FunctionElement function, int priority) {
    }
}

