/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;

public class InternalNativeTypeResolver
implements DescriptorTypeResolver.Delegating {
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final DescriptorTypeResolver delegate;

    public InternalNativeTypeResolver(ClassContext classCtxt, DescriptorTypeResolver delegate) {
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.delegate = delegate;
    }

    public DescriptorTypeResolver getDelegate() {
        return this.delegate;
    }

    public ValueType resolveTypeFromClassName(String packageName, String internalName) {
        DefinedTypeDefinition definedType = this.classCtxt.findDefinedType(packageName + "/" + internalName);
        if (definedType == null) {
            return this.delegate.resolveTypeFromClassName(packageName, internalName);
        }
        NativeInfo nativeInfo = NativeInfo.get(this.ctxt);
        ValueType valueType = nativeInfo.resolveInternalNativeType(definedType);
        return valueType == null ? this.delegate.resolveTypeFromClassName(packageName, internalName) : valueType;
    }
}

