/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.runtime.CNative;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.AnyTypeArgument;
import org.qbicc.type.generic.BoundTypeArgument;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.TypeArgument;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.generic.Variance;

public class FunctionTypeResolver
implements DescriptorTypeResolver.Delegating {
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final DescriptorTypeResolver delegate;

    public FunctionTypeResolver(ClassContext classCtxt, DescriptorTypeResolver delegate) {
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.delegate = delegate;
    }

    public DescriptorTypeResolver getDelegate() {
        return this.delegate;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ValueType resolveTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        if (!(descriptor instanceof ClassTypeDescriptor)) return this.getDelegate().resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
        ClassTypeDescriptor ctd = (ClassTypeDescriptor)descriptor;
        if (!ctd.getPackageName().equals(Native.NATIVE_PKG)) return this.getDelegate().resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
        if (!ctd.getClassName().equals(Native.FUNCTION)) return this.getDelegate().resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
        TypeSystem ts = this.ctxt.getTypeSystem();
        if (!(signature instanceof ClassTypeSignature)) {
            this.ctxt.warning("Generic signature type mismatch (expected a %s but got a %s)", new Object[]{ClassTypeSignature.class, signature.getClass()});
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
        }
        ClassTypeSignature sig = (ClassTypeSignature)signature;
        if (!sig.getIdentifier().equals(Native.FUNCTION)) {
            this.ctxt.warning("Incorrect generic signature (expected a %s but got \"%s\")", new Object[]{CNative.function.class, sig});
            return this.getDelegate().resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
        }
        List args = sig.getTypeArguments();
        if (args.size() != 1) {
            this.ctxt.warning("Incorrect number of generic signature arguments (expected a %s but got \"%s\")", new Object[]{CNative.function.class, sig});
            return this.getDelegate().resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
        }
        TypeArgument typeArgument = (TypeArgument)args.get(0);
        if (typeArgument instanceof AnyTypeArgument) {
            this.ctxt.error("Function types cannot be open-ended", new Object[0]);
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
        }
        assert (typeArgument instanceof BoundTypeArgument);
        BoundTypeArgument bound = (BoundTypeArgument)typeArgument;
        if (bound.getVariance() != Variance.INVARIANT) {
            this.ctxt.error("Function types cannot be open-ended", new Object[0]);
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
        }
        ReferenceTypeSignature pointeeSig = bound.getBound();
        if (!(pointeeSig instanceof ClassTypeSignature)) {
            this.ctxt.error("Function pointee must be a functional interface", new Object[0]);
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
        }
        ClassTypeSignature ctsBound = (ClassTypeSignature)pointeeSig;
        ClassTypeDescriptor classDesc = ctsBound.asDescriptor(this.classCtxt);
        Object name2 = classDesc.getPackageName().isEmpty() ? classDesc.getClassName() : classDesc.getPackageName() + "/" + classDesc.getClassName();
        if (((String)name2).equals("java/lang/Object")) {
            this.ctxt.error("Function types cannot be open-ended", new Object[0]);
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
        }
        DefinedTypeDefinition definedType = this.classCtxt.findDefinedType((String)name2);
        if (definedType == null) {
            this.ctxt.error("Function interface type \"%s\" is missing", new Object[]{name2});
            return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
        }
        if (definedType.isInterface()) {
            return NativeInfo.get(this.ctxt).getTypeOfFunctionalInterface(definedType, ctsBound);
        }
        this.ctxt.error("Function interface type \"%s\" is not an interface", new Object[]{name2});
        return ts.getFunctionType((ValueType)ts.getVoidType(), List.of());
    }
}

