/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.metrics;

import io.smallrye.common.constraint.Assert;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.metrics.CountMetric;
import org.qbicc.plugin.metrics.MemorySizeMetric;
import org.qbicc.plugin.metrics.Metric;
import org.qbicc.plugin.metrics.Timer;

public final class Metrics {
    private static final AttachmentKey<Metrics> KEY = new AttachmentKey();
    private final Map<String, MemorySizeMetric> memorySizes = new ConcurrentHashMap<String, MemorySizeMetric>();
    private final Map<String, CountMetric> counts = new ConcurrentHashMap<String, CountMetric>();
    private final Map<String, Timer> timers = new ConcurrentHashMap<String, Timer>();

    private Metrics() {
    }

    public static Metrics get(CompilationContext ctxt) {
        Metrics appearing;
        Metrics metrics = (Metrics)ctxt.getAttachment(KEY);
        if (metrics == null && (appearing = (Metrics)ctxt.putAttachmentIfAbsent(KEY, (Object)(metrics = new Metrics()))) != null) {
            metrics = appearing;
        }
        return metrics;
    }

    public Timer getOrCreateRootTimer(String name) {
        Timer appearing;
        Assert.checkNotNullParam((String)"name", (Object)name);
        Timer metric = this.timers.get(name);
        if (metric == null && (appearing = this.timers.putIfAbsent(name, metric = new Timer(name, null))) != null) {
            metric = appearing;
        }
        return metric;
    }

    public MemorySizeMetric getOrCreateRootMemorySizeMetric(String name) {
        MemorySizeMetric appearing;
        Assert.checkNotNullParam((String)"name", (Object)name);
        MemorySizeMetric metric = this.memorySizes.get(name);
        if (metric == null && (appearing = this.memorySizes.putIfAbsent(name, metric = new MemorySizeMetric(name, null))) != null) {
            metric = appearing;
        }
        return metric;
    }

    public CountMetric getOrCreateRootCountMetric(String name) {
        CountMetric appearing;
        Assert.checkNotNullParam((String)"name", (Object)name);
        CountMetric metric = this.counts.get(name);
        if (metric == null && (appearing = this.counts.putIfAbsent(name, metric = new CountMetric(name, null))) != null) {
            metric = appearing;
        }
        return metric;
    }

    public StringBuilder formatAll(StringBuilder target) {
        this.formatAllOf(target, this.timers);
        this.formatAllOf(target, this.memorySizes);
        this.formatAllOf(target, this.counts);
        return target;
    }

    private void formatAllOf(StringBuilder target, Map<String, ? extends Metric<?>> map) {
        for (Metric<?> metric : map.values()) {
            this.formatMetric(target, metric, 0);
        }
    }

    private void formatMetric(StringBuilder target, Metric<?> metric, int depth) {
        this.tab(target, depth);
        target.append(metric.getName()).append(':').append('\t');
        metric.getFormattedValue(target);
        target.append(System.lineSeparator());
        for (Metric child : metric.getChildren()) {
            this.formatMetric(target, child, depth + 1);
        }
    }

    private void tab(StringBuilder target, int count) {
        for (int i = 0; i < count; ++i) {
            target.append('\t');
        }
    }
}

