/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.metrics;

import io.smallrye.common.constraint.Assert;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Metric<M extends Metric<M>> {
    private final String name;
    private final M parent;
    private final AtomicLong cnt = new AtomicLong();
    private final Map<String, M> children = new ConcurrentHashMap<String, M>();

    Metric(String name, M parent) {
        this.name = name;
        this.parent = parent;
    }

    abstract M constructChild(String var1);

    public final M getOrAddChild(String name) {
        Metric appearing;
        Assert.checkNotNullParam((String)"name", (Object)name);
        Metric<M> child = (Metric)this.children.get(name);
        if (child == null && (appearing = this.children.putIfAbsent(name, child = this.constructChild(name))) != null) {
            child = appearing;
        }
        return (M)child;
    }

    public M getOrAddChild(String ... names) {
        Metric<M> child = this;
        for (String name : names) {
            child = child.getOrAddChild(name);
        }
        return (M)child;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isChildOf(Metric<?> other) {
        return other != null && other.isParentOf(this);
    }

    public final boolean isParentOf(Metric<?> other) {
        return other != null && (other == this || this.isParentOf((Metric<?>)other.parent));
    }

    public final M getParent() {
        return this.parent;
    }

    public long getRawValue() {
        return this.cnt.get();
    }

    final void addRawValue(long amount) {
        this.cnt.getAndAdd(amount);
        M parent = this.getParent();
        if (parent != null) {
            ((Metric)parent).addRawValue(amount);
        }
    }

    public final Collection<M> getChildren() {
        return this.children.values();
    }

    public abstract StringBuilder getFormattedValue(StringBuilder var1);

    public final String getFormattedValue() {
        return this.getFormattedValue(new StringBuilder()).toString();
    }

    abstract String getDescription();

    public final StringBuilder toString(StringBuilder target) {
        M parent = this.getParent();
        if (parent != null) {
            ((Metric)parent).toString(target);
            target.append(":");
        } else {
            target.append(this.getDescription()).append(' ');
        }
        return target.append(this.name);
    }

    public final String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

