/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.metrics;

import org.qbicc.plugin.metrics.Metric;

public final class MemorySizeMetric
extends Metric<MemorySizeMetric> {
    MemorySizeMetric(String name, MemorySizeMetric parent) {
        super(name, parent);
    }

    @Override
    MemorySizeMetric constructChild(String name) {
        return new MemorySizeMetric(name, this);
    }

    public void add(long amount) {
        this.addRawValue(amount);
    }

    public void add(long amount, Scale scale) {
        this.addRawValue(amount << scale.getBitShift());
    }

    @Override
    String getDescription() {
        return "Size";
    }

    @Override
    public StringBuilder getFormattedValue(StringBuilder target) {
        long value = this.getRawValue();
        int ntz = Long.numberOfTrailingZeros(Long.highestOneBit(value));
        Scale scale = value == 0L ? Scale.BYTES : Scale.ofBits(ntz + 4);
        long scaled = value >>> scale.getBitShift();
        int frac = (int)((value >>> scale.prev().getBitShift() & 0x3FFL) * 1000L / 1000L);
        target.append(Long.toUnsignedString(scaled));
        if (frac >= 100) {
            if (frac % 100 == 0) {
                frac /= 100;
            } else if (frac % 10 == 0) {
                frac /= 10;
            }
            target.append('.').append(frac);
        } else if (frac >= 10) {
            if (frac % 10 == 0) {
                frac /= 10;
            }
            target.append('.').append('0').append(frac);
        } else if (frac >= 1) {
            target.append('.').append('0').append('0').append(frac);
        }
        return target.append(scale.getSuffix());
    }

    public static enum Scale {
        BYTES(0, 'B'),
        KILO(10, 'K'),
        MEGA(20, 'M'),
        GIGA(30, 'G'),
        TERA(40, 'T'),
        PETA(50, 'P'),
        EXA(60, 'E');

        static final Scale[] SCALES;
        public static final Scale MIN;
        public static final Scale MAX;
        private final int bitShift;
        private final char suffix;

        private Scale(int bitShift, char suffix) {
            this.bitShift = bitShift;
            this.suffix = suffix;
        }

        public int getBitShift() {
            return this.bitShift;
        }

        public char getSuffix() {
            return this.suffix;
        }

        public Scale next() {
            return this == MAX ? this : SCALES[this.ordinal() + 1];
        }

        public Scale prev() {
            return this == MIN ? this : SCALES[this.ordinal() - 1];
        }

        public static Scale min(Scale a, Scale b) {
            return a.compareTo(b) < 0 ? a : b;
        }

        public static Scale max(Scale a, Scale b) {
            return a.compareTo(b) > 0 ? a : b;
        }

        public static Scale ofUnsigned(long unsigned) {
            int ntz = Long.numberOfTrailingZeros(Long.highestOneBit(unsigned));
            return Scale.ofBits(ntz);
        }

        public static Scale ofBits(int bitCount) {
            int sc = bitCount / 10;
            if (sc < 0) {
                return MIN;
            }
            if (sc >= SCALES.length) {
                return MAX;
            }
            return SCALES[sc];
        }

        public static Scale of(String suffix) {
            if (suffix.length() == 1 || suffix.length() == 2 && Character.toUpperCase(suffix.charAt(1)) == 'B') {
                return Scale.of(suffix.charAt(0));
            }
            throw new IllegalArgumentException("Invalid suffix: " + suffix);
        }

        public static Scale of(char suffixChar) {
            suffixChar = Character.toUpperCase(suffixChar);
            switch (suffixChar) {
                case 'B': {
                    return BYTES;
                }
                case 'K': {
                    return KILO;
                }
                case 'M': {
                    return MEGA;
                }
                case 'G': {
                    return GIGA;
                }
                case 'T': {
                    return TERA;
                }
                case 'P': {
                    return PETA;
                }
                case 'E': {
                    return EXA;
                }
            }
            throw new IllegalArgumentException("Invalid suffix: " + suffixChar);
        }

        static {
            SCALES = Scale.values();
            MIN = SCALES[0];
            MAX = SCALES[SCALES.length - 1];
        }
    }
}

