/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.lowering;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.CurrentThread;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.ExecutableLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmString;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.ThreadLocalMode;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.plugin.dispatch.DispatchTables;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.plugin.serialization.BuildtimeHeap;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.TypeType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;

public class InvocationLoweringBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt;
    private final ExecutableElement originalElement;
    private final ReferenceType threadType;
    private boolean started;
    private BlockParameter thrParam;

    public InvocationLoweringBasicBlockBuilder(BasicBlockBuilder.FactoryContext fc, BasicBlockBuilder delegate) {
        super(delegate);
        CompilationContext ctxt;
        this.ctxt = ctxt = this.getContext();
        this.originalElement = delegate.getCurrentElement();
        this.threadType = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Thread").load().getClassType().getReference();
    }

    public Node begin(BlockLabel blockLabel) {
        Node node = super.begin(blockLabel);
        if (!this.started) {
            this.started = true;
            this.thrParam = this.addParam(blockLabel, Slot.thread(), (ValueType)this.threadType, false);
        }
        return node;
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        if (pointer instanceof CurrentThread) {
            return this.getCurrentThreadRef();
        }
        return super.load(pointer, accessMode);
    }

    public Value currentThread() {
        ExecutableElement executableElement = this.originalElement;
        if (executableElement instanceof FunctionElement) {
            FunctionElement fe = (FunctionElement)executableElement;
            ProgramModule programModule = this.ctxt.getOrAddProgramModule(fe.getEnclosingType());
            DataDeclaration decl = programModule.declareData(null, "_qbicc_bound_java_thread", (ValueType)this.threadType);
            decl.setThreadLocalMode(ThreadLocalMode.GENERAL_DYNAMIC);
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            return lf.literalOf((ProgramObject)decl);
        }
        return super.currentThread();
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        ArrayList<Value> argList = InvocationLoweringBasicBlockBuilder.copyArgList(arguments);
        return super.call(this.lower(targetPtr, receiver, argList), receiver, argList);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        ArrayList<Value> argList = InvocationLoweringBasicBlockBuilder.copyArgList(arguments);
        return super.callNoSideEffects(this.lower(targetPtr, receiver, argList), receiver, argList);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        ArrayList<Value> argList = InvocationLoweringBasicBlockBuilder.copyArgList(arguments);
        return super.callNoReturn(this.lower(targetPtr, receiver, argList), receiver, argList);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        ArrayList<Value> argList = InvocationLoweringBasicBlockBuilder.copyArgList(arguments);
        return super.invokeNoReturn(this.lower(targetPtr, receiver, argList), receiver, argList, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        ArrayList<Value> argList = InvocationLoweringBasicBlockBuilder.copyArgList(arguments);
        return super.tailCall(this.lower(targetPtr, receiver, argList), receiver, argList);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        ArrayList<Value> argList = InvocationLoweringBasicBlockBuilder.copyArgList(arguments);
        return super.invoke(this.lower(targetPtr, receiver, argList), receiver, argList, catchLabel, resumeLabel, targetArguments);
    }

    private static ArrayList<Value> copyArgList(List<Value> arguments) {
        ArrayList<Value> list = new ArrayList<Value>(arguments.size() + 2);
        list.addAll(arguments);
        return list;
    }

    private Value lower(Value targetPtr, Value receiver, ArrayList<Value> args) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        InvokableType invType = (InvokableType)targetPtr.getPointeeType(InvokableType.class);
        if (!(invType instanceof FunctionType)) {
            args.add(0, fb.load(fb.currentThread()));
            if (invType instanceof InstanceMethodType) {
                args.add(1, receiver);
            }
        }
        if (targetPtr instanceof ExecutableLiteral) {
            ExecutableLiteral el = (ExecutableLiteral)targetPtr;
            ExecutableElement element = el.getExecutable();
            if (!element.hasMethodBodyFactory() && element.hasAllModifiersOf(256)) {
                throw new BlockEarlyTermination(this.raiseLinkError((MethodElement)element));
            }
            if (!this.ctxt.mayBeEnqueued(element)) {
                throw new BlockEarlyTermination(this.unreachable());
            }
            this.ctxt.enqueue(element);
            Function function = this.ctxt.getExactFunction(element);
            FunctionDeclaration decl = this.ctxt.getOrAddProgramModule((MemberElement)this.originalElement).declareFunction(function);
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            return lf.literalOf((ProgramObject)decl);
        }
        FunctionType lowerInvType = this.ctxt.getFunctionTypeForInvokableType(invType);
        return invType == lowerInvType ? targetPtr : this.bitCast(targetPtr, (WordType)lowerInvType.getPointer());
    }

    public Value lookupVirtualMethod(Value reference, InstanceMethodElement target) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        LiteralFactory lf = this.getLiteralFactory();
        if (!ReachabilityInfo.get((CompilationContext)this.ctxt).isDispatchableMethod((MethodElement)target)) {
            return lf.nullLiteralOfType((NullableType)target.getType().getPointer());
        }
        DispatchTables dt = DispatchTables.get((CompilationContext)this.ctxt);
        DispatchTables.VTableInfo info = dt.getVTableInfo(target.getEnclosingType().load());
        Assert.assertNotNull((Object)info);
        GlobalVariableElement vtables = dt.getVTablesGlobal();
        if (!vtables.getEnclosingType().equals(this.originalElement.getEnclosingType())) {
            ProgramModule programModule = this.ctxt.getOrAddProgramModule(this.originalElement.getEnclosingType());
            programModule.declareData(null, vtables.getName(), vtables.getType());
        }
        int index = dt.getVTableIndex((MethodElement)target);
        Value typeId = fb.load(this.instanceFieldOf(fb.decodeReference(reference), CoreClasses.get((CompilationContext)this.ctxt).getObjectTypeIdField()));
        Value vtable = fb.load(this.elementOf((Value)lf.literalOf(dt.getVTablesGlobal()), typeId));
        return fb.load(this.memberOf(this.bitCast(vtable, (WordType)info.getType().getPointer()), info.getType().getMember(index)));
    }

    public Value lookupInterfaceMethod(Value reference, InstanceMethodElement target) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        LiteralFactory lf = this.getLiteralFactory();
        DispatchTables dt = DispatchTables.get((CompilationContext)this.ctxt);
        DispatchTables.ITableInfo info = dt.getITableInfo(target.getEnclosingType().load());
        if (info == null) {
            return lf.nullLiteralOfType((NullableType)target.getType().getPointer());
        }
        ProgramModule programModule = this.ctxt.getOrAddProgramModule(this.originalElement.getEnclosingType());
        GlobalVariableElement rootITables = dt.getITablesGlobal();
        if (!rootITables.getEnclosingType().equals(this.originalElement.getEnclosingType())) {
            programModule.declareData(null, rootITables.getName(), rootITables.getType());
        }
        Value typeId = fb.load(this.instanceFieldOf(fb.decodeReference(reference), CoreClasses.get((CompilationContext)this.ctxt).getObjectTypeIdField()));
        Value itableDict = fb.load(this.elementOf((Value)lf.literalOf(rootITables), typeId));
        BlockLabel failLabel = new BlockLabel();
        BlockLabel checkForICCE = new BlockLabel();
        BlockLabel exitMatched = new BlockLabel();
        BlockLabel loop = new BlockLabel();
        TypeSystem ts = this.ctxt.getTypeSystem();
        SignedIntegerType u32 = ts.getSignedInteger32Type();
        IntegerLiteral zero = lf.literalOf((IntegerType)u32, 0L);
        this.goto_(loop, Slot.temp((int)0), (Value)zero);
        this.begin(loop);
        BlockParameter bp = this.addParam(loop, Slot.temp((int)0), (ValueType)u32);
        Value candidateId = fb.load(fb.memberOf(fb.elementOf(itableDict, (Value)bp), dt.getItableDictType().getMember("typeId")));
        this.if_(this.isEq(candidateId, (Value)lf.literalOf(info.getInterface().getTypeId())), exitMatched, checkForICCE, Map.of());
        try {
            this.begin(checkForICCE);
            TypeType typeType = info.getInterface().getObjectType().getTypeType();
            this.if_(this.isEq(candidateId, (Value)lf.zeroInitializerLiteralOfType((ValueType)typeType)), failLabel, loop, Map.of(Slot.temp((int)0), fb.add((Value)bp, (Value)lf.literalOf((IntegerType)u32, 1L))));
            this.begin(failLabel);
            MethodElement method = RuntimeMethodFinder.get((CompilationContext)this.ctxt).getMethod("raiseIncompatibleClassChangeError");
            this.callNoReturn((Value)lf.literalOf(method), List.of());
        }
        catch (BlockEarlyTermination typeType) {
            // empty catch block
        }
        this.begin(exitMatched);
        Value itable = fb.bitCast(fb.load(fb.memberOf(fb.elementOf(itableDict, (Value)bp), dt.getItableDictType().getMember("itable"))), (WordType)info.getType().getPointer());
        return fb.load(this.memberOf(itable, info.getType().getMember(dt.getITableIndex((MethodElement)target))));
    }

    private Value getCurrentThreadRef() {
        BasicBlockBuilder fb = this.getFirstBuilder();
        ExecutableElement executableElement = this.originalElement;
        if (executableElement instanceof FunctionElement) {
            FunctionElement fe = (FunctionElement)executableElement;
            ProgramModule programModule = this.ctxt.getOrAddProgramModule(fe.getEnclosingType());
            DataDeclaration decl = programModule.declareData(null, "_qbicc_bound_java_thread", (ValueType)this.threadType);
            decl.setThreadLocalMode(ThreadLocalMode.GENERAL_DYNAMIC);
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            return fb.load((Value)lf.literalOf((ProgramObject)decl), (ReadAccessMode)AccessModes.SingleUnshared);
        }
        return this.thrParam;
    }

    private BasicBlock raiseLinkError(MethodElement target) {
        VmString vString = this.ctxt.getVm().intern(target.getEnclosingType().getInternalName().replace("/", ".") + "." + target.getName());
        BuildtimeHeap bth = BuildtimeHeap.get((CompilationContext)this.ctxt);
        bth.serializeVmObject((VmObject)vString, true);
        Literal arg = bth.referToSerializedVmObject((VmObject)vString, (NullableType)this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load().getObjectType().getReference(), this.ctxt.getOrAddProgramModule((MemberElement)this.originalElement));
        MethodElement helper = RuntimeMethodFinder.get((CompilationContext)this.ctxt).getMethod("raiseUnsatisfiedLinkError");
        return this.callNoReturn((Value)this.getLiteralFactory().literalOf(helper), List.of(arg));
    }
}

