/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.intrinsics.core;

import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.Phase;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.GlobalReadWriteAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.InstanceMethodLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.plugin.intrinsics.InstanceIntrinsic;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.type.IntegerType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class UnsafeIntrinsics {
    public static void register(CompilationContext ctxt) {
        UnsafeIntrinsics.registerEmptyLateIntrinsics(ctxt);
        UnsafeIntrinsics.registerUnsafeConstantsIntrinsics(ctxt);
        UnsafeIntrinsics.registerCompareAndExchangeIntrinsics(ctxt);
        UnsafeIntrinsics.registerCompareAndSetIntrinsics(ctxt);
        UnsafeIntrinsics.registerGetAndModIntrinsics(ctxt);
        UnsafeIntrinsics.registerGetIntrinsics(ctxt);
        UnsafeIntrinsics.registerPutIntrinsics(ctxt);
        UnsafeIntrinsics.registerFenceIntrinsics(ctxt);
        UnsafeIntrinsics.registerFieldAndArrayIntrinsics(ctxt);
    }

    private static void registerEmptyLateIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor classDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        MethodDescriptor classToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(classDesc));
        MethodDescriptor classToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(classDesc));
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)unsafeDesc, "ensureClassInitialized", classToVoid, (builder, targetPtr, arguments) -> ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)ctxt.getTypeSystem().getVoidType()));
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)unsafeDesc, "shouldBeInitialized0", classToBool, (builder, instance, targetPtr, arguments) -> ctxt.getLiteralFactory().literalOf(false));
    }

    private static void registerUnsafeConstantsIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/UnsafeConstants");
        MethodDescriptor voidToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of());
        MethodDescriptor voidToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "targetAddressSize", voidToInt, (builder, targetPtr, arguments) -> ctxt.getLiteralFactory().literalOf((IntegerType)ctxt.getTypeSystem().getSignedInteger32Type(), (long)ctxt.getTypeSystem().getPointerSize()));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "targetBigEndian", voidToBool, (builder, targetPtr, arguments) -> ctxt.getLiteralFactory().literalOf(ctxt.getTypeSystem().getEndianness().equals(ByteOrder.BIG_ENDIAN)));
    }

    private static MethodDescriptor getCompareAndExchangeDesc(ClassContext classContext, TypeDescriptor type) {
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)type, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object"), BaseTypeDescriptor.J, type, type));
    }

    private static Value doCompareAndExchange(CompilationContext ctxt, BasicBlockBuilder builder, List<Value> arguments, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        Value obj = arguments.get(0);
        Value offset = arguments.get(1);
        Value expect = arguments.get(2);
        Value update = arguments.get(3);
        ValueType expectType = expect.getType();
        if (expectType instanceof ReferenceType) {
            ObjectType objectType = CoreClasses.get((CompilationContext)ctxt).getObjectTypeIdField().getEnclosingType().load().getObjectType();
            expectType = objectType.getReference();
        }
        Value handle = builder.byteOffsetPointer(builder.decodeReference(obj), offset, expectType);
        Value result = builder.cmpAndSwap(handle, expect, update, readMode, writeMode, strength);
        return builder.extractMember(result, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)expectType).getMember(0));
    }

    private static void registerCompareAndExchangeIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeInt", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeIntAcquire", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeIntRelease", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeLong", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeLongAcquire", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeLongRelease", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeObject", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeObjectAcquire", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndExchangeObjectRelease", UnsafeIntrinsics.getCompareAndExchangeDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndExchange(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.STRONG));
    }

    private static MethodDescriptor getCompareAndSetDesc(ClassContext classContext, TypeDescriptor type) {
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object"), BaseTypeDescriptor.J, type, type));
    }

    private static Value doCompareAndSet(CompilationContext ctxt, BasicBlockBuilder builder, List<Value> arguments, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        Value obj = arguments.get(0);
        Value offset = arguments.get(1);
        Value expect = arguments.get(2);
        Value update = arguments.get(3);
        ValueType expectType = expect.getType();
        if (expectType instanceof ReferenceType) {
            ObjectType objectType = CoreClasses.get((CompilationContext)ctxt).getObjectTypeIdField().getEnclosingType().load().getObjectType();
            expectType = objectType.getReference();
        }
        Value handle = builder.byteOffsetPointer(builder.decodeReference(obj), offset, expectType);
        Value result = builder.cmpAndSwap(handle, expect, update, readMode, writeMode, strength);
        return builder.extractMember(result, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)expectType).getMember(1));
    }

    private static void registerCompareAndSetIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndSetInt", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndSetLong", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndSetObject", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "compareAndSetReference", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.STRONG));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetInt", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetIntAcquire", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetIntPlain", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SinglePlain, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetIntRelease", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.I), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetLong", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetLongAcquire", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetLongPlain", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetLongRelease", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)BaseTypeDescriptor.J), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetObject", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetObjectAcquire", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetObjectPlain", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetObjectRelease", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetReference", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalSeqCst, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetReferenceAcquire", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetReferencePlain", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.WEAK));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "weakCompareAndSetReferenceRelease", UnsafeIntrinsics.getCompareAndSetDesc(classContext, (TypeDescriptor)objDesc), (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doCompareAndSet(ctxt, builder, arguments, (ReadAccessMode)AccessModes.SingleOpaque, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.WEAK));
    }

    private static MethodDescriptor getGetAndBinOpDesc(ClassContext classContext, TypeDescriptor type) {
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)type, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object"), BaseTypeDescriptor.J, type));
    }

    private static Value doGetAndModify(CompilationContext ctxt, BasicBlockBuilder builder, ReadModifyWrite.Op op, List<Value> arguments, ReadAccessMode readMode, WriteAccessMode writeMode) {
        Value obj = arguments.get(0);
        Value offset = arguments.get(1);
        Value operand = arguments.get(2);
        ValueType operandType = operand.getType();
        if (operandType instanceof ReferenceType) {
            ObjectType objectType = CoreClasses.get((CompilationContext)ctxt).getObjectTypeIdField().getEnclosingType().load().getObjectType();
            operandType = objectType.getReference();
        }
        Value handle = builder.byteOffsetPointer(builder.decodeReference(obj), offset, operandType);
        return builder.readModifyWrite(handle, op, operand, readMode, writeMode);
    }

    private static void registerGetAndModIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        for (Map.Entry<String, BaseTypeDescriptor> typeNameAndDesc : Map.of("Int", BaseTypeDescriptor.I, "Long", BaseTypeDescriptor.J).entrySet()) {
            for (Map.Entry<String, ReadModifyWrite.Op> nameAndOp : Map.of("Add", ReadModifyWrite.Op.ADD, "BitwiseAnd", ReadModifyWrite.Op.BITWISE_AND, "BitwiseOr", ReadModifyWrite.Op.BITWISE_OR, "BitwiseXor", ReadModifyWrite.Op.BITWISE_XOR, "Set", ReadModifyWrite.Op.SET).entrySet()) {
                for (Map.Entry<String, AccessMode[]> suffixAndMode : Map.of("", new AccessMode[]{AccessModes.GlobalSeqCst, AccessModes.GlobalSeqCst}, "Acquire", new AccessMode[]{AccessModes.GlobalAcquire, AccessModes.SingleOpaque}, "Release", new AccessMode[]{AccessModes.SingleOpaque, AccessModes.GlobalRelease}).entrySet()) {
                    String name = "getAnd" + nameAndOp.getKey() + typeNameAndDesc.getKey() + suffixAndMode.getKey();
                    MethodDescriptor desc = UnsafeIntrinsics.getGetAndBinOpDesc(classContext, (TypeDescriptor)typeNameAndDesc.getValue());
                    intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, name, desc, (builder, instance, targetPtr, arguments) -> UnsafeIntrinsics.doGetAndModify(ctxt, builder, (ReadModifyWrite.Op)nameAndOp.getValue(), arguments, (ReadAccessMode)((AccessMode[])suffixAndMode.getValue())[0], (WriteAccessMode)((AccessMode[])suffixAndMode.getValue())[1]));
                }
            }
        }
    }

    private static MethodDescriptor getGetOpDesc(ClassContext classContext, TypeDescriptor type) {
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)type, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object"), BaseTypeDescriptor.J));
    }

    private static void registerGetIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        TypeSystem ts = ctxt.getTypeSystem();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        Map<ClassTypeDescriptor, ReferenceType> typeLookup = Map.of(BaseTypeDescriptor.B, ts.getSignedInteger8Type(), BaseTypeDescriptor.S, ts.getSignedInteger16Type(), BaseTypeDescriptor.I, ts.getSignedInteger32Type(), BaseTypeDescriptor.J, ts.getSignedInteger64Type(), BaseTypeDescriptor.Z, ts.getUnsignedInteger8Type(), BaseTypeDescriptor.C, ts.getUnsignedInteger16Type(), BaseTypeDescriptor.F, ts.getFloat32Type(), BaseTypeDescriptor.D, ts.getFloat64Type(), objDesc, CoreClasses.get((CompilationContext)ctxt).getObjectTypeIdField().getEnclosingType().load().getObjectType().getReference());
        for (Map.Entry<String, ClassTypeDescriptor> typeNameAndDesc : Map.of("Byte", BaseTypeDescriptor.B, "Short", BaseTypeDescriptor.S, "Int", BaseTypeDescriptor.I, "Long", BaseTypeDescriptor.J, "Boolean", BaseTypeDescriptor.Z, "Char", BaseTypeDescriptor.C, "Float", BaseTypeDescriptor.F, "Double", BaseTypeDescriptor.D, "Object", objDesc, "Reference", objDesc).entrySet()) {
            for (Map.Entry<String, GlobalReadWriteAccessMode> suffixAndMode : Map.of("", AccessModes.SinglePlain, "Acquire", AccessModes.GlobalAcquire, "Opaque", AccessModes.SingleOpaque, "Volatile", AccessModes.GlobalSeqCst).entrySet()) {
                String name = "get" + typeNameAndDesc.getKey() + suffixAndMode.getKey();
                MethodDescriptor desc = UnsafeIntrinsics.getGetOpDesc(classContext, (TypeDescriptor)typeNameAndDesc.getValue());
                ValueType outputType = (ValueType)typeLookup.get(typeNameAndDesc.getValue());
                intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, name, desc, (builder, instance, targetPtr, arguments) -> {
                    Value obj = (Value)arguments.get(0);
                    Value offset = (Value)arguments.get(1);
                    Value handle = builder.byteOffsetPointer(builder.decodeReference(obj), offset, outputType);
                    return builder.load(handle, (ReadAccessMode)suffixAndMode.getValue());
                });
            }
        }
    }

    private static MethodDescriptor getPutOpDesc(ClassContext classContext, TypeDescriptor type) {
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object"), BaseTypeDescriptor.J, type));
    }

    private static void registerPutIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        TypeSystem ts = ctxt.getTypeSystem();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        Literal voidLiteral = ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        Map<ClassTypeDescriptor, ReferenceType> typeLookup = Map.of(BaseTypeDescriptor.B, ts.getSignedInteger8Type(), BaseTypeDescriptor.S, ts.getSignedInteger16Type(), BaseTypeDescriptor.I, ts.getSignedInteger32Type(), BaseTypeDescriptor.J, ts.getSignedInteger64Type(), BaseTypeDescriptor.Z, ts.getUnsignedInteger8Type(), BaseTypeDescriptor.C, ts.getUnsignedInteger16Type(), BaseTypeDescriptor.F, ts.getFloat32Type(), BaseTypeDescriptor.D, ts.getFloat64Type(), objDesc, CoreClasses.get((CompilationContext)ctxt).getObjectTypeIdField().getEnclosingType().load().getObjectType().getReference());
        for (Map.Entry<String, ClassTypeDescriptor> typeNameAndDesc : Map.of("Byte", BaseTypeDescriptor.B, "Short", BaseTypeDescriptor.S, "Int", BaseTypeDescriptor.I, "Long", BaseTypeDescriptor.J, "Boolean", BaseTypeDescriptor.Z, "Char", BaseTypeDescriptor.C, "Float", BaseTypeDescriptor.F, "Double", BaseTypeDescriptor.D, "Object", objDesc, "Reference", objDesc).entrySet()) {
            for (Map.Entry<String, GlobalReadWriteAccessMode> suffixAndMode : Map.of("", AccessModes.SinglePlain, "Release", AccessModes.GlobalRelease, "Opaque", AccessModes.SingleOpaque, "Volatile", AccessModes.GlobalSeqCst).entrySet()) {
                String name = "put" + typeNameAndDesc.getKey() + suffixAndMode.getKey();
                MethodDescriptor desc = UnsafeIntrinsics.getPutOpDesc(classContext, (TypeDescriptor)typeNameAndDesc.getValue());
                ValueType valueType = (ValueType)typeLookup.get(typeNameAndDesc.getValue());
                intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, name, desc, (builder, instance, targetPtr, arguments) -> {
                    Value obj = (Value)arguments.get(0);
                    Value offset = (Value)arguments.get(1);
                    Value value = (Value)arguments.get(2);
                    if (((TypeDescriptor)typeNameAndDesc.getValue()).equals((TypeDescriptor)BaseTypeDescriptor.Z)) {
                        value = builder.select(value, (Value)ctxt.getLiteralFactory().literalOf((IntegerType)valueType, 1L), (Value)ctxt.getLiteralFactory().literalOf((IntegerType)valueType, 0L));
                    }
                    Value handle = builder.byteOffsetPointer(builder.decodeReference(obj), offset, valueType);
                    builder.store(handle, value, (WriteAccessMode)suffixAndMode.getValue());
                    return voidLiteral;
                });
            }
        }
    }

    private static void registerFenceIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        MethodDescriptor emptyToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of());
        record FenceIntrinsic(GlobalAccessMode mode) implements InstanceIntrinsic
        {
            @Override
            public Value emitIntrinsic(BasicBlockBuilder builder, Value instance, InstanceMethodLiteral targetPtr, List<Value> arguments) {
                builder.fence(this.mode);
                ClassContext context = builder.getCurrentElement().getEnclosingType().getContext();
                return context.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)context.getTypeSystem().getVoidType());
            }
        }
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "storeFence", emptyToVoid, (InstanceIntrinsic)new FenceIntrinsic((GlobalAccessMode)AccessModes.GlobalRelease));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "storeStoreFence", emptyToVoid, (InstanceIntrinsic)new FenceIntrinsic(AccessModes.GlobalStoreStore));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "loadFence", emptyToVoid, (InstanceIntrinsic)new FenceIntrinsic((GlobalAccessMode)AccessModes.GlobalAcquire));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "loadLoadFence", emptyToVoid, (InstanceIntrinsic)new FenceIntrinsic(AccessModes.GlobalLoadLoad));
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "fullFence", emptyToVoid, (InstanceIntrinsic)new FenceIntrinsic((GlobalAccessMode)AccessModes.GlobalSeqCst));
    }

    private static void registerFieldAndArrayIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor unsafeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/misc/Unsafe");
        ClassTypeDescriptor classDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor stringDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        MethodDescriptor classToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(classDesc));
        MethodDescriptor classStringToLong = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(classDesc, stringDesc));
        InstanceIntrinsic arrayBaseOffset = (builder, instance, target, arguments) -> {
            CoreClasses coreClasses = CoreClasses.get((CompilationContext)ctxt);
            LiteralFactory lf = ctxt.getLiteralFactory();
            InstanceFieldElement refArrayContentField = coreClasses.getRefArrayContentField();
            InstanceFieldElement booleanArrayContentField = coreClasses.getBooleanArrayContentField();
            InstanceFieldElement byteArrayContentField = coreClasses.getByteArrayContentField();
            InstanceFieldElement shortArrayContentField = coreClasses.getShortArrayContentField();
            InstanceFieldElement intArrayContentField = coreClasses.getIntArrayContentField();
            InstanceFieldElement longArrayContentField = coreClasses.getLongArrayContentField();
            InstanceFieldElement charArrayContentField = coreClasses.getCharArrayContentField();
            InstanceFieldElement floatArrayContentField = coreClasses.getFloatArrayContentField();
            InstanceFieldElement doubleArrayContentField = coreClasses.getDoubleArrayContentField();
            BlockLabel isRef = new BlockLabel();
            BlockLabel isNotRef = new BlockLabel();
            BlockLabel isBool = new BlockLabel();
            BlockLabel isNotBool = new BlockLabel();
            BlockLabel isByte = new BlockLabel();
            BlockLabel isNotByte = new BlockLabel();
            BlockLabel isShort = new BlockLabel();
            BlockLabel isNotShort = new BlockLabel();
            BlockLabel isInt = new BlockLabel();
            BlockLabel isNotInt = new BlockLabel();
            BlockLabel isLong = new BlockLabel();
            BlockLabel isNotLong = new BlockLabel();
            BlockLabel isChar = new BlockLabel();
            BlockLabel isNotChar = new BlockLabel();
            BlockLabel isFloat = new BlockLabel();
            BlockLabel isNotFloat = new BlockLabel();
            BlockLabel isDouble = new BlockLabel();
            BlockLabel isNotDouble = new BlockLabel();
            Value classDims = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassDimensionField()));
            Value isRefBool = builder.isNe(classDims, (Value)lf.zeroInitializerLiteralOfType(classDims.getType()));
            builder.if_(isRefBool, isRef, isNotRef, Map.of());
            builder.begin(isRef);
            builder.return_(builder.offsetOfField((FieldElement)refArrayContentField));
            builder.begin(isNotRef);
            Value typeId = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassTypeIdField()));
            Value isBoolBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)booleanArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isBoolBool, isBool, isNotBool, Map.of());
            builder.begin(isBool);
            builder.return_(builder.offsetOfField((FieldElement)booleanArrayContentField));
            builder.begin(isNotBool);
            Value isByteBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)byteArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isByteBool, isByte, isNotByte, Map.of());
            builder.begin(isByte);
            builder.return_(builder.offsetOfField((FieldElement)byteArrayContentField));
            builder.begin(isNotByte);
            Value isShortBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)shortArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isShortBool, isShort, isNotShort, Map.of());
            builder.begin(isShort);
            builder.return_(builder.offsetOfField((FieldElement)shortArrayContentField));
            builder.begin(isNotShort);
            Value isIntBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)intArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isIntBool, isInt, isNotInt, Map.of());
            builder.begin(isInt);
            builder.return_(builder.offsetOfField((FieldElement)intArrayContentField));
            builder.begin(isNotInt);
            Value isLongBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)longArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isLongBool, isLong, isNotLong, Map.of());
            builder.begin(isLong);
            builder.return_(builder.offsetOfField((FieldElement)longArrayContentField));
            builder.begin(isNotLong);
            Value isCharBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)charArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isCharBool, isChar, isNotChar, Map.of());
            builder.begin(isChar);
            builder.return_(builder.offsetOfField((FieldElement)charArrayContentField));
            builder.begin(isNotChar);
            Value isFloatBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)floatArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isFloatBool, isFloat, isNotFloat, Map.of());
            builder.begin(isFloat);
            builder.return_(builder.offsetOfField((FieldElement)floatArrayContentField));
            builder.begin(isNotFloat);
            Value isDoubleBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)doubleArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isDoubleBool, isDouble, isNotDouble, Map.of());
            builder.begin(isDouble);
            builder.return_(builder.offsetOfField((FieldElement)doubleArrayContentField));
            builder.begin(isNotDouble);
            MethodElement throwCce = RuntimeMethodFinder.get((CompilationContext)ctxt).getMethod("raiseClassCastException");
            throw new BlockEarlyTermination(builder.callNoReturn((Value)lf.literalOf(throwCce), List.of()));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "arrayBaseOffset0", classToInt, arrayBaseOffset);
        InstanceIntrinsic arrayIndexScale = (builder, instance, target, arguments) -> {
            CoreClasses coreClasses = CoreClasses.get((CompilationContext)ctxt);
            LiteralFactory lf = ctxt.getLiteralFactory();
            InstanceFieldElement booleanArrayContentField = coreClasses.getBooleanArrayContentField();
            InstanceFieldElement byteArrayContentField = coreClasses.getByteArrayContentField();
            InstanceFieldElement shortArrayContentField = coreClasses.getShortArrayContentField();
            InstanceFieldElement intArrayContentField = coreClasses.getIntArrayContentField();
            InstanceFieldElement longArrayContentField = coreClasses.getLongArrayContentField();
            InstanceFieldElement charArrayContentField = coreClasses.getCharArrayContentField();
            InstanceFieldElement floatArrayContentField = coreClasses.getFloatArrayContentField();
            InstanceFieldElement doubleArrayContentField = coreClasses.getDoubleArrayContentField();
            BlockLabel isRef = new BlockLabel();
            BlockLabel isNotRef = new BlockLabel();
            BlockLabel isBool = new BlockLabel();
            BlockLabel isNotBool = new BlockLabel();
            BlockLabel isByte = new BlockLabel();
            BlockLabel isNotByte = new BlockLabel();
            BlockLabel isShort = new BlockLabel();
            BlockLabel isNotShort = new BlockLabel();
            BlockLabel isInt = new BlockLabel();
            BlockLabel isNotInt = new BlockLabel();
            BlockLabel isLong = new BlockLabel();
            BlockLabel isNotLong = new BlockLabel();
            BlockLabel isChar = new BlockLabel();
            BlockLabel isNotChar = new BlockLabel();
            BlockLabel isFloat = new BlockLabel();
            BlockLabel isNotFloat = new BlockLabel();
            BlockLabel isDouble = new BlockLabel();
            BlockLabel isNotDouble = new BlockLabel();
            Value classDims = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassDimensionField()));
            Value isRefBool = builder.isNe(classDims, (Value)lf.zeroInitializerLiteralOfType(classDims.getType()));
            builder.if_(isRefBool, isRef, isNotRef, Map.of());
            builder.begin(isRef);
            builder.return_((Value)lf.literalOf(ctxt.getTypeSystem().getReferenceSize()));
            builder.begin(isNotRef);
            Value typeId = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassTypeIdField()));
            Value isBoolBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)booleanArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isBoolBool, isBool, isNotBool, Map.of());
            builder.begin(isBool);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getBooleanType().getSize()));
            builder.begin(isNotBool);
            Value isByteBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)byteArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isByteBool, isByte, isNotByte, Map.of());
            builder.begin(isByte);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getSignedInteger8Type().getSize()));
            builder.begin(isNotByte);
            Value isShortBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)shortArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isShortBool, isShort, isNotShort, Map.of());
            builder.begin(isShort);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getSignedInteger16Type().getSize()));
            builder.begin(isNotShort);
            Value isIntBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)intArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isIntBool, isInt, isNotInt, Map.of());
            builder.begin(isInt);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getSignedInteger32Type().getSize()));
            builder.begin(isNotInt);
            Value isLongBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)longArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isLongBool, isLong, isNotLong, Map.of());
            builder.begin(isLong);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getSignedInteger64Type().getSize()));
            builder.begin(isNotLong);
            Value isCharBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)charArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isCharBool, isChar, isNotChar, Map.of());
            builder.begin(isChar);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getUnsignedInteger16Type().getSize()));
            builder.begin(isNotChar);
            Value isFloatBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)floatArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isFloatBool, isFloat, isNotFloat, Map.of());
            builder.begin(isFloat);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getFloat32Type().getSize()));
            builder.begin(isNotFloat);
            Value isDoubleBool = builder.isEq(typeId, (Value)lf.literalOfType((ValueType)doubleArrayContentField.getEnclosingType().load().getObjectType()));
            builder.if_(isDoubleBool, isDouble, isNotDouble, Map.of());
            builder.begin(isDouble);
            builder.return_((Value)lf.literalOf((int)ctxt.getTypeSystem().getFloat64Type().getSize()));
            builder.begin(isNotDouble);
            MethodElement throwCce = RuntimeMethodFinder.get((CompilationContext)ctxt).getMethod("raiseClassCastException");
            throw new BlockEarlyTermination(builder.callNoReturn((Value)lf.literalOf(throwCce), List.of()));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)unsafeDesc, "arrayIndexScale0", classToInt, arrayIndexScale);
    }
}

