/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.intrinsics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.Phase;
import org.qbicc.plugin.intrinsics.InstanceIntrinsic;
import org.qbicc.plugin.intrinsics.StaticIntrinsic;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class Intrinsics {
    private static final AttachmentKey<Intrinsics> KEY = new AttachmentKey();
    private final Map<Phase, Map<TypeDescriptor, Map<String, Map<MethodDescriptor, StaticIntrinsic>>>> staticIntrinsics = new ConcurrentHashMap<Phase, Map<TypeDescriptor, Map<String, Map<MethodDescriptor, StaticIntrinsic>>>>();
    private final Map<Phase, Map<TypeDescriptor, Map<String, StaticIntrinsic>>> wildCardStaticIntrinsics = new ConcurrentHashMap<Phase, Map<TypeDescriptor, Map<String, StaticIntrinsic>>>();
    private final Map<Phase, Map<TypeDescriptor, Map<String, Map<MethodDescriptor, InstanceIntrinsic>>>> instanceIntrinsics = new ConcurrentHashMap<Phase, Map<TypeDescriptor, Map<String, Map<MethodDescriptor, InstanceIntrinsic>>>>();
    private final Map<Phase, Map<TypeDescriptor, Map<String, InstanceIntrinsic>>> wildCardInstanceIntrinsics = new ConcurrentHashMap<Phase, Map<TypeDescriptor, Map<String, InstanceIntrinsic>>>();

    private Intrinsics() {
    }

    public static Intrinsics get(CompilationContext ctxt) {
        return (Intrinsics)ctxt.computeAttachmentIfAbsent(KEY, Intrinsics::new);
    }

    private static <K, V> Map<K, V> map(Object ignored) {
        return new ConcurrentHashMap();
    }

    public boolean registerIntrinsic(TypeDescriptor owner, String name, MethodDescriptor desc, StaticIntrinsic intrinsic) {
        return this.registerIntrinsic(Phase.ADD, owner, name, desc, intrinsic);
    }

    public boolean registerIntrinsic(TypeDescriptor owner, String name, StaticIntrinsic intrinsic) {
        return this.registerIntrinsic(Phase.ADD, owner, name, intrinsic);
    }

    public boolean registerIntrinsic(Phase phase, TypeDescriptor owner, String name, MethodDescriptor desc, StaticIntrinsic intrinsic) {
        return this.staticIntrinsics.computeIfAbsent(phase, Intrinsics::map).computeIfAbsent(owner, Intrinsics::map).computeIfAbsent(name, Intrinsics::map).putIfAbsent(desc, intrinsic) != null;
    }

    private boolean registerIntrinsic(Phase phase, TypeDescriptor owner, String name, StaticIntrinsic intrinsic) {
        return this.wildCardStaticIntrinsics.computeIfAbsent(phase, Intrinsics::map).computeIfAbsent(owner, Intrinsics::map).putIfAbsent(name, intrinsic) != null;
    }

    public StaticIntrinsic getStaticIntrinsic(Phase phase, MethodElement element) {
        if (element.isStatic()) {
            StaticIntrinsic intrinsic = (StaticIntrinsic)this.staticIntrinsics.getOrDefault(phase, Map.of()).getOrDefault(element.getEnclosingType().getDescriptor(), Map.of()).getOrDefault(element.getName(), Map.of()).get(element.getDescriptor());
            if (intrinsic == null) {
                intrinsic = (StaticIntrinsic)this.wildCardStaticIntrinsics.getOrDefault(phase, Map.of()).getOrDefault(element.getEnclosingType().getDescriptor(), Map.of()).get(element.getName());
            }
            return intrinsic;
        }
        return null;
    }

    public boolean registerIntrinsic(TypeDescriptor owner, String name, MethodDescriptor desc, InstanceIntrinsic intrinsic) {
        return this.registerIntrinsic(Phase.ADD, owner, name, desc, intrinsic);
    }

    public boolean registerIntrinsic(Phase phase, TypeDescriptor owner, String name, MethodDescriptor desc, InstanceIntrinsic intrinsic) {
        return this.instanceIntrinsics.computeIfAbsent(phase, Intrinsics::map).computeIfAbsent(owner, Intrinsics::map).computeIfAbsent(name, Intrinsics::map).putIfAbsent(desc, intrinsic) != null;
    }

    public boolean registerIntrinsic(TypeDescriptor owner, String name, InstanceIntrinsic intrinsic) {
        return this.registerIntrinsic(Phase.ADD, owner, name, intrinsic);
    }

    private boolean registerIntrinsic(Phase phase, TypeDescriptor owner, String name, InstanceIntrinsic intrinsic) {
        return this.wildCardInstanceIntrinsics.computeIfAbsent(phase, Intrinsics::map).computeIfAbsent(owner, Intrinsics::map).putIfAbsent(name, intrinsic) != null;
    }

    public InstanceIntrinsic getInstanceIntrinsic(Phase phase, MethodElement element) {
        if (!element.isStatic()) {
            InstanceIntrinsic intrinsic = (InstanceIntrinsic)this.instanceIntrinsics.getOrDefault(phase, Map.of()).getOrDefault(element.getEnclosingType().getDescriptor(), Map.of()).getOrDefault(element.getName(), Map.of()).get(element.getDescriptor());
            if (intrinsic == null) {
                intrinsic = (InstanceIntrinsic)this.wildCardInstanceIntrinsics.getOrDefault(phase, Map.of()).getOrDefault(element.getEnclosingType().getDescriptor(), Map.of()).get(element.getName());
            }
            return intrinsic;
        }
        return null;
    }
}

