/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.nogc;

import java.util.List;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.plugin.coreclasses.BasicHeaderInitializer;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.gc.nogc.NoGc;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.MethodElement;

public class NoGcBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt;
    private final CoreClasses coreClasses;

    public NoGcBasicBlockBuilder(BasicBlockBuilder.FactoryContext fc, BasicBlockBuilder delegate) {
        super(delegate);
        CompilationContext ctxt;
        this.ctxt = ctxt = this.getContext();
        this.coreClasses = CoreClasses.get((CompilationContext)ctxt);
    }

    public Value new_(ClassObjectType type, Value typeId, Value size, Value align) {
        MethodElement method;
        ClassObjectType cot;
        TypeLiteral tl;
        ValueType valueType;
        NoGc noGc = NoGc.get(this.ctxt);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Value refVal = null;
        if (typeId instanceof TypeLiteral && (valueType = (tl = (TypeLiteral)typeId).getValue()) instanceof ClassObjectType && (cot = (ClassObjectType)valueType).isSubtypeOf(noGc.getStackObjectType())) {
            CompoundType compoundType = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(cot.getDefinition()).getCompoundType();
            refVal = this.valueConvert(this.stackAllocate((ValueType)compoundType, (Value)lf.literalOf(1), align), (WordType)type.getReference());
        }
        if (refVal == null) {
            method = noGc.getAllocateMethod();
            refVal = this.notNull(this.bitCast(this.call((Value)lf.literalOf(method), List.of(size, align)), (WordType)type.getReference()));
        }
        method = noGc.getZeroMethod();
        this.call((Value)lf.literalOf(method), List.of(refVal, size));
        BasicHeaderInitializer.initializeObjectHeader((CompilationContext)this.ctxt, (BasicBlockBuilder)this, (Value)this.decodeReference(refVal), (Value)typeId);
        return refVal;
    }

    public Value newArray(PrimitiveArrayObjectType arrayType, Value size) {
        LoadedTypeDefinition ltd = this.coreClasses.getArrayContentField((ObjectType)arrayType).getEnclosingType().load();
        CompoundType compoundType = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo((DefinedTypeDefinition)ltd).getCompoundType();
        Value ptrVal = this.allocateArray(compoundType, size, arrayType.getElementType().getSize());
        Value oop = this.valueConvert(ptrVal, (WordType)arrayType.getReference());
        BasicHeaderInitializer.initializeArrayHeader((CompilationContext)this.ctxt, (BasicBlockBuilder)this, (Value)this.decodeReference(oop), (Value)this.ctxt.getLiteralFactory().literalOfType((ValueType)ltd.getClassType()), (Value)size);
        return oop;
    }

    public Value newReferenceArray(ReferenceArrayObjectType arrayType, Value elemTypeId, Value dimensions, Value size) {
        Layout layout = Layout.get((CompilationContext)this.ctxt);
        LayoutInfo info = layout.getInstanceLayoutInfo(this.coreClasses.getRefArrayContentField().getEnclosingType());
        CompoundType compoundType = info.getCompoundType();
        Value ptrVal = this.allocateArray(compoundType, size, this.ctxt.getTypeSystem().getReferenceSize());
        Value oop = this.valueConvert(ptrVal, (WordType)arrayType.getReference());
        BasicHeaderInitializer.initializeRefArrayHeader((CompilationContext)this.ctxt, (BasicBlockBuilder)this, (Value)this.decodeReference(oop), (Value)elemTypeId, (Value)dimensions, (Value)size);
        return oop;
    }

    private Value allocateArray(CompoundType compoundType, Value size, long elementSize) {
        NoGc noGc = NoGc.get(this.ctxt);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        IntegerLiteral align = lf.literalOf(compoundType.getAlign());
        IntegerLiteral baseSize = lf.literalOf(compoundType.getSize());
        IntegerType sizeType = (IntegerType)size.getType();
        if (sizeType.getMinBits() < 64) {
            size = this.extend(size, (WordType)this.ctxt.getTypeSystem().getSignedInteger64Type());
        }
        assert (Long.bitCount(elementSize) == 1);
        int elementShift = Long.numberOfTrailingZeros(elementSize);
        Value realSize = this.add((Value)baseSize, elementShift == 0 ? size : this.shl(size, (Value)lf.literalOf((IntegerType)size.getType(), (long)elementShift)));
        MethodElement method1 = noGc.getAllocateMethod();
        Value ptrVal = this.notNull(this.call((Value)lf.literalOf(method1), List.of(realSize, align)));
        MethodElement method = noGc.getZeroMethod();
        this.call((Value)lf.literalOf(method), List.of(ptrVal, realSize));
        return ptrVal;
    }
}

