/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.dispatch;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.object.Data;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.Linkage;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.plugin.correctness.RuntimeInitManager;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.plugin.reachability.ReachabilityRoots;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.BaseTypeSignature;
import org.qbicc.type.generic.TypeSignature;

public class DispatchTables {
    private static final Logger slog = Logger.getLogger((String)"org.qbicc.plugin.dispatch.stats");
    private static final Logger tlog = Logger.getLogger((String)"org.qbicc.plugin.dispatch.tables");
    private static final AttachmentKey<DispatchTables> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Map<LoadedTypeDefinition, VTableInfo> vtables = new ConcurrentHashMap<LoadedTypeDefinition, VTableInfo>();
    private final Map<LoadedTypeDefinition, ITableInfo> itables = new ConcurrentHashMap<LoadedTypeDefinition, ITableInfo>();
    private final Set<LoadedTypeDefinition> classesWithITables = ConcurrentHashMap.newKeySet();
    private final Set<InitializerElement> runtimeInitializers = ConcurrentHashMap.newKeySet();
    private GlobalVariableElement vtablesGlobal;
    private GlobalVariableElement itablesGlobal;
    private GlobalVariableElement rtinitsGlobal;
    private CompoundType itableDictType;
    private int emittedVTableCount;
    private int emittedVTableBytes;
    private int emittedClassITableCount;
    private int emittedClassITableBytes;
    private int emittedClassITableDictBytes;
    private int emittedClassITableDictCount;
    static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    private DispatchTables(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static DispatchTables get(CompilationContext ctxt) {
        DispatchTables appearing;
        DispatchTables dt = (DispatchTables)ctxt.getAttachment(KEY);
        if (dt == null && (appearing = (DispatchTables)ctxt.putAttachmentIfAbsent(KEY, (Object)(dt = new DispatchTables(ctxt)))) != null) {
            dt = appearing;
        }
        return dt;
    }

    public VTableInfo getVTableInfo(LoadedTypeDefinition cls) {
        return this.vtables.get(cls);
    }

    public ITableInfo getITableInfo(LoadedTypeDefinition cls) {
        return this.itables.get(cls);
    }

    void buildFilteredVTable(LoadedTypeDefinition cls) {
        tlog.debugf("Building VTable for %s", (Object)cls.getDescriptor());
        ReachabilityInfo reachabilityInfo = ReachabilityInfo.get((CompilationContext)this.ctxt);
        ReachabilityRoots roots = ReachabilityRoots.get((CompilationContext)this.ctxt);
        ArrayList<MethodElement> vtableVector = new ArrayList<MethodElement>();
        for (MethodElement m2 : cls.getInstanceMethods()) {
            if (m2.isPrivate() || !reachabilityInfo.isDispatchableMethod(m2)) continue;
            if (reachabilityInfo.isInvokableInstanceMethod(m2)) {
                tlog.debugf("\tadding dispatchable and invokable method %s%s", (Object)m2.getName(), (Object)m2.getDescriptor().toString());
                roots.registerDispatchTableEntry((ExecutableElement)m2);
            } else {
                tlog.debugf("\tadding dispatchable but not invokable method %s%s", (Object)m2.getName(), (Object)m2.getDescriptor().toString());
            }
            vtableVector.add(m2);
        }
        cls.forEachSigPolyMethod(m -> {
            if (reachabilityInfo.isDispatchableMethod(m)) {
                if (reachabilityInfo.isInvokableInstanceMethod(m)) {
                    tlog.debugf("\tadding dispatchable and invokable SigPoly method %s%s", (Object)m.getName(), (Object)m.getDescriptor().toString());
                    roots.registerDispatchTableEntry((ExecutableElement)m);
                } else {
                    tlog.debugf("\tadding dispatchable but not invokable SigPoly method %s%s", (Object)m.getName(), (Object)m.getDescriptor().toString());
                }
                vtableVector.add((MethodElement)m);
            }
        });
        MethodElement[] vtable = vtableVector.toArray(MethodElement.NO_METHODS);
        this.buildVTableType(cls, vtable);
    }

    void adjustVTableForSigPloySubclass(LoadedTypeDefinition cls, VTableInfo sigPolyClass) {
        tlog.debugf("Recompute SigPoly VTable for %s", (Object)cls.getDescriptor());
        ReachabilityInfo reachabilityInfo = ReachabilityInfo.get((CompilationContext)this.ctxt);
        ReachabilityRoots roots = ReachabilityRoots.get((CompilationContext)this.ctxt);
        MethodElement[] baseVTable = sigPolyClass.getVtable();
        ArrayList<MethodElement> vtableVector = new ArrayList<MethodElement>();
        for (MethodElement m : baseVTable) {
            vtableVector.add(m);
        }
        for (MethodElement m : cls.getInstanceMethods()) {
            if (m.isPrivate() || !reachabilityInfo.isDispatchableMethod(m)) continue;
            if (reachabilityInfo.isInvokableInstanceMethod(m)) {
                roots.registerDispatchTableEntry((ExecutableElement)m);
            }
            boolean override = false;
            for (int i = 0; i < baseVTable.length; ++i) {
                if (!m.getName().equals(baseVTable[i].getName()) || !m.getDescriptor().equals(baseVTable[i].getDescriptor())) continue;
                override = true;
                vtableVector.set(i, m);
                tlog.debugf("\tinjecting overriding method %s%s", (Object)m.getName(), (Object)m.getDescriptor().toString());
                break;
            }
            if (override) continue;
            if (reachabilityInfo.isInvokableInstanceMethod(m)) {
                tlog.debugf("\tadding dispatchable and invokable method %s%s", (Object)m.getName(), (Object)m.getDescriptor().toString());
            } else {
                tlog.debugf("\tadding dispatchable but not invokable method %s%s", (Object)m.getName(), (Object)m.getDescriptor().toString());
            }
            vtableVector.add(m);
        }
        MethodElement[] vtable = vtableVector.toArray(MethodElement.NO_METHODS);
        this.buildVTableType(cls, vtable);
    }

    private void buildVTableType(LoadedTypeDefinition cls, MethodElement[] vtable) {
        String vtableName = "vtable-" + cls.getInternalName().replace('/', '.');
        if (cls.isHidden()) {
            vtableName = vtableName + "~" + ENCODER.encodeToString(cls.getDigest()) + "." + cls.getHiddenClassIndex();
        }
        TypeSystem ts = this.ctxt.getTypeSystem();
        CompoundType.Member[] functions = new CompoundType.Member[vtable.length];
        for (int i = 0; i < vtable.length; ++i) {
            functions[i] = ts.getCompoundTypeMember("m" + i + "." + vtable[i].getName(), (ValueType)vtable[i].getType().getPointer(), i * ts.getPointerSize(), ts.getPointerAlignment());
        }
        CompoundType vtableType = ts.getCompoundType(CompoundType.Tag.STRUCT, vtableName, (long)(vtable.length * ts.getPointerSize()), ts.getPointerAlignment(), () -> List.of(functions));
        this.vtables.put(cls, new VTableInfo(vtable, vtableType, vtableName));
    }

    void buildFilteredITableForInterface(LoadedTypeDefinition cls) {
        tlog.debugf("Building ITable for %s", (Object)cls.getDescriptor());
        ReachabilityInfo reachabilityInfo = ReachabilityInfo.get((CompilationContext)this.ctxt);
        ArrayList<MethodElement> itableVector = new ArrayList<MethodElement>();
        for (MethodElement m : cls.getInstanceMethods()) {
            if (!reachabilityInfo.isDispatchableMethod(m) || m.isPrivate()) continue;
            tlog.debugf("\tadding invokable signature %s%s", (Object)m.getName(), (Object)m.getDescriptor().toString());
            itableVector.add(m);
        }
        MethodElement[] itable = itableVector.toArray(MethodElement.NO_METHODS);
        String itableName = "itable-" + cls.getInternalName().replace('/', '.');
        if (cls.isHidden()) {
            itableName = itableName + "~" + ENCODER.encodeToString(cls.getDigest()) + "." + cls.getHiddenClassIndex();
        }
        TypeSystem ts = this.ctxt.getTypeSystem();
        CompoundType.Member[] functions = new CompoundType.Member[itable.length];
        for (int i = 0; i < itable.length; ++i) {
            functions[i] = ts.getCompoundTypeMember("m" + i + "." + itable[i].getName(), (ValueType)itable[i].getType().getPointer(), i * ts.getPointerSize(), ts.getPointerAlignment());
        }
        CompoundType itableType = ts.getCompoundType(CompoundType.Tag.STRUCT, itableName, (long)(itable.length * ts.getPointerSize()), ts.getPointerAlignment(), () -> List.of(functions));
        this.itables.put(cls, new ITableInfo(itable, itableType, cls));
    }

    public void registerRuntimeInitializer(InitializerElement init) {
        this.runtimeInitializers.add(init);
    }

    void buildVTablesGlobal(DefinedTypeDefinition containingType) {
        GlobalVariableElement.Builder builder = GlobalVariableElement.builder((String)"qbicc_vtables_array", (TypeDescriptor)BaseTypeDescriptor.V);
        builder.setType((ValueType)this.ctxt.getTypeSystem().getArrayType((ValueType)this.ctxt.getTypeSystem().getVoidType().getPointer().getPointer(), (long)(this.vtables.size() + 20)));
        builder.setEnclosingType(containingType);
        builder.setSignature((TypeSignature)BaseTypeSignature.V);
        builder.setSection(this.ctxt.getImplicitSection());
        this.vtablesGlobal = builder.build();
    }

    void buildITablesGlobal(DefinedTypeDefinition containingType) {
        TypeSystem ts = this.ctxt.getTypeSystem();
        CompoundType.Member itableMember = ts.getCompoundTypeMember("itable", (ValueType)ts.getVoidType().getPointer(), 0, ts.getPointerAlignment());
        CompoundType.Member typeIdMember = ts.getCompoundTypeMember("typeId", (ValueType)ts.getTypeIdLiteralType(), ts.getPointerSize(), ts.getTypeIdAlignment());
        this.itableDictType = ts.getCompoundType(CompoundType.Tag.STRUCT, "qbicc_itable_dict_entry", (long)(ts.getPointerSize() + ts.getTypeIdSize()), ts.getPointerAlignment(), () -> List.of(itableMember, typeIdMember));
        GlobalVariableElement.Builder builder = GlobalVariableElement.builder((String)"qbicc_itable_dicts_array", (TypeDescriptor)BaseTypeDescriptor.V);
        builder.setType((ValueType)ts.getArrayType((ValueType)ts.getArrayType((ValueType)this.itableDictType, 0L).getPointer(), (long)(this.vtables.size() + 20)));
        builder.setEnclosingType(containingType);
        builder.setSignature((TypeSignature)BaseTypeSignature.V);
        builder.setSection(this.ctxt.getImplicitSection());
        this.itablesGlobal = builder.build();
    }

    void buildRTInitGlobal(DefinedTypeDefinition containingType) {
        TypeSystem ts = this.ctxt.getTypeSystem();
        FunctionType initType = this.ctxt.getFunctionTypeForInitializer();
        GlobalVariableElement.Builder builder = GlobalVariableElement.builder((String)"qbicc_rtinit_array", (TypeDescriptor)BaseTypeDescriptor.V);
        builder.setType((ValueType)ts.getArrayType((ValueType)initType.getPointer(), (long)(RuntimeInitManager.get((CompilationContext)this.ctxt).maxAssignedId() + 1)));
        builder.setEnclosingType(containingType);
        builder.setSignature((TypeSignature)BaseTypeSignature.V);
        builder.setSection(this.ctxt.getImplicitSection());
        this.rtinitsGlobal = builder.build();
    }

    void emitVTable(LoadedTypeDefinition cls) {
        if (cls.isAbstract() && !cls.isFinal()) {
            return;
        }
        RuntimeMethodFinder methodFinder = RuntimeMethodFinder.get((CompilationContext)this.ctxt);
        ReachabilityInfo reachabilityInfo = ReachabilityInfo.get((CompilationContext)this.ctxt);
        VTableInfo info = this.getVTableInfo(cls);
        MethodElement[] vtable = info.getVtable();
        ModuleSection section = this.ctxt.getImplicitSection((DefinedTypeDefinition)cls);
        ProgramModule programModule = section.getProgramModule();
        HashMap<CompoundType.Member, Object> valueMap = new HashMap<CompoundType.Member, Object>();
        for (int i = 0; i < vtable.length; ++i) {
            ProgramObjectLiteral literal;
            FunctionDeclaration decl;
            Function stubImpl;
            MethodElement stub;
            FunctionType funType = this.ctxt.getFunctionTypeForElement((ExecutableElement)vtable[i]);
            if (vtable[i].isAbstract() || vtable[i].hasAllModifiersOf(256) && this.ctxt.getExactFunctionIfExists((ExecutableElement)vtable[i]) == null) {
                stub = methodFinder.getMethod(vtable[i].isAbstract() ? "raiseAbstractMethodError" : "raiseUnsatisfiedLinkErrorDispatchStub");
                stubImpl = this.ctxt.getExactFunction((ExecutableElement)stub);
                decl = programModule.declareFunction((ExecutableElement)stub, stubImpl.getName(), stubImpl.getValueType());
                literal = this.ctxt.getLiteralFactory().literalOf((ProgramObject)decl);
                valueMap.put(info.getType().getMember(i), this.ctxt.getLiteralFactory().bitcastLiteral((Literal)literal, (WordType)this.ctxt.getFunctionTypeForElement((ExecutableElement)vtable[i]).getPointer()));
                continue;
            }
            if (!reachabilityInfo.isInvokableInstanceMethod(vtable[i])) {
                stub = methodFinder.getMethod("raiseUnreachableCodeError");
                stubImpl = this.ctxt.getExactFunction((ExecutableElement)stub);
                decl = programModule.declareFunction((ExecutableElement)stub, stubImpl.getName(), stubImpl.getValueType());
                literal = this.ctxt.getLiteralFactory().literalOf((ProgramObject)decl);
                valueMap.put(info.getType().getMember(i), this.ctxt.getLiteralFactory().bitcastLiteral((Literal)literal, (WordType)this.ctxt.getFunctionTypeForElement((ExecutableElement)vtable[i]).getPointer()));
                continue;
            }
            Function impl = this.ctxt.getExactFunctionIfExists((ExecutableElement)vtable[i]);
            if (impl == null) {
                this.ctxt.error((Element)vtable[i], "Missing method implementation for vtable of %s", new Object[]{cls.getInternalName()});
                continue;
            }
            if (!vtable[i].getEnclosingType().load().equals(cls)) {
                programModule.declareFunction((ExecutableElement)vtable[i], impl.getName(), funType);
            }
            valueMap.put(info.getType().getMember(i), this.ctxt.getLiteralFactory().literalOf((ProgramObject)impl));
        }
        Literal vtableLiteral = this.ctxt.getLiteralFactory().literalOf(info.getType(), valueMap);
        section.addData(null, info.getName(), (Value)vtableLiteral).setLinkage(Linkage.EXTERNAL);
        ++this.emittedVTableCount;
        this.emittedVTableBytes += info.getType().getMemberCount() * this.ctxt.getTypeSystem().getPointerSize();
    }

    void emitVTableTable(LoadedTypeDefinition jlo) {
        ArrayType vtablesGlobalType = (ArrayType)this.vtablesGlobal.getType();
        ModuleSection section = this.ctxt.getImplicitSection((DefinedTypeDefinition)jlo);
        Object[] vtableLiterals = new Literal[(int)vtablesGlobalType.getElementCount()];
        Literal zeroLiteral = this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(vtablesGlobalType.getElementType());
        Arrays.fill(vtableLiterals, zeroLiteral);
        for (Map.Entry<LoadedTypeDefinition, VTableInfo> e : this.vtables.entrySet()) {
            LoadedTypeDefinition cls = e.getKey();
            if (cls.isAbstract() && !cls.isFinal()) continue;
            DataDeclaration decl = section.getProgramModule().declareData(null, e.getValue().getName(), (ValueType)e.getValue().getType());
            ProgramObjectLiteral symbol = this.ctxt.getLiteralFactory().literalOf((ProgramObject)decl);
            int typeId = cls.getTypeId();
            Assert.assertTrue((boolean)vtableLiterals[typeId].equals(zeroLiteral));
            vtableLiterals[typeId] = this.ctxt.getLiteralFactory().bitcastLiteral((Literal)symbol, (WordType)vtablesGlobalType.getElementType());
        }
        Literal vtablesGlobalValue = this.ctxt.getLiteralFactory().literalOf(vtablesGlobalType, List.of(vtableLiterals));
        section.addData(null, this.vtablesGlobal.getName(), (Value)vtablesGlobalValue);
        slog.debugf("Root vtable[] has %d slots (%d bytes)", vtableLiterals.length, vtableLiterals.length * this.ctxt.getTypeSystem().getPointerSize());
        slog.debugf("Emitted %d vtables with combined size of %d bytes", this.emittedVTableCount, this.emittedVTableBytes);
    }

    public void emitITables(LoadedTypeDefinition cls) {
        if (cls.isAbstract() && !cls.isFinal()) {
            return;
        }
        HashSet myITables = new HashSet();
        cls.forEachInterfaceFullImplementedSet(i -> {
            ITableInfo iti = this.itables.get(i);
            if (iti != null && iti.getItable().length > 0) {
                myITables.add(iti);
            }
        });
        if (myITables.isEmpty()) {
            return;
        }
        this.classesWithITables.add(cls);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        TypeSystem ts = this.ctxt.getTypeSystem();
        ModuleSection cSection = this.ctxt.getImplicitSection((DefinedTypeDefinition)cls);
        ProgramModule programModule = cSection.getProgramModule();
        ArrayList<Literal> itableLiterals = new ArrayList<Literal>(myITables.size() + 1);
        RuntimeMethodFinder methodFinder = RuntimeMethodFinder.get((CompilationContext)this.ctxt);
        ReachabilityInfo reachabilityInfo = ReachabilityInfo.get((CompilationContext)this.ctxt);
        for (ITableInfo itableInfo : myITables) {
            MethodElement[] itable = itableInfo.getItable();
            LoadedTypeDefinition currentInterface = itableInfo.getInterface();
            HashMap<CompoundType.Member, Object> valueMap = new HashMap<CompoundType.Member, Object>();
            for (int i2 = 0; i2 < itable.length; ++i2) {
                MethodElement methImpl = cls.resolveMethodElementVirtual(cls.getContext(), itable[i2].getName(), itable[i2].getDescriptor());
                FunctionType implType = this.ctxt.getFunctionTypeForElement((ExecutableElement)methImpl);
                if (methImpl == null) {
                    MethodElement icceStub = methodFinder.getMethod("raiseIncompatibleClassChangeError");
                    Function icceImpl = this.ctxt.getExactFunction((ExecutableElement)icceStub);
                    ProgramObjectLiteral iceeLiteral = lf.literalOf((ProgramObject)programModule.declareFunction(icceImpl));
                    valueMap.put(itableInfo.getType().getMember(i2), lf.bitcastLiteral((Literal)iceeLiteral, (WordType)implType.getPointer()));
                    continue;
                }
                if (methImpl.isAbstract()) {
                    MethodElement ameStub = methodFinder.getMethod("raiseAbstractMethodError");
                    Function ameImpl = this.ctxt.getExactFunction((ExecutableElement)ameStub);
                    ProgramObjectLiteral ameLiteral = lf.literalOf((ProgramObject)programModule.declareFunction(ameImpl));
                    valueMap.put(itableInfo.getType().getMember(i2), lf.bitcastLiteral((Literal)ameLiteral, (WordType)implType.getPointer()));
                    continue;
                }
                if (methImpl.isNative()) {
                    MethodElement uleStub = methodFinder.getMethod("raiseUnsatisfiedLinkErrorDispatchStub");
                    Function uleImpl = this.ctxt.getExactFunction((ExecutableElement)uleStub);
                    ProgramObjectLiteral uleLiteral = lf.literalOf((ProgramObject)programModule.declareFunction(uleImpl));
                    valueMap.put(itableInfo.getType().getMember(i2), lf.bitcastLiteral((Literal)uleLiteral, (WordType)implType.getPointer()));
                    continue;
                }
                if (!reachabilityInfo.isInvokableInstanceMethod(methImpl)) {
                    MethodElement uceStub = methodFinder.getMethod("raiseUnreachableCodeError");
                    Function uceImpl = this.ctxt.getExactFunction((ExecutableElement)uceStub);
                    ProgramObjectLiteral uceLiteral = lf.literalOf((ProgramObject)programModule.declareFunction(uceImpl));
                    valueMap.put(itableInfo.getType().getMember(i2), lf.bitcastLiteral((Literal)uceLiteral, (WordType)implType.getPointer()));
                    continue;
                }
                Function impl = this.ctxt.getExactFunctionIfExists((ExecutableElement)methImpl);
                if (impl == null) {
                    this.ctxt.error((Element)methImpl, "Missing method implementation for itable of %s", new Object[]{cls.getInternalName()});
                    continue;
                }
                if (!methImpl.getEnclosingType().load().equals(cls)) {
                    programModule.declareFunction((ExecutableElement)methImpl, impl.getName(), implType);
                }
                valueMap.put(itableInfo.getType().getMember(i2), this.ctxt.getLiteralFactory().literalOf((ProgramObject)impl));
            }
            String functionsName = "qbicc_itable_funcs_for_" + currentInterface.getInterfaceType().toFriendlyString();
            Data data = cSection.addData(null, functionsName, (Value)lf.literalOf(itableInfo.getType(), valueMap));
            data.setLinkage(Linkage.PRIVATE);
            itableLiterals.add(lf.literalOf(this.itableDictType, Map.of(this.itableDictType.getMember("typeId"), lf.literalOf(currentInterface.getTypeId()), this.itableDictType.getMember("itable"), lf.bitcastLiteral((Literal)lf.literalOf((ProgramObject)data), (WordType)ts.getVoidType().getPointer()))));
            ++this.emittedClassITableCount;
            this.emittedClassITableBytes += itable.length * this.ctxt.getTypeSystem().getPointerSize();
        }
        itableLiterals.add(lf.zeroInitializerLiteralOfType((ValueType)this.itableDictType));
        String dictName = "qbicc_itable_dictionary_for_" + cls.getInternalName().replace('/', '.');
        if (cls.isHidden()) {
            dictName = dictName + "~" + ENCODER.encodeToString(cls.getDigest()) + "." + cls.getHiddenClassIndex();
        }
        cSection.addData(null, dictName, (Value)lf.literalOf(ts.getArrayType((ValueType)this.itableDictType, (long)(myITables.size() + 1)), itableLiterals));
        ++this.emittedClassITableDictCount;
        this.emittedClassITableDictBytes = (int)((long)this.emittedClassITableDictBytes + (long)(myITables.size() + 1) * this.itableDictType.getSize());
    }

    void emitITableTable(LoadedTypeDefinition jlo) {
        ArrayType itablesGlobalType = (ArrayType)this.itablesGlobal.getType();
        ModuleSection section = this.ctxt.getImplicitSection((DefinedTypeDefinition)jlo);
        Object[] itableLiterals = new Literal[(int)itablesGlobalType.getElementCount()];
        Literal zeroLiteral = this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(itablesGlobalType.getElementType());
        Arrays.fill(itableLiterals, zeroLiteral);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        for (LoadedTypeDefinition cls : this.classesWithITables) {
            int typeId = cls.getTypeId();
            Assert.assertTrue((boolean)itableLiterals[typeId].equals(zeroLiteral));
            String dictName = "qbicc_itable_dictionary_for_" + cls.getInternalName().replace('/', '.');
            if (cls.isHidden()) {
                dictName = dictName + "~" + ENCODER.encodeToString(cls.getDigest()) + "." + cls.getHiddenClassIndex();
            }
            ArrayType type = this.ctxt.getTypeSystem().getArrayType((ValueType)this.itableDictType, 0L);
            DataDeclaration decl = section.getProgramModule().declareData(null, dictName, (ValueType)type);
            ProgramObjectLiteral symLit = lf.literalOf((ProgramObject)decl);
            itableLiterals[typeId] = symLit;
        }
        Literal itablesGlobalValue = this.ctxt.getLiteralFactory().literalOf(itablesGlobalType, List.of(itableLiterals));
        section.addData(null, this.itablesGlobal.getName(), (Value)itablesGlobalValue);
        slog.debugf("Root itable_dict[] has %d slots (%d bytes)", itableLiterals.length, itableLiterals.length * this.ctxt.getTypeSystem().getPointerSize());
        slog.debugf("Emitted %d itables with combined size of %d bytes", this.emittedClassITableCount, this.emittedClassITableBytes);
        slog.debugf("Emitted %d class itable dictionaries with combined size of %d bytes", this.emittedClassITableDictCount, this.emittedClassITableDictBytes);
    }

    void emitRTInitTable(LoadedTypeDefinition jlo) {
        ArrayType tableGlobalType = (ArrayType)this.rtinitsGlobal.getType();
        ModuleSection section = this.ctxt.getImplicitSection((DefinedTypeDefinition)jlo);
        Object[] tableLiterals = new Literal[(int)tableGlobalType.getElementCount()];
        Literal zeroLiteral = this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(tableGlobalType.getElementType());
        Arrays.fill(tableLiterals, zeroLiteral);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        for (InitializerElement init : this.runtimeInitializers) {
            int index = init.getLowerIndex();
            Assert.assertTrue((boolean)tableLiterals[index].equals(zeroLiteral));
            Function impl = this.ctxt.getExactFunctionIfExists((ExecutableElement)init);
            section.getProgramModule().declareFunction((ExecutableElement)init, impl.getName(), this.ctxt.getFunctionTypeForElement((ExecutableElement)init));
            tableLiterals[index] = lf.literalOf((ProgramObject)impl);
        }
        section.addData(null, this.rtinitsGlobal.getName(), (Value)lf.literalOf(tableGlobalType, List.of(tableLiterals)));
    }

    public GlobalVariableElement getVTablesGlobal() {
        return this.vtablesGlobal;
    }

    public GlobalVariableElement getITablesGlobal() {
        return this.itablesGlobal;
    }

    public GlobalVariableElement getRTInitsGlobal() {
        return this.rtinitsGlobal;
    }

    public CompoundType getItableDictType() {
        return this.itableDictType;
    }

    public int getVTableIndex(MethodElement target) {
        LoadedTypeDefinition definingType = target.getEnclosingType().load();
        VTableInfo info = this.getVTableInfo(definingType);
        if (info != null) {
            MethodElement[] vtable = info.getVtable();
            for (int i = 0; i < vtable.length; ++i) {
                if (!target.getName().equals(vtable[i].getName()) || !target.getDescriptor().equals(vtable[i].getDescriptor())) continue;
                return i;
            }
        }
        this.ctxt.error("No vtable entry found for " + target, new Object[0]);
        return 0;
    }

    public int getITableIndex(MethodElement target) {
        LoadedTypeDefinition definingType = target.getEnclosingType().load();
        ITableInfo info = this.getITableInfo(definingType);
        if (info != null) {
            MethodElement[] itable = info.getItable();
            for (int i = 0; i < itable.length; ++i) {
                if (!target.getName().equals(itable[i].getName()) || !target.getDescriptor().equals(itable[i].getDescriptor())) continue;
                return i;
            }
        }
        this.ctxt.error("No itable entry found for " + target, new Object[0]);
        return 0;
    }

    public static final class VTableInfo {
        private final MethodElement[] vtable;
        private final CompoundType type;
        private final String name;

        VTableInfo(MethodElement[] vtable, CompoundType type, String name) {
            this.vtable = vtable;
            this.type = type;
            this.name = name;
        }

        public MethodElement[] getVtable() {
            return this.vtable;
        }

        public String getName() {
            return this.name;
        }

        public CompoundType getType() {
            return this.type;
        }
    }

    public static final class ITableInfo {
        private final LoadedTypeDefinition myInterface;
        private final MethodElement[] itable;
        private final CompoundType type;

        ITableInfo(MethodElement[] itable, CompoundType type, LoadedTypeDefinition myInterface) {
            this.myInterface = myInterface;
            this.itable = itable;
            this.type = type;
        }

        public LoadedTypeDefinition getInterface() {
            return this.myInterface;
        }

        public MethodElement[] getItable() {
            return this.itable;
        }

        public CompoundType getType() {
            return this.type;
        }
    }
}

