/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.dispatch;

import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.dispatch.DispatchTables;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;

public class DispatchTableBuilder
implements Consumer<CompilationContext> {
    @Override
    public void accept(CompilationContext ctxt) {
        ReachabilityInfo info = ReachabilityInfo.get((CompilationContext)ctxt);
        DispatchTables tables = DispatchTables.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        DefinedTypeDefinition jloDef = classContext.findDefinedType("java/lang/Object");
        LoadedTypeDefinition jlo = jloDef.load();
        tables.buildFilteredVTable(jlo);
        info.visitReachableSubclassesPreOrder(jlo, tables::buildFilteredVTable);
        LoadedTypeDefinition vh = classContext.findDefinedType("java/lang/invoke/VarHandle").load();
        DispatchTables.VTableInfo vhInfo = tables.getVTableInfo(vh);
        info.visitReachableSubclassesPreOrder(vh, c -> tables.adjustVTableForSigPloySubclass((LoadedTypeDefinition)c, vhInfo));
        LoadedTypeDefinition mh = classContext.findDefinedType("java/lang/invoke/MethodHandle").load();
        DispatchTables.VTableInfo mhInfo = tables.getVTableInfo(mh);
        info.visitReachableSubclassesPreOrder(mh, c -> tables.adjustVTableForSigPloySubclass((LoadedTypeDefinition)c, mhInfo));
        tables.buildVTablesGlobal((DefinedTypeDefinition)jlo);
        tables.buildITablesGlobal((DefinedTypeDefinition)jlo);
        tables.buildRTInitGlobal((DefinedTypeDefinition)jlo);
        info.visitReachableInterfaces(tables::buildFilteredITableForInterface);
    }
}

