/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.apploader;

import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.type.definition.LoadedTypeDefinition;

public class InitAppClassLoaderHook
implements Consumer<CompilationContext> {
    private static final String CLASS_LOADERS = "jdk/internal/loader/ClassLoaders";

    @Override
    public void accept(CompilationContext ctxt) {
        ClassContext bootstrapClassContext = ctxt.getBootstrapClassContext();
        LoadedTypeDefinition classLoadersDef = bootstrapClassContext.findDefinedType(CLASS_LOADERS).load();
        VmClass classLoaders = classLoadersDef.getVmClass();
        try {
            Vm.requireCurrent().initialize(classLoaders);
        }
        catch (Throwable t) {
            ctxt.error("Failed to initialize %s: %s", new Object[]{CLASS_LOADERS, t});
            return;
        }
        VmClassLoader appClassLoader = (VmClassLoader)classLoaders.getStaticMemory().loadRef((long)classLoaders.indexOfStatic(classLoadersDef.findField("APP_LOADER")), (ReadAccessMode)AccessModes.SinglePlain);
        AppClassLoader.get(ctxt).setAppClassLoader(appClassLoader);
    }
}

