/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.emscripten;

import io.smallrye.common.version.VersionScheme;
import java.nio.file.Path;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.emscripten.EmscriptenCCompilerInvoker;
import org.qbicc.machine.tool.emscripten.EmscriptenCCompilerInvokerImpl;
import org.qbicc.machine.tool.emscripten.EmscriptenLinkerInvoker;
import org.qbicc.machine.tool.emscripten.EmscriptenLinkerInvokerImpl;
import org.qbicc.machine.tool.emscripten.EmscriptenToolChain;

final class EmscriptenToolChainImpl
implements EmscriptenToolChain {
    private final Path executablePath;
    private final Platform platform;
    private final String version;

    EmscriptenToolChainImpl(Path executablePath, Platform platform, String version) {
        this.executablePath = executablePath;
        this.platform = platform;
        this.version = version;
    }

    public String getImplementationName() {
        return "Emscripten (LLVM)";
    }

    Path getExecutablePath() {
        return this.executablePath;
    }

    public EmscriptenCCompilerInvoker newCompilerInvoker() {
        return new EmscriptenCCompilerInvokerImpl(this);
    }

    public EmscriptenLinkerInvoker newLinkerInvoker() {
        return new EmscriptenLinkerInvokerImpl(this);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public int compareVersionTo(String version) {
        return VersionScheme.BASIC.compare(this.version, version);
    }
}

