/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionBiConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class WriterConsumerInputSource<T>
extends InputSource {
    private final ExceptionBiConsumer<T, Writer, IOException> consumer;
    private final T param;
    private final Charset charset;

    WriterConsumerInputSource(ExceptionBiConsumer<T, Writer, IOException> consumer, T param, Charset charset) {
        this.consumer = consumer;
        this.param = param;
        this.charset = charset;
    }

    @Override
    public void transferTo(OutputDestination destination) throws IOException {
        destination.transferFrom(this);
    }

    @Override
    ProcessBuilder.Redirect getInputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }

    @Override
    void transferTo(OutputStream os) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(os, this.charset);){
            this.transferTo(writer, this.charset);
        }
    }

    void transferTo(Writer writer, Charset charset) throws IOException {
        this.consumer.accept(this.param, (Object)writer);
    }

    @Override
    InputStream openStream() {
        throw Assert.unsupported();
    }

    @Override
    public String toString() {
        return "<stream>";
    }
}

