/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class OutputStreamSupplierOutputDestination<T>
extends OutputDestination {
    private final ExceptionFunction<T, OutputStream, IOException> function;
    private final T param;

    OutputStreamSupplierOutputDestination(ExceptionFunction<T, OutputStream, IOException> function, T param) {
        this.function = function;
        this.param = param;
    }

    OutputStream openStream() throws IOException {
        return (OutputStream)this.function.apply(this.param);
    }

    @Override
    void transferFrom(InputSource source) throws IOException {
        try (OutputStream os = this.openStream();){
            source.transferTo(os);
        }
    }

    @Override
    void transferFrom(InputStream stream) throws IOException {
        try (OutputStream os = this.openStream();){
            stream.transferTo(os);
        }
    }

    @Override
    void transferFrom(Reader reader, Charset charset) throws IOException {
        try (OutputStream os = this.openStream();
             OutputStreamWriter osw = new OutputStreamWriter(os, charset);){
            reader.transferTo(osw);
        }
    }

    @Override
    ProcessBuilder.Redirect getOutputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }
}

