/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.function.ExceptionRunnable;
import io.smallrye.common.function.ExceptionSupplier;
import io.smallrye.common.function.ExceptionUnaryOperator;
import io.smallrye.common.function.Functions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.qbicc.machine.tool.process.AppendableSupplierOutputDestination;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.DiscardOutputDestination;
import org.qbicc.machine.tool.process.EmptyInputSource;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.InputStreamConsumerOutputDestination;
import org.qbicc.machine.tool.process.InputStreamSupplierInputSource;
import org.qbicc.machine.tool.process.OutputStreamConsumerInputSource;
import org.qbicc.machine.tool.process.OutputStreamSupplierOutputDestination;
import org.qbicc.machine.tool.process.PathInputSource;
import org.qbicc.machine.tool.process.PathOutputDestination;
import org.qbicc.machine.tool.process.ProcessOutputDestination;
import org.qbicc.machine.tool.process.ReaderConsumerOutputDestination;
import org.qbicc.machine.tool.process.ReaderSupplierInputSource;
import org.qbicc.machine.tool.process.WriterConsumerInputSource;

public abstract class OutputDestination {
    OutputDestination() {
    }

    public static OutputDestination discarding() {
        return DiscardOutputDestination.INSTANCE;
    }

    public static <T> OutputDestination of(ExceptionBiConsumer<T, InputStream, IOException> consumer, T param) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        return new InputStreamConsumerOutputDestination<T>(consumer, param);
    }

    public static OutputDestination of(ExceptionConsumer<InputStream, IOException> consumer) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        return OutputDestination.of(Functions.exceptionConsumerBiConsumer(), consumer);
    }

    public static <T> OutputDestination of(ExceptionFunction<T, OutputStream, IOException> supplier, T param) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return new OutputStreamSupplierOutputDestination<T>(supplier, param);
    }

    public static OutputDestination of(ExceptionSupplier<OutputStream, IOException> supplier) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return OutputDestination.of(Functions.exceptionSupplierFunction(), supplier);
    }

    public static <T> OutputDestination of(ExceptionBiConsumer<T, Reader, IOException> consumer, T param, Charset charset) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return new ReaderConsumerOutputDestination<T>(consumer, param, charset);
    }

    public static OutputDestination of(ExceptionConsumer<Reader, IOException> consumer, Charset charset) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return OutputDestination.of(Functions.exceptionConsumerBiConsumer(), consumer, charset);
    }

    public static <T> OutputDestination of(ExceptionFunction<T, Appendable, IOException> supplier, T param, Charset charset) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return new AppendableSupplierOutputDestination<T>(supplier, param, charset);
    }

    public static OutputDestination of(ExceptionSupplier<Appendable, IOException> supplier, Charset charset) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return OutputDestination.of(Functions.exceptionSupplierFunction(), supplier, charset);
    }

    public static OutputDestination of(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        return new PathOutputDestination(path);
    }

    public static OutputDestination of(Appendable appendable, Charset charset) {
        Assert.checkNotNullParam((String)"appendable", (Object)appendable);
        return OutputDestination.of(ExceptionUnaryOperator.identity(), appendable, charset);
    }

    public static OutputDestination of(Appendable appendable) {
        return OutputDestination.of(appendable, StandardCharsets.UTF_8);
    }

    public static <T> OutputDestination of(ExceptionFunction<T, ProcessBuilder, IOException> supplier, T param, OutputDestination errorDest, OutputDestination outputDest) {
        return OutputDestination.of(supplier, param, errorDest, outputDest, ProcessOutputDestination.DEFAULT_CHECKER);
    }

    public static <T> OutputDestination of(ExceptionFunction<T, ProcessBuilder, IOException> supplier, T param, OutputDestination errorDest, OutputDestination outputDest, ExceptionConsumer<Process, IOException> checker) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        Assert.checkNotNullParam((String)"errorDest", (Object)errorDest);
        Assert.checkNotNullParam((String)"outputDest", (Object)outputDest);
        Assert.checkNotNullParam((String)"checker", checker);
        return new ProcessOutputDestination<T>(supplier, param, errorDest, outputDest, checker);
    }

    public static OutputDestination of(ExceptionSupplier<ProcessBuilder, IOException> supplier, OutputDestination errorDest, OutputDestination outputDest) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return OutputDestination.of(Functions.exceptionSupplierFunction(), supplier, errorDest, outputDest);
    }

    public static OutputDestination of(ExceptionSupplier<ProcessBuilder, IOException> supplier, OutputDestination errorDest, OutputDestination outputDest, ExceptionConsumer<Process, IOException> checker) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return OutputDestination.of(Functions.exceptionSupplierFunction(), supplier, errorDest, outputDest, checker);
    }

    public static OutputDestination of(ProcessBuilder processBuilder, OutputDestination errorDest, OutputDestination outputDest) {
        Assert.checkNotNullParam((String)"processBuilder", (Object)processBuilder);
        return OutputDestination.of(ExceptionUnaryOperator.identity(), processBuilder, errorDest, outputDest);
    }

    public static OutputDestination of(ProcessBuilder processBuilder, OutputDestination errorDest, OutputDestination outputDest, ExceptionConsumer<Process, IOException> checker) {
        Assert.checkNotNullParam((String)"processBuilder", (Object)processBuilder);
        return OutputDestination.of(ExceptionUnaryOperator.identity(), processBuilder, errorDest, outputDest, checker);
    }

    void transferFrom(InputSource source) throws IOException {
        try (InputStream is = source.openStream();){
            this.transferFrom(is);
        }
    }

    void transferFrom(EmptyInputSource source) throws IOException {
        this.transferFrom((InputSource)source);
    }

    void transferFrom(PathInputSource source) throws IOException {
        this.transferFrom((InputSource)source);
    }

    void transferFrom(InputStreamSupplierInputSource<?> source) throws IOException {
        this.transferFrom((InputSource)source);
    }

    void transferFrom(OutputStreamConsumerInputSource<?> source) throws IOException {
        this.transferFrom((InputSource)source);
    }

    void transferFrom(ReaderSupplierInputSource<?> source) throws IOException {
        this.transferFrom((InputSource)source);
    }

    void transferFrom(WriterConsumerInputSource<?> source) throws IOException {
        this.transferFrom((InputSource)source);
    }

    abstract void transferFrom(InputStream var1) throws IOException;

    abstract void transferFrom(Reader var1, Charset var2) throws IOException;

    Closeable transferFromErrorOf(Process process, ProcessBuilder.Redirect redirect) throws IOException {
        String name = "Error thread for process \"" + InputSource.nameOf(process) + "\" (pid " + process.pid() + ")";
        return Closeables.start(name, (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> {
            try (InputStream errorStream = process.getErrorStream();){
                this.transferFrom(errorStream);
            }
        }));
    }

    abstract ProcessBuilder.Redirect getOutputRedirect();

    List<ProcessBuilder> getBuilderPipeline(ProcessBuilder.Redirect inputRedirect, int index) throws IOException {
        return Arrays.asList(new ProcessBuilder[index]);
    }

    void chain(List<Process> processes, List<ProcessBuilder> processBuilders, int index) throws IOException {
        this.transferFrom(processes.get(index - 1).getInputStream());
    }
}

