/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.Set;
import org.qbicc.machine.llvm.FastMathFlag;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.Select;

final class SelectImpl
extends AbstractYieldingInstruction
implements Select {
    private final AbstractValue condType;
    private final AbstractValue cond;
    private final AbstractValue valueType;
    private final AbstractValue trueValue;
    private final AbstractValue falseValue;
    Set<FastMathFlag> flags = Set.of();

    public SelectImpl(BasicBlockImpl block, AbstractValue condType, AbstractValue cond, AbstractValue valueType, AbstractValue trueValue, AbstractValue falseValue) {
        super(block);
        this.condType = condType;
        this.cond = cond;
        this.valueType = valueType;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public Select meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Select comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Select withFlags(Set<FastMathFlag> flagSet) {
        Assert.checkNotNullParam((String)"flagSet", flagSet);
        this.flags = flagSet;
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("select");
        for (FastMathFlag flag : this.flags) {
            target.append(' ').append(flag.name());
        }
        target.append(' ');
        this.condType.appendTo(target);
        target.append(' ');
        this.cond.appendTo(target);
        target.append(',').append(' ');
        this.valueType.appendTo(target);
        target.append(' ');
        this.trueValue.appendTo(target);
        target.append(',').append(' ');
        this.valueType.appendTo(target);
        target.append(' ');
        this.falseValue.appendTo(target);
        return this.appendTrailer(target);
    }
}

