/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.llvm.DataLayout;
import org.qbicc.machine.llvm.Function;
import org.qbicc.machine.llvm.FunctionDefinition;
import org.qbicc.machine.llvm.Global;
import org.qbicc.machine.llvm.IdentifiedType;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Module;
import org.qbicc.machine.llvm.ModuleFlagBehavior;
import org.qbicc.machine.llvm.Types;
import org.qbicc.machine.llvm.Values;
import org.qbicc.machine.llvm.debuginfo.DIBasicType;
import org.qbicc.machine.llvm.debuginfo.DICompileUnit;
import org.qbicc.machine.llvm.debuginfo.DICompositeType;
import org.qbicc.machine.llvm.debuginfo.DIDerivedType;
import org.qbicc.machine.llvm.debuginfo.DIEncoding;
import org.qbicc.machine.llvm.debuginfo.DIExpression;
import org.qbicc.machine.llvm.debuginfo.DIFile;
import org.qbicc.machine.llvm.debuginfo.DIGlobalVariable;
import org.qbicc.machine.llvm.debuginfo.DIGlobalVariableExpression;
import org.qbicc.machine.llvm.debuginfo.DILocalVariable;
import org.qbicc.machine.llvm.debuginfo.DILocation;
import org.qbicc.machine.llvm.debuginfo.DISubprogram;
import org.qbicc.machine.llvm.debuginfo.DISubrange;
import org.qbicc.machine.llvm.debuginfo.DISubroutineType;
import org.qbicc.machine.llvm.debuginfo.DITag;
import org.qbicc.machine.llvm.debuginfo.DebugEmissionKind;
import org.qbicc.machine.llvm.debuginfo.MetadataTuple;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.DIBasicTypeImpl;
import org.qbicc.machine.llvm.impl.DICompileUnitImpl;
import org.qbicc.machine.llvm.impl.DICompositeTypeImpl;
import org.qbicc.machine.llvm.impl.DIDerivedTypeImpl;
import org.qbicc.machine.llvm.impl.DIExpressionImpl;
import org.qbicc.machine.llvm.impl.DIFileImpl;
import org.qbicc.machine.llvm.impl.DIGlobalVariableExpressionImpl;
import org.qbicc.machine.llvm.impl.DIGlobalVariableImpl;
import org.qbicc.machine.llvm.impl.DILocalVariableImpl;
import org.qbicc.machine.llvm.impl.DILocationImpl;
import org.qbicc.machine.llvm.impl.DISubprogramImpl;
import org.qbicc.machine.llvm.impl.DISubrangeImpl;
import org.qbicc.machine.llvm.impl.DISubroutineTypeImpl;
import org.qbicc.machine.llvm.impl.DataLayoutImpl;
import org.qbicc.machine.llvm.impl.Emittable;
import org.qbicc.machine.llvm.impl.FunctionDeclarationImpl;
import org.qbicc.machine.llvm.impl.FunctionDefinitionImpl;
import org.qbicc.machine.llvm.impl.GlobalImpl;
import org.qbicc.machine.llvm.impl.IdentifiedTypeImpl;
import org.qbicc.machine.llvm.impl.MetadataTupleImpl;
import org.qbicc.machine.llvm.impl.SourceFileImpl;

final class ModuleImpl
implements Module {
    private final List<Emittable> header = new ArrayList<Emittable>();
    private final List<Emittable> types = new ArrayList<Emittable>();
    private final List<Emittable> globals = new ArrayList<Emittable>();
    private final List<Emittable> functions = new ArrayList<Emittable>();
    private final List<Emittable> namedMeta = new ArrayList<Emittable>();
    private final List<Emittable> meta = new ArrayList<Emittable>();
    private int globalCounter;
    private int metadataNodeCounter;
    private MetadataTuple flags;
    private MetadataTuple compileUnits;

    ModuleImpl() {
    }

    private <E extends Emittable> E add(List<Emittable> itemList, E item) {
        itemList.add(item);
        return item;
    }

    @Override
    public DataLayout dataLayout() {
        return this.add(this.header, new DataLayoutImpl());
    }

    @Override
    public void sourceFileName(String path) {
        this.add(this.header, new SourceFileImpl(path));
    }

    @Override
    public FunctionDefinition define(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.add(this.functions, new FunctionDefinitionImpl(this, name));
    }

    @Override
    public Function declare(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.add(this.functions, new FunctionDeclarationImpl(name));
    }

    @Override
    public Global global(LLValue type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.add(this.globals, new GlobalImpl(this, false, (AbstractValue)type));
    }

    @Override
    public Global constant(LLValue type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.add(this.globals, new GlobalImpl(this, true, (AbstractValue)type));
    }

    @Override
    public IdentifiedType identifiedType() {
        return this.identifiedType("T" + this.nextGlobalId());
    }

    @Override
    public IdentifiedType identifiedType(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.add(this.types, new IdentifiedTypeImpl(name));
    }

    @Override
    public MetadataTuple metadataTuple() {
        return this.add(this.meta, new MetadataTupleImpl(this.nextMetadataNodeId()));
    }

    @Override
    public MetadataTuple metadataTuple(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.add(this.namedMeta, new MetadataTupleImpl(name));
    }

    @Override
    public DICompileUnit diCompileUnit(String language, LLValue file, DebugEmissionKind emissionKind) {
        Assert.checkNotNullParam((String)"language", (Object)language);
        Assert.checkNotNullParam((String)"file", (Object)file);
        Assert.checkNotNullParam((String)"emissionKind", (Object)((Object)emissionKind));
        DICompileUnitImpl diCompileUnit = new DICompileUnitImpl(this.nextMetadataNodeId(), language, (AbstractValue)file, emissionKind);
        if (this.compileUnits == null) {
            this.compileUnits = this.metadataTuple("llvm.dbg.cu");
        }
        this.compileUnits.elem(null, diCompileUnit.asRef());
        return this.add(this.meta, diCompileUnit);
    }

    @Override
    public DIFile diFile(String filename, String directory) {
        Assert.checkNotNullParam((String)"filename", (Object)filename);
        Assert.checkNotNullParam((String)"directory", (Object)directory);
        return this.add(this.meta, new DIFileImpl(this.nextMetadataNodeId(), filename, directory));
    }

    @Override
    public DILocation diLocation(int line, int column, LLValue scope, LLValue inlinedAt) {
        Assert.checkNotNullParam((String)"scope", (Object)scope);
        return this.add(this.meta, new DILocationImpl(this.nextMetadataNodeId(), line, column, (AbstractValue)scope, (AbstractValue)inlinedAt));
    }

    @Override
    public DISubprogram diSubprogram(String name, LLValue type, LLValue unit) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"unit", (Object)unit);
        return this.add(this.meta, new DISubprogramImpl(this.nextMetadataNodeId(), name, (AbstractValue)type, (AbstractValue)unit));
    }

    @Override
    public DISubrange diSubrange(long count) {
        return this.add(this.meta, new DISubrangeImpl(this.nextMetadataNodeId(), count));
    }

    @Override
    public DIBasicType diBasicType(DIEncoding encoding, long size, int align) {
        Assert.checkNotNullParam((String)"encoding", (Object)((Object)encoding));
        return this.add(this.meta, new DIBasicTypeImpl(this.nextMetadataNodeId(), encoding, size, align));
    }

    @Override
    public DIDerivedType diDerivedType(DITag tag, long size, int align) {
        Assert.checkNotNullParam((String)"tag", (Object)((Object)tag));
        return this.add(this.meta, new DIDerivedTypeImpl(this.nextMetadataNodeId(), tag, size, align));
    }

    @Override
    public DICompositeType diCompositeType(DITag tag, long size, int align) {
        Assert.checkNotNullParam((String)"tag", (Object)((Object)tag));
        return this.add(this.meta, new DICompositeTypeImpl(this.nextMetadataNodeId(), tag, size, align));
    }

    @Override
    public DISubroutineType diSubroutineType(LLValue types) {
        Assert.checkNotNullParam((String)"types", (Object)types);
        return this.add(this.meta, new DISubroutineTypeImpl(this.nextMetadataNodeId(), (AbstractValue)types));
    }

    @Override
    public DILocalVariable diLocalVariable(String name, LLValue type, LLValue scope, LLValue file, int line, int align) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"scope", (Object)scope);
        Assert.checkNotNullParam((String)"file", (Object)file);
        return this.add(this.meta, new DILocalVariableImpl(this.nextMetadataNodeId(), name, (AbstractValue)type, (AbstractValue)scope, (AbstractValue)file, line, align));
    }

    @Override
    public DIExpression diExpression() {
        return this.add(this.meta, new DIExpressionImpl(this.nextMetadataNodeId()));
    }

    @Override
    public DIGlobalVariableExpression diGlobalVariableExpression(LLValue var_, LLValue expr) {
        Assert.checkNotNullParam((String)"var_", (Object)var_);
        Assert.checkNotNullParam((String)"expr", (Object)expr);
        return this.add(this.meta, new DIGlobalVariableExpressionImpl(this.nextMetadataNodeId(), (AbstractValue)var_, (AbstractValue)expr));
    }

    @Override
    public DIGlobalVariable diGlobalVariable(String name, LLValue type, LLValue scope, LLValue file, int line, int align) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"scope", (Object)scope);
        Assert.checkNotNullParam((String)"file", (Object)file);
        return this.add(this.meta, new DIGlobalVariableImpl(this.nextMetadataNodeId(), name, (AbstractValue)type, (AbstractValue)scope, (AbstractValue)file, line, align));
    }

    int nextGlobalId() {
        return this.globalCounter++;
    }

    int nextMetadataNodeId() {
        return this.metadataNodeCounter++;
    }

    @Override
    public void addFlag(ModuleFlagBehavior behavior, String name, LLValue type, LLValue value) {
        Assert.checkNotNullParam((String)"behavior", (Object)((Object)behavior));
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"value", (Object)value);
        if (this.flags == null) {
            this.flags = this.metadataTuple("llvm.module.flags");
        }
        LLValue flag = this.metadataTuple().elem(Types.i32, Values.intConstant(behavior.value)).elem(null, Values.metadataString(name)).elem(type, value).asRef();
        this.flags.elem(null, flag);
    }

    private void writeItems(List<Emittable> items, BufferedWriter output, boolean lineBetweenItems) throws IOException {
        for (Emittable item : items) {
            item.appendTo(output);
            output.newLine();
            if (!lineBetweenItems) continue;
            output.newLine();
        }
        if (!items.isEmpty() && !lineBetweenItems) {
            output.newLine();
        }
    }

    @Override
    public void writeTo(BufferedWriter output) throws IOException {
        this.writeItems(this.header, output, true);
        this.writeItems(this.types, output, false);
        this.writeItems(this.functions, output, true);
        this.writeItems(this.globals, output, false);
        this.writeItems(this.namedMeta, output, false);
        this.writeItems(this.meta, output, false);
    }
}

