/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.Load;
import org.qbicc.machine.llvm.op.OrderingConstraint;

final class LoadImpl
extends AbstractYieldingInstruction
implements Load {
    final AbstractValue type;
    final AbstractValue pointeeType;
    final AbstractValue pointer;
    int alignment;
    boolean volatile_;
    OrderingConstraint constraint;
    String syncScope;

    LoadImpl(BasicBlockImpl block, AbstractValue type, AbstractValue pointeeType, AbstractValue pointer) {
        super(block);
        this.type = type;
        this.pointeeType = pointeeType;
        this.pointer = pointer;
    }

    @Override
    public Load meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Load comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Load align(int alignment) {
        Assert.checkMinimumParameter((String)"alignment", (int)1, (int)alignment);
        if (Integer.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power of two");
        }
        this.alignment = alignment;
        return this;
    }

    @Override
    public Load atomic(OrderingConstraint constraint) {
        Assert.checkNotNullParam((String)"constraint", (Object)((Object)constraint));
        this.constraint = constraint;
        return this;
    }

    @Override
    public Load atomic(OrderingConstraint constraint, String syncScope) {
        Assert.checkNotNullParam((String)"constraint", (Object)((Object)constraint));
        Assert.checkNotNullParam((String)"syncScope", (Object)syncScope);
        this.constraint = constraint;
        this.syncScope = syncScope;
        return this;
    }

    @Override
    public Load volatile_() {
        this.volatile_ = true;
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("load");
        OrderingConstraint constraint = this.constraint;
        if (constraint != null) {
            target.append(' ').append("atomic");
        }
        if (this.volatile_) {
            target.append(' ').append("volatile");
        }
        target.append(' ');
        this.pointeeType.appendTo(target);
        target.append(',').append(' ');
        this.type.appendTo(target);
        target.append(' ');
        this.pointer.appendTo(target);
        if (constraint != null) {
            String syncScope = this.syncScope;
            if (syncScope != null) {
                target.append(' ').append("syncScope").append('(').append('\"').append(syncScope).append('\"').append(')');
            }
            target.append(' ').append(constraint.name());
        }
        if (this.alignment != 0) {
            target.append(',').append(' ');
            target.append("align").append(' ');
            target.append(Integer.toString(this.alignment));
        }
        return this.appendTrailer(target);
    }
}

