/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.AddressNaming;
import org.qbicc.machine.llvm.DllStorageClass;
import org.qbicc.machine.llvm.Global;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Linkage;
import org.qbicc.machine.llvm.RuntimePreemption;
import org.qbicc.machine.llvm.ThreadLocalStorageModel;
import org.qbicc.machine.llvm.Visibility;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.ModuleImpl;

final class GlobalImpl
extends AbstractYieldingInstruction
implements Global {
    final boolean constant;
    final AbstractValue type;
    Linkage linkage = Linkage.EXTERNAL;
    Visibility visibility = Visibility.DEFAULT;
    DllStorageClass dllStorageClass = DllStorageClass.NONE;
    AddressNaming addressNaming = AddressNaming.NAMED;
    RuntimePreemption preemption = RuntimePreemption.PREEMPTABLE;
    String section;
    int addressSpace = 0;
    int alignment = 0;
    AbstractValue value;
    ThreadLocalStorageModel threadLocalStorageModel;
    boolean appending;

    GlobalImpl(ModuleImpl module, boolean constant, AbstractValue type) {
        super(module);
        this.constant = constant;
        this.type = type;
    }

    @Override
    public Global value(LLValue value) {
        this.value = (AbstractValue)value;
        return this;
    }

    @Override
    public Global meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Global comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Global dllStorageClass(DllStorageClass dllStorageClass) {
        this.dllStorageClass = (DllStorageClass)((Object)Assert.checkNotNullParam((String)"dllStorageClass", (Object)((Object)dllStorageClass)));
        return this;
    }

    @Override
    public Global alignment(int alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public Global preemption(RuntimePreemption preemption) {
        this.preemption = (RuntimePreemption)((Object)Assert.checkNotNullParam((String)"preemption", (Object)((Object)preemption)));
        return this;
    }

    @Override
    public Global section(String section) {
        this.section = (String)Assert.checkNotNullParam((String)"section", (Object)section);
        return this;
    }

    @Override
    public Global linkage(Linkage linkage) {
        this.linkage = (Linkage)((Object)Assert.checkNotNullParam((String)"linkage", (Object)((Object)linkage)));
        return this;
    }

    @Override
    public Global visibility(Visibility visibility) {
        this.visibility = (Visibility)((Object)Assert.checkNotNullParam((String)"visibility", (Object)((Object)visibility)));
        return this;
    }

    @Override
    public Global threadLocal(ThreadLocalStorageModel model) {
        this.threadLocalStorageModel = (ThreadLocalStorageModel)((Object)Assert.checkNotNullParam((String)"model", (Object)((Object)model)));
        return this;
    }

    @Override
    public Global addressSpace(int addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    @Override
    public Global appending() {
        this.appending = true;
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        int alignment;
        String section;
        int addressSpace;
        AddressNaming addressNaming;
        ThreadLocalStorageModel model;
        DllStorageClass dllStorageClass;
        Visibility visibility;
        RuntimePreemption preemption;
        super.appendTo(target);
        Linkage linkage = this.linkage;
        AbstractValue value = this.value;
        if (value == null || linkage != Linkage.EXTERNAL) {
            target.append(linkage.toString());
            target.append(' ');
        }
        if ((preemption = this.preemption) != RuntimePreemption.PREEMPTABLE) {
            target.append(preemption.toString());
            target.append(' ');
        }
        if ((visibility = this.visibility) != Visibility.DEFAULT) {
            target.append(visibility.toString());
            target.append(' ');
        }
        if ((dllStorageClass = this.dllStorageClass) != DllStorageClass.NONE) {
            target.append(dllStorageClass.toString());
            target.append(' ');
        }
        if ((model = this.threadLocalStorageModel) != null) {
            target.append("thread_local");
            if (model != ThreadLocalStorageModel.GENERAL_DYNAMIC) {
                target.append('(');
                target.append(model.toString());
                target.append(')');
            }
            target.append(' ');
        }
        if ((addressNaming = this.addressNaming) != AddressNaming.NAMED) {
            target.append(addressNaming.toString());
            target.append(' ');
        }
        if ((addressSpace = this.addressSpace) != 0) {
            target.append("addrspace(");
            target.append(Integer.toString(addressSpace));
            target.append(") ");
        }
        if (this.appending) {
            target.append("appending");
            target.append(' ');
        }
        if (this.constant) {
            target.append("constant");
        } else {
            target.append("global");
        }
        target.append(' ');
        this.type.appendTo(target);
        if (value != null) {
            target.append(' ');
            value.appendTo(target);
        }
        if ((section = this.section) != null) {
            target.append(',');
            target.append(' ');
            target.append("section");
            target.append(' ');
            target.append('\"');
            target.append(section);
            target.append('\"');
        }
        if ((alignment = this.alignment) != 0) {
            target.append(',');
            target.append(' ');
            target.append("align");
            target.append(' ');
            target.append(Integer.toString(alignment));
        }
        this.appendMeta(target);
        return target;
    }
}

