/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.GetElementPtr;

final class GetElementPtrImpl
extends AbstractYieldingInstruction
implements GetElementPtr {
    private final AbstractValue type;
    private final AbstractValue ptrType;
    private final AbstractValue pointer;
    ArgImpl lastArg;

    GetElementPtrImpl(BasicBlockImpl basicBlock, AbstractValue type, AbstractValue ptrType, AbstractValue pointer) {
        super(basicBlock);
        this.type = type;
        this.ptrType = ptrType;
        this.pointer = pointer;
    }

    @Override
    public GetElementPtr comment(String comment) {
        return (GetElementPtr)super.comment(comment);
    }

    @Override
    public GetElementPtr meta(String name, LLValue data) {
        return (GetElementPtr)super.meta(name, data);
    }

    @Override
    public GetElementPtr arg(boolean inRange, LLValue type, LLValue index) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"index", (Object)index);
        this.lastArg = new ArgImpl(inRange, (AbstractValue)type, (AbstractValue)index, this.lastArg);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("getelementptr");
        target.append(' ');
        this.type.appendTo(target);
        target.append(',');
        target.append(' ');
        this.ptrType.appendTo(target);
        target.append(' ');
        this.pointer.appendTo(target);
        ArgImpl lastArg = this.lastArg;
        if (lastArg != null) {
            lastArg.appendTo(target);
        }
        return this.appendTrailer(target);
    }

    static final class ArgImpl
    extends AbstractEmittable {
        final boolean inRange;
        final AbstractValue type;
        final AbstractValue index;
        final ArgImpl prev;

        ArgImpl(boolean inRange, AbstractValue type, AbstractValue index, ArgImpl prev) {
            this.inRange = inRange;
            this.type = type;
            this.index = index;
            this.prev = prev;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            ArgImpl prev = this.prev;
            if (prev != null) {
                prev.appendTo(target);
            }
            target.append(',');
            target.append(' ');
            if (this.inRange) {
                target.append("inrange");
                target.append(' ');
            }
            this.type.appendTo(target);
            target.append(' ');
            this.index.appendTo(target);
            return target;
        }
    }
}

