/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class GetElementPtrConstant
extends AbstractValue {
    private final LLValue type;
    private final LLValue ptrType;
    private final LLValue pointer;
    ArgImpl lastArg;

    GetElementPtrConstant(LLValue type, LLValue ptrType, LLValue pointer, LLValue ... args) {
        this.type = type;
        this.ptrType = ptrType;
        this.pointer = pointer;
        Iterator iterator = Arrays.stream(args).iterator();
        while (iterator.hasNext()) {
            LLValue argType = (LLValue)iterator.next();
            LLValue argIndex = (LLValue)iterator.next();
            this.lastArg = new ArgImpl((AbstractValue)argType, (AbstractValue)argIndex, this.lastArg);
        }
    }

    public GetElementPtrConstant arg(boolean inRange, LLValue type, LLValue index) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"index", (Object)index);
        this.lastArg = new ArgImpl((AbstractValue)type, (AbstractValue)index, this.lastArg);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append("getelementptr (");
        target.append(' ');
        ((AbstractValue)this.type).appendTo(target);
        target.append(',');
        target.append(' ');
        ((AbstractValue)this.ptrType).appendTo(target);
        target.append(' ');
        ((AbstractValue)this.pointer).appendTo(target);
        ArgImpl lastArg = this.lastArg;
        if (lastArg != null) {
            lastArg.appendTo(target);
        }
        target.append(")");
        return target;
    }

    private static final class ArgImpl
    extends AbstractEmittable {
        final boolean inRange;
        final AbstractValue type;
        final AbstractValue index;
        final ArgImpl prev;

        ArgImpl(AbstractValue type, AbstractValue index, ArgImpl prev) {
            this.inRange = false;
            this.type = type;
            this.index = index;
            this.prev = prev;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            ArgImpl prev = this.prev;
            if (prev != null) {
                prev.appendTo(target);
            }
            target.append(',');
            target.append(' ');
            if (this.inRange) {
                target.append("inrange");
                target.append(' ');
            }
            this.type.appendTo(target);
            target.append(' ');
            this.index.appendTo(target);
            return target;
        }
    }
}

