/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class FunctionType
extends AbstractValue {
    final AbstractValue returnType;
    private final List<LLValue> argTypes;
    private final boolean variadic;

    FunctionType(LLValue returnType, List<LLValue> argTypes, boolean variadic) {
        this.returnType = (AbstractValue)returnType;
        this.argTypes = argTypes;
        this.variadic = variadic;
    }

    boolean isVariadic() {
        return this.variadic;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        this.returnType.appendTo(target);
        target.append(' ');
        target.append('(');
        Iterator<LLValue> iterator = this.argTypes.iterator();
        if (iterator.hasNext()) {
            ((AbstractValue)iterator.next()).appendTo(target);
            while (iterator.hasNext()) {
                target.append(',');
                target.append(' ');
                ((AbstractValue)iterator.next()).appendTo(target);
            }
            if (this.variadic) {
                target.append(',');
                target.append(' ');
            }
        }
        if (this.variadic) {
            target.append("...");
        }
        target.append(')');
        return target;
    }
}

