/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.AddressNaming;
import org.qbicc.machine.llvm.CallingConvention;
import org.qbicc.machine.llvm.DllStorageClass;
import org.qbicc.machine.llvm.FunctionDefinition;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Linkage;
import org.qbicc.machine.llvm.RuntimePreemption;
import org.qbicc.machine.llvm.Visibility;
import org.qbicc.machine.llvm.impl.AbstractFunction;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.impl.ModuleImpl;

final class FunctionDefinitionImpl
extends AbstractFunction
implements FunctionDefinition {
    final ModuleImpl module;
    final BasicBlockImpl rootBlock;
    BasicBlockImpl lastBlock;
    String section;
    RuntimePreemption preemption;
    private int blockCounter;
    private int localCounter;
    private String gc;
    private AbstractValue personalityType;
    private AbstractValue personalityValue;

    FunctionDefinitionImpl(ModuleImpl module, String name) {
        super(name);
        this.lastBlock = this.rootBlock = new BasicBlockImpl(null, this);
        this.preemption = RuntimePreemption.PREEMPTABLE;
        this.gc = null;
        this.personalityType = null;
        this.personalityValue = null;
        this.module = module;
    }

    @Override
    public FunctionDefinition section(String section) {
        this.section = (String)Assert.checkNotNullParam((String)"section", (Object)section);
        return this;
    }

    @Override
    public FunctionDefinition preemption(RuntimePreemption preemption) {
        this.preemption = (RuntimePreemption)((Object)Assert.checkNotNullParam((String)"preemption", (Object)((Object)preemption)));
        return this;
    }

    @Override
    public FunctionDefinition personality(LLValue personalityValue, LLValue personalityType) {
        this.personalityValue = (AbstractValue)Assert.checkNotNullParam((String)"personalityValue", (Object)personalityValue);
        this.personalityType = (AbstractValue)Assert.checkNotNullParam((String)"personalityType", (Object)personalityType);
        return this;
    }

    @Override
    public FunctionDefinition gc(String gc) {
        this.gc = gc;
        return this;
    }

    @Override
    public FunctionDefinitionImpl linkage(Linkage linkage) {
        super.linkage(linkage);
        return this;
    }

    @Override
    public FunctionDefinitionImpl visibility(Visibility visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public FunctionDefinitionImpl dllStorageClass(DllStorageClass dllStorageClass) {
        super.dllStorageClass(dllStorageClass);
        return this;
    }

    @Override
    public FunctionDefinitionImpl callingConvention(CallingConvention callingConvention) {
        super.callingConvention(callingConvention);
        return this;
    }

    @Override
    public FunctionDefinitionImpl addressNaming(AddressNaming addressNaming) {
        super.addressNaming(addressNaming);
        return this;
    }

    @Override
    public FunctionDefinitionImpl addressSpace(int addressSpace) {
        super.addressSpace(addressSpace);
        return this;
    }

    @Override
    public FunctionDefinitionImpl alignment(int alignment) {
        super.alignment(alignment);
        return this;
    }

    @Override
    public FunctionDefinitionImpl variadic() {
        super.variadic();
        return this;
    }

    @Override
    public FunctionDefinitionImpl meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public FunctionDefinitionImpl comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public LLBasicBlock createBlock() {
        this.lastBlock = new BasicBlockImpl(this.lastBlock, this);
        return this.lastBlock;
    }

    @Override
    public LLBasicBlock getRootBlock() {
        return this.rootBlock;
    }

    private void appendPreemption(Appendable target) throws IOException {
        if (this.preemption != RuntimePreemption.PREEMPTABLE) {
            target.append(this.preemption.toString()).append(' ');
        }
    }

    private void appendSection(Appendable target) throws IOException {
        if (this.section != null) {
            target.append(" section ");
            FunctionDefinitionImpl.appendEscapedString(target, this.section);
        }
    }

    private void appendGc(Appendable target) throws IOException {
        if (this.gc != null) {
            target.append(" gc ");
            FunctionDefinitionImpl.appendEscapedString(target, this.gc);
        }
    }

    private void appendPersonality(Appendable target) throws IOException {
        if (this.personalityValue != null) {
            target.append(" personality ");
            this.personalityType.appendTo(target);
            this.personalityValue.appendTo(target);
        }
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append("define ");
        this.appendLinkage(target);
        this.appendPreemption(target);
        this.appendVisibility(target);
        this.appendDllStorageClass(target);
        this.appendCallingConvention(target);
        this.appendNameAndType(target);
        this.appendAddressNaming(target);
        this.appendAddressSpace(target);
        this.appendFunctionAttributes(target);
        this.appendAlign(target);
        this.appendSection(target);
        this.appendGc(target);
        this.appendPersonality(target);
        this.appendMeta(target);
        target.append(" {");
        this.appendComment(target);
        target.append(System.lineSeparator());
        this.lastBlock.appendAsBlockTo(target);
        target.append('}');
        return target;
    }

    void assignName(BasicBlockImpl basicBlock) {
        basicBlock.name("B" + Integer.toHexString(this.blockCounter++));
    }

    int nextLocalId() {
        return this.localCounter++;
    }
}

