/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractInstruction;
import org.qbicc.machine.llvm.op.Fence;
import org.qbicc.machine.llvm.op.OrderingConstraint;

final class FenceImpl
extends AbstractInstruction
implements Fence {
    final OrderingConstraint ordering;
    String syncScope;

    FenceImpl(OrderingConstraint ordering) {
        this.ordering = ordering;
    }

    @Override
    public Fence syncScope(String scopeName) {
        Assert.checkNotNullParam((String)"scopeName", (Object)scopeName);
        this.syncScope = scopeName;
        return this;
    }

    @Override
    public Fence meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Fence comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("fence").append(' ');
        String syncScope = this.syncScope;
        if (syncScope != null) {
            target.append("syncscope").append('(').append('\"').append(syncScope).append('\"').append(')').append(' ');
        }
        target.append(this.ordering.name());
        return this.appendTrailer(target);
    }
}

