/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.EnumSet;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DISPFlags;
import org.qbicc.machine.llvm.debuginfo.DISubprogram;
import org.qbicc.machine.llvm.debuginfo.Virtuality;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

public class DISubprogramImpl
extends AbstractMetadataNode
implements DISubprogram {
    private final String name;
    private String linkageName;
    private AbstractValue scope;
    private AbstractValue file;
    private int line;
    private final AbstractValue type;
    private boolean isLocal;
    private boolean isDefinition = true;
    private int scopeLine;
    private AbstractValue containingType;
    private Virtuality virtuality = Virtuality.None;
    private int virtualIndex;
    private EnumSet<DIFlags> flags = EnumSet.noneOf(DIFlags.class);
    private EnumSet<DISPFlags> spFlags = EnumSet.noneOf(DISPFlags.class);
    private boolean isOptimized;
    private final AbstractValue unit;
    private AbstractValue templateParams;
    private AbstractValue declaration;
    private AbstractValue retainedNodes;
    private AbstractValue thrownTypes;

    DISubprogramImpl(int index, String name, AbstractValue type, AbstractValue unit) {
        super(index);
        this.name = name;
        this.type = type;
        this.unit = unit;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("distinct !DISubprogram(name: ");
        DISubprogramImpl.appendEscapedString(target, this.name);
        if (this.linkageName != null) {
            target.append(", linkageName: ");
            DISubprogramImpl.appendEscapedString(target, this.linkageName);
        }
        if (this.scope != null) {
            target.append(", scope: ");
            this.scope.appendTo(target);
        }
        if (this.file != null) {
            target.append(", file: ");
            this.file.appendTo(target);
            target.append(", line: ");
            DISubprogramImpl.appendDecimal(target, this.line);
        }
        target.append(", type: ");
        this.type.appendTo(target);
        target.append(", isLocal: ");
        target.append(this.isLocal ? "true" : "false");
        target.append(", isDefinition: ");
        target.append(this.isDefinition ? "true" : "false");
        if (this.file != null) {
            target.append(", scopeLine: ");
            DISubprogramImpl.appendDecimal(target, this.scopeLine);
        }
        if (this.containingType != null) {
            target.append(", containingType: ");
            this.containingType.appendTo(target);
        }
        target.append(", virtuality: ");
        target.append(this.virtuality.name);
        if (this.virtuality != Virtuality.None) {
            target.append(", virtualIndex: ");
            DISubprogramImpl.appendDecimal(target, this.virtualIndex);
        }
        if (!this.flags.isEmpty()) {
            target.append(", flags: ");
            DISubprogramImpl.appendDiFlags(target, this.flags);
        }
        if (!this.spFlags.isEmpty()) {
            target.append(", spFlags: ");
            DISubprogramImpl.appendDiSpFlags(target, this.spFlags);
        }
        target.append(", isOptimized: ");
        target.append(this.isOptimized ? "true" : "false");
        target.append(", unit: ");
        this.unit.appendTo(target);
        if (this.templateParams != null) {
            target.append(", templateParams: ");
            this.templateParams.appendTo(target);
        }
        if (this.declaration != null) {
            target.append(", declaration: ");
            this.declaration.appendTo(target);
        }
        if (this.retainedNodes != null) {
            target.append(", retainedNodes: ");
            this.retainedNodes.appendTo(target);
        }
        if (this.thrownTypes != null) {
            target.append(", thrownTypes: ");
            this.thrownTypes.appendTo(target);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DISubprogram linkageName(String linkageName) {
        this.linkageName = linkageName;
        return this;
    }

    @Override
    public DISubprogram scope(LLValue scope) {
        this.scope = (AbstractValue)scope;
        return this;
    }

    @Override
    public DISubprogram location(LLValue file, int line, int scopeLine) {
        this.file = (AbstractValue)file;
        this.line = line;
        this.scopeLine = scopeLine;
        return this;
    }

    @Override
    public DISubprogram isLocal(boolean isLocal) {
        this.isLocal = isLocal;
        return this;
    }

    @Override
    public DISubprogram isDefinition(boolean isDefinition) {
        this.isDefinition = isDefinition;
        return this;
    }

    @Override
    public DISubprogram containingType(LLValue containingType) {
        this.containingType = (AbstractValue)containingType;
        return this;
    }

    @Override
    public DISubprogram virtuality(Virtuality virtuality, int virtualIndex) {
        Assert.checkNotNullParam((String)"virtuality", (Object)((Object)virtuality));
        this.virtuality = virtuality;
        this.virtualIndex = virtualIndex;
        return this;
    }

    @Override
    public DISubprogram flags(EnumSet<DIFlags> flags, EnumSet<DISPFlags> spFlags) {
        Assert.checkNotNullParam((String)"flags", flags);
        Assert.checkNotNullParam((String)"spFlags", spFlags);
        this.flags = flags;
        this.spFlags = spFlags;
        return this;
    }

    @Override
    public DISubprogram isOptimized(boolean isOptimized) {
        this.isOptimized = isOptimized;
        return this;
    }

    @Override
    public DISubprogram templateParams(LLValue templateParams) {
        this.templateParams = (AbstractValue)templateParams;
        return this;
    }

    @Override
    public DISubprogram declaration(LLValue declaration) {
        this.declaration = (AbstractValue)declaration;
        return this;
    }

    @Override
    public DISubprogram retainedNodes(LLValue retainedNodes) {
        this.retainedNodes = (AbstractValue)retainedNodes;
        return this;
    }

    @Override
    public DISubprogram thrownTypes(LLValue thrownTypes) {
        this.thrownTypes = (AbstractValue)thrownTypes;
        return this;
    }

    @Override
    public DISubprogram comment(String comment) {
        return (DISubprogram)super.comment(comment);
    }
}

