/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.EnumSet;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DILocalVariable;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class DILocalVariableImpl
extends AbstractMetadataNode
implements DILocalVariable {
    private final String name;
    private final AbstractValue type;
    private final AbstractValue scope;
    private final AbstractValue file;
    private final int line;
    private final int align;
    private int argument = -1;
    private EnumSet<DIFlags> flags = EnumSet.noneOf(DIFlags.class);

    DILocalVariableImpl(int index, String name, AbstractValue type, AbstractValue scope, AbstractValue file, int line, int align) {
        super(index);
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.file = file;
        this.line = line;
        this.align = align;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("!DILocalVariable(name: ");
        DILocalVariableImpl.appendEscapedString(target, this.name);
        target.append(", type: ");
        this.type.appendTo(target);
        target.append(", align: ");
        DILocalVariableImpl.appendDecimal(target, this.align);
        if (this.scope != null) {
            target.append(", scope: ");
            this.scope.appendTo(target);
        }
        if (this.file != null) {
            target.append(", file: ");
            this.file.appendTo(target);
            target.append(", line: ");
            DILocalVariableImpl.appendDecimal(target, this.line);
        }
        if (this.argument != -1) {
            target.append(", arg: ");
            DILocalVariableImpl.appendDecimal(target, this.argument);
        }
        if (!this.flags.isEmpty()) {
            target.append(", flags: ");
            DILocalVariableImpl.appendDiFlags(target, this.flags);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DILocalVariable comment(String comment) {
        return (DILocalVariable)super.comment(comment);
    }

    @Override
    public DILocalVariable argument(int index) {
        this.argument = index;
        return this;
    }

    @Override
    public DILocalVariable flags(EnumSet<DIFlags> flags) {
        this.flags = (EnumSet)Assert.checkNotNullParam((String)"flags", flags);
        return this;
    }
}

