/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.EnumSet;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DIGlobalVariable;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class DIGlobalVariableImpl
extends AbstractMetadataNode
implements DIGlobalVariable {
    private final String name;
    private final AbstractValue type;
    private final AbstractValue scope;
    private final AbstractValue file;
    private final int line;
    private final int align;
    private int argument = -1;
    private EnumSet<DIFlags> flags = EnumSet.noneOf(DIFlags.class);
    private boolean isDefinition;
    private boolean isLocal;

    DIGlobalVariableImpl(int index, String name, AbstractValue type, AbstractValue scope, AbstractValue file, int line, int align) {
        super(index);
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.file = file;
        this.line = line;
        this.align = align;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("!DIGlobalVariable(name: ");
        DIGlobalVariableImpl.appendEscapedString(target, this.name);
        target.append(", type: ");
        this.type.appendTo(target);
        target.append(", align: ");
        DIGlobalVariableImpl.appendDecimal(target, this.align);
        if (this.scope != null) {
            target.append(", scope: ");
            this.scope.appendTo(target);
        }
        if (this.file != null) {
            target.append(", file: ");
            this.file.appendTo(target);
            target.append(", line: ");
            DIGlobalVariableImpl.appendDecimal(target, this.line);
        }
        if (this.argument != -1) {
            target.append(", arg: ");
            DIGlobalVariableImpl.appendDecimal(target, this.argument);
        }
        if (!this.flags.isEmpty()) {
            target.append(", flags: ");
            DIGlobalVariableImpl.appendDiFlags(target, this.flags);
        }
        target.append(", isDefinition: ");
        target.append(Boolean.toString(this.isDefinition));
        target.append(", isLocal: ");
        target.append(Boolean.toString(this.isLocal));
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DIGlobalVariable comment(String comment) {
        return (DIGlobalVariable)super.comment(comment);
    }

    public DIGlobalVariable argument(int index) {
        this.argument = index;
        return this;
    }

    @Override
    public DIGlobalVariable flags(EnumSet<DIFlags> flags) {
        this.flags = (EnumSet)Assert.checkNotNullParam((String)"flags", flags);
        return this;
    }

    @Override
    public DIGlobalVariable isDefinition() {
        this.isDefinition = true;
        return this;
    }

    @Override
    public DIGlobalVariable isLocal() {
        this.isLocal = true;
        return null;
    }
}

