/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DIEncoding;
import org.qbicc.machine.llvm.debuginfo.DIExpression;
import org.qbicc.machine.llvm.debuginfo.DIOpcode;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class DIExpressionImpl
extends AbstractMetadataNode
implements DIExpression {
    Arg lastArg;
    final AsValue value = new AsValue();

    DIExpressionImpl(int index) {
        super(index);
    }

    DIExpressionImpl() {
        super(-1);
    }

    @Override
    public DIExpression comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        this.value.appendTo(target);
        return target;
    }

    @Override
    public DIExpression arg(int value) {
        this.lastArg = new IntArg(this.lastArg, value);
        return this;
    }

    @Override
    public DIExpression arg(DIOpcode op) {
        this.lastArg = new EnumArg(this.lastArg, op);
        return this;
    }

    @Override
    public DIExpression arg(DIEncoding op) {
        this.lastArg = new EnumArg(this.lastArg, op);
        return this;
    }

    @Override
    public LLValue asValue() {
        return this.value;
    }

    final class AsValue
    extends AbstractValue {
        AsValue() {
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            target.append("!DIExpression(");
            if (DIExpressionImpl.this.lastArg != null) {
                DIExpressionImpl.this.lastArg.appendTo(target);
            }
            target.append(")");
            return target;
        }
    }

    static final class IntArg
    extends Arg {
        final int val;

        IntArg(Arg prev, int val) {
            super(prev);
            this.val = val;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            super.appendTo(target);
            IntArg.appendDecimal(target, this.val);
            return target;
        }
    }

    static abstract class Arg
    extends AbstractEmittable {
        final Arg prev;

        Arg(Arg prev) {
            this.prev = prev;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
                target.append(',');
                target.append(' ');
            }
            return target;
        }
    }

    static final class EnumArg
    extends Arg {
        final Enum<?> val;

        EnumArg(Arg prev, Enum<?> val) {
            super(prev);
            this.val = val;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            super.appendTo(target);
            target.append(this.val.toString());
            return target;
        }
    }
}

