/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.EnumSet;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DIDerivedType;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DITag;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

public class DIDerivedTypeImpl
extends AbstractMetadataNode
implements DIDerivedType {
    private final DITag tag;
    private final long size;
    private final int align;
    private AbstractValue baseType;
    private String name;
    private EnumSet<DIFlags> flags = EnumSet.noneOf(DIFlags.class);
    private long offset;
    private AbstractValue file;
    private int line;

    DIDerivedTypeImpl(int index, DITag tag, long size, int align) {
        super(index);
        this.tag = tag;
        this.size = size;
        this.align = align;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("!DIDerivedType(tag: ");
        target.append(this.tag.name);
        target.append(", size: ");
        DIDerivedTypeImpl.appendDecimal(target, this.size);
        target.append(", align: ");
        DIDerivedTypeImpl.appendDecimal(target, this.align);
        target.append(", baseType: ");
        if (this.baseType != null) {
            this.baseType.appendTo(target);
        } else {
            target.append("null");
        }
        if (this.name != null) {
            target.append(", name: ");
            DIDerivedTypeImpl.appendEscapedString(target, this.name);
        }
        if (!this.flags.isEmpty()) {
            target.append(", flags: ");
            DIDerivedTypeImpl.appendDiFlags(target, this.flags);
        }
        if (this.offset != 0L) {
            target.append(", offset: ");
            DIDerivedTypeImpl.appendDecimal(target, this.offset);
        }
        if (this.file != null) {
            target.append(", file: ");
            this.file.appendTo(target);
            target.append(", line: ");
            DIDerivedTypeImpl.appendDecimal(target, this.line);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DIDerivedType baseType(LLValue baseType) {
        this.baseType = (AbstractValue)baseType;
        return this;
    }

    @Override
    public DIDerivedType name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DIDerivedType flags(EnumSet<DIFlags> flags) {
        Assert.checkNotNullParam((String)"flags", flags);
        this.flags = flags;
        return this;
    }

    @Override
    public DIDerivedType offset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public DIDerivedType location(LLValue file, int line) {
        this.file = (AbstractValue)file;
        this.line = line;
        return this;
    }

    @Override
    public DIDerivedType comment(String comment) {
        return (DIDerivedType)super.comment(comment);
    }
}

