/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DICompileUnit;
import org.qbicc.machine.llvm.debuginfo.DebugEmissionKind;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class DICompileUnitImpl
extends AbstractMetadataNode
implements DICompileUnit {
    private final String language;
    private final AbstractValue file;
    private String producer;
    private boolean isOptimized;
    private String flags;
    private int runtimeVersion;
    private String splitDebugFilename;
    private final DebugEmissionKind emissionKind;
    private AbstractValue enums;
    private AbstractValue retainedTypes;
    private AbstractValue globals;
    private AbstractValue imports;
    private AbstractValue macros;

    DICompileUnitImpl(int index, String language, AbstractValue file, DebugEmissionKind emissionKind) {
        super(index);
        this.language = language;
        this.file = file;
        this.emissionKind = emissionKind;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("distinct !DICompileUnit(language: ");
        target.append(this.language);
        target.append(", file: ");
        this.file.appendTo(target);
        if (this.producer != null) {
            target.append(", producer: ");
            DICompileUnitImpl.appendEscapedString(target, this.producer);
        }
        target.append(", isOptimized: ");
        target.append(this.isOptimized ? "true" : "false");
        if (this.flags != null) {
            target.append(", flags: ");
            DICompileUnitImpl.appendEscapedString(target, this.flags);
        }
        target.append(", runtimeVersion: ");
        DICompileUnitImpl.appendDecimal(target, this.runtimeVersion);
        if (this.splitDebugFilename != null) {
            target.append(", splitDebugFilename: ");
            DICompileUnitImpl.appendEscapedString(target, this.splitDebugFilename);
        }
        target.append(", emissionKind: ");
        target.append(this.emissionKind.name());
        if (this.enums != null) {
            target.append(", enums: ");
            this.enums.appendTo(target);
        }
        if (this.retainedTypes != null) {
            target.append(", retainedTypes: ");
            this.retainedTypes.appendTo(target);
        }
        if (this.globals != null) {
            target.append(", globals: ");
            this.globals.appendTo(target);
        }
        if (this.imports != null) {
            target.append(", imports: ");
            this.imports.appendTo(target);
        }
        if (this.macros != null) {
            target.append(", macros: ");
            this.macros.appendTo(target);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DICompileUnit producer(String producer) {
        this.producer = producer;
        return this;
    }

    @Override
    public DICompileUnit isOptimized(boolean isOptimized) {
        this.isOptimized = isOptimized;
        return this;
    }

    @Override
    public DICompileUnit flags(String flags) {
        this.flags = flags;
        return this;
    }

    @Override
    public DICompileUnit runtimeVersion(int runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    @Override
    public DICompileUnit splitDebugFilename(String splitDebugFilename) {
        this.splitDebugFilename = splitDebugFilename;
        return this;
    }

    @Override
    public DICompileUnit enums(LLValue enums) {
        this.enums = (AbstractValue)enums;
        return this;
    }

    @Override
    public DICompileUnit retainedTypes(LLValue retainedTypes) {
        this.retainedTypes = (AbstractValue)retainedTypes;
        return this;
    }

    @Override
    public DICompileUnit globals(LLValue globals) {
        this.globals = (AbstractValue)globals;
        return this;
    }

    @Override
    public DICompileUnit imports(LLValue imports) {
        this.imports = (AbstractValue)imports;
        return this;
    }

    @Override
    public DICompileUnit macros(LLValue macros) {
        this.macros = (AbstractValue)macros;
        return this;
    }

    @Override
    public DICompileUnit comment(String comment) {
        return (DICompileUnit)super.comment(comment);
    }
}

