/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DIBasicType;
import org.qbicc.machine.llvm.debuginfo.DIEncoding;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

public class DIBasicTypeImpl
extends AbstractMetadataNode
implements DIBasicType {
    private final DIEncoding encoding;
    private final long size;
    private final int align;
    private String name;
    private AbstractValue file;
    private int line;

    DIBasicTypeImpl(int index, DIEncoding encoding, long size, int align) {
        super(index);
        this.encoding = encoding;
        this.size = size;
        this.align = align;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("!DIBasicType(encoding: ");
        target.append(this.encoding.name);
        target.append(", size: ");
        DIBasicTypeImpl.appendDecimal(target, this.size);
        target.append(", align: ");
        DIBasicTypeImpl.appendDecimal(target, this.align);
        if (this.name != null) {
            target.append(", name: ");
            DIBasicTypeImpl.appendEscapedString(target, this.name);
        }
        if (this.file != null) {
            target.append(", file: ");
            this.file.appendTo(target);
            target.append(", line: ");
            DIBasicTypeImpl.appendDecimal(target, this.line);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DIBasicType name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DIBasicType location(LLValue file, int line) {
        this.file = (AbstractValue)file;
        this.line = line;
        return this;
    }

    @Override
    public DIBasicType comment(String comment) {
        return (DIBasicType)super.comment(comment);
    }
}

