/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.CmpAndSwap;
import org.qbicc.machine.llvm.op.OrderingConstraint;

final class CmpAndSwapImpl
extends AbstractYieldingInstruction
implements CmpAndSwap {
    private final AbstractValue pointerType;
    private final AbstractValue type;
    private final AbstractValue pointer;
    private final AbstractValue expect;
    private final AbstractValue update;
    private final OrderingConstraint successOrdering;
    private final OrderingConstraint failureOrdering;
    private boolean weak;
    private boolean isVolatile;
    private String syncScope;
    private int alignment;

    public CmpAndSwapImpl(BasicBlockImpl block, AbstractValue pointerType, AbstractValue type, AbstractValue pointer, AbstractValue expect, AbstractValue update, OrderingConstraint successOrdering, OrderingConstraint failureOrdering) {
        super(block);
        this.pointerType = pointerType;
        this.type = type;
        this.pointer = pointer;
        this.expect = expect;
        this.update = update;
        this.successOrdering = successOrdering;
        this.failureOrdering = failureOrdering;
        this.isVolatile = true;
    }

    @Override
    public CmpAndSwap comment(String comment) {
        return (CmpAndSwap)super.comment(comment);
    }

    @Override
    public CmpAndSwap meta(String name, LLValue data) {
        return (CmpAndSwap)super.meta(name, data);
    }

    @Override
    public CmpAndSwap weak() {
        this.weak = true;
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("cmpxchg");
        if (this.weak) {
            this.space(target);
            target.append("weak");
        }
        if (this.isVolatile) {
            this.space(target);
            target.append("volatile");
        }
        this.space(target);
        this.pointerType.appendTo(target);
        this.space(target);
        this.pointer.appendTo(target);
        target.append(',');
        this.space(target);
        this.type.appendTo(target);
        this.space(target);
        this.expect.appendTo(target);
        target.append(',');
        this.space(target);
        this.type.appendTo(target);
        this.space(target);
        this.update.appendTo(target);
        String syncScope = this.syncScope;
        if (syncScope != null) {
            this.space(target);
            target.append("syncscope");
            target.append('(');
            target.append('\"');
            target.append(syncScope);
            target.append('\"');
            target.append(')');
        }
        this.space(target);
        target.append(this.successOrdering.name());
        this.space(target);
        target.append(this.failureOrdering.name());
        if (this.alignment != 0) {
            target.append(',');
            this.space(target);
            target.append("align");
            this.space(target);
            target.append(Integer.toString(this.alignment));
        }
        return this.appendTrailer(target);
    }

    private void space(Appendable target) throws IOException {
        target.append(' ');
    }
}

