/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.qbicc.machine.llvm.CallingConvention;
import org.qbicc.machine.llvm.FastMathFlag;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.TailType;
import org.qbicc.machine.llvm.Types;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.impl.FunctionType;
import org.qbicc.machine.llvm.impl.LLVM;
import org.qbicc.machine.llvm.op.Call;
import org.qbicc.machine.llvm.op.HasArguments;

final class CallImpl
extends AbstractYieldingInstruction
implements Call {
    final AbstractValue type;
    final AbstractValue function;
    final ReturnsImpl returns = new ReturnsImpl();
    final List<AbstractValue> attributes = new ArrayList<AbstractValue>();
    Set<FastMathFlag> flags = Set.of();
    TailType tailType = TailType.notail;
    CallingConvention cconv = CallingConvention.C;
    ArgImpl lastArg;
    BundleImpl lastBundle;
    int addressSpace;

    CallImpl(BasicBlockImpl basicBlock, AbstractValue type, AbstractValue function) {
        super(basicBlock);
        this.type = type;
        this.function = function;
    }

    @Override
    public Call meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Call attribute(LLValue attribute) {
        this.attributes.add((AbstractValue)Assert.checkNotNullParam((String)"attribute", (Object)attribute));
        return this;
    }

    @Override
    public HasArguments operandBundle(String bundleName) {
        this.lastBundle = new BundleImpl(this.lastBundle, bundleName);
        return this.lastBundle;
    }

    @Override
    public Call comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Call withFlags(Set<FastMathFlag> flags) {
        Assert.checkNotNullParam((String)"flags", flags);
        this.flags = flags;
        return this;
    }

    @Override
    public Call tail() {
        this.tailType = TailType.tail;
        return this;
    }

    @Override
    public Call mustTail() {
        this.tailType = TailType.musttail;
        return this;
    }

    @Override
    public Call noTail() {
        this.tailType = TailType.notail;
        return this;
    }

    @Override
    public Call cconv(CallingConvention cconv) {
        Assert.checkNotNullParam((String)"cconv", (Object)((Object)cconv));
        this.cconv = cconv;
        return this;
    }

    @Override
    public Call.Returns returns() {
        return this.returns;
    }

    @Override
    public Call addrSpace(int num) {
        Assert.checkMinimumParameter((String)"num", (int)0, (int)num);
        this.addressSpace = num;
        return this;
    }

    @Override
    public HasArguments.Argument arg(LLValue type, LLValue value) {
        this.lastArg = new ArgImpl(this, this.lastArg, (AbstractValue)type, (AbstractValue)value);
        return this.lastArg;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        FunctionType ft;
        Object object;
        if (this.notVoidFunctionCall()) {
            super.appendTo(target);
        }
        if (this.tailType != TailType.notail) {
            target.append(this.tailType.name()).append(' ');
        }
        target.append("call").append(' ');
        for (FastMathFlag flag : this.flags) {
            target.append(flag.name()).append(' ');
        }
        if (this.cconv != CallingConvention.C) {
            target.append(this.cconv.toString()).append(' ');
        }
        this.returns.appendTo(target);
        if (this.addressSpace != 0) {
            target.append("addrspace").append('(').append(Integer.toString(this.addressSpace)).append(')').append(' ');
        }
        if (!((object = this.type) instanceof FunctionType) || (ft = (FunctionType)object).isVariadic()) {
            this.type.appendTo(target);
        } else {
            ft.returnType.appendTo(target);
        }
        target.append(' ');
        this.function.appendTo(target);
        target.append('(');
        ArgImpl lastArg = this.lastArg;
        if (lastArg != null) {
            lastArg.appendTo(target);
        }
        target.append(')');
        for (AbstractValue attribute : this.attributes) {
            target.append(' ');
            attribute.appendTo(target);
        }
        if (this.lastBundle != null) {
            target.append(' ');
            target.append('[');
            target.append(' ');
            this.lastBundle.appendTo(target);
            target.append(' ');
            target.append(']');
        }
        return this.appendTrailer(target);
    }

    private boolean notVoidFunctionCall() {
        return !(this.type instanceof FunctionType) || Types.void_ != ((FunctionType)this.type).returnType;
    }

    static final class ReturnsImpl
    extends AbstractEmittable
    implements Call.Returns {
        final List<AbstractValue> attributes = new ArrayList<AbstractValue>();

        ReturnsImpl() {
        }

        @Override
        public ReturnsImpl attribute(LLValue attribute) {
            this.attributes.add((AbstractValue)Assert.checkNotNullParam((String)"attribute", (Object)attribute));
            return this;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            for (AbstractValue attribute : this.attributes) {
                attribute.appendTo(target);
                target.append(' ');
            }
            return target;
        }
    }

    static final class BundleImpl
    extends AbstractEmittable
    implements HasArguments {
        private final String name;
        private final BundleImpl prev;
        ArgImpl lastArg;

        BundleImpl(BundleImpl prev, String name) {
            this.prev = prev;
            this.name = name;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
                target.append(',');
                target.append(' ');
            }
            target.append(LLVM.quoteString(this.name));
            target.append('(');
            ArgImpl lastArg = this.lastArg;
            if (lastArg != null) {
                lastArg.appendTo(target);
            }
            target.append(')');
            return null;
        }

        @Override
        public HasArguments.Argument arg(LLValue type, LLValue value) {
            this.lastArg = new ArgImpl(this, this.lastArg, (AbstractValue)type, (AbstractValue)value);
            return this.lastArg;
        }
    }

    static final class ArgImpl
    extends AbstractEmittable
    implements HasArguments.Argument {
        final HasArguments hasArguments;
        final ArgImpl prev;
        final AbstractValue type;
        final AbstractValue value;
        final List<AbstractValue> attributes = new ArrayList<AbstractValue>();

        ArgImpl(HasArguments hasArguments, ArgImpl prev, AbstractValue type, AbstractValue value) {
            this.hasArguments = hasArguments;
            this.prev = prev;
            this.type = type;
            this.value = value;
        }

        @Override
        public ArgImpl attribute(LLValue attribute) {
            this.attributes.add((AbstractValue)Assert.checkNotNullParam((String)"attribute", (Object)attribute));
            return this;
        }

        @Override
        public HasArguments.Argument arg(LLValue type, LLValue value) {
            return this.hasArguments.arg(type, value);
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            ArgImpl prev = this.prev;
            if (prev != null) {
                prev.appendTo(target);
                target.append(',').append(' ');
            }
            this.type.appendTo(target);
            target.append(' ');
            for (AbstractValue attribute : this.attributes) {
                attribute.appendTo(target);
                target.append(' ');
            }
            this.value.appendTo(target);
            return target;
        }
    }
}

