/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import org.qbicc.machine.llvm.FloatCondition;
import org.qbicc.machine.llvm.IntCondition;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLBuilder;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Metable;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AddImpl;
import org.qbicc.machine.llvm.impl.AddrSpaceCast;
import org.qbicc.machine.llvm.impl.AllocaImpl;
import org.qbicc.machine.llvm.impl.AndImpl;
import org.qbicc.machine.llvm.impl.AshrImpl;
import org.qbicc.machine.llvm.impl.AssignmentImpl;
import org.qbicc.machine.llvm.impl.AtomicRmwImpl;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.impl.BitCastImpl;
import org.qbicc.machine.llvm.impl.CallImpl;
import org.qbicc.machine.llvm.impl.CmpAndSwapImpl;
import org.qbicc.machine.llvm.impl.ConditionalBranchImpl;
import org.qbicc.machine.llvm.impl.ExtractValueImpl;
import org.qbicc.machine.llvm.impl.FAddImpl;
import org.qbicc.machine.llvm.impl.FCmpImpl;
import org.qbicc.machine.llvm.impl.FDivImpl;
import org.qbicc.machine.llvm.impl.FMulImpl;
import org.qbicc.machine.llvm.impl.FNegImpl;
import org.qbicc.machine.llvm.impl.FPExtImpl;
import org.qbicc.machine.llvm.impl.FPToSI;
import org.qbicc.machine.llvm.impl.FPToUI;
import org.qbicc.machine.llvm.impl.FRemImpl;
import org.qbicc.machine.llvm.impl.FSubImpl;
import org.qbicc.machine.llvm.impl.FTruncImpl;
import org.qbicc.machine.llvm.impl.FenceImpl;
import org.qbicc.machine.llvm.impl.GetElementPtrImpl;
import org.qbicc.machine.llvm.impl.IcmpImpl;
import org.qbicc.machine.llvm.impl.IndirectBranchImpl;
import org.qbicc.machine.llvm.impl.InsertValueImpl;
import org.qbicc.machine.llvm.impl.IntToPtr;
import org.qbicc.machine.llvm.impl.InvokeImpl;
import org.qbicc.machine.llvm.impl.LandingPadImpl;
import org.qbicc.machine.llvm.impl.LoadImpl;
import org.qbicc.machine.llvm.impl.LshrImpl;
import org.qbicc.machine.llvm.impl.MulImpl;
import org.qbicc.machine.llvm.impl.OrImpl;
import org.qbicc.machine.llvm.impl.PhiImpl;
import org.qbicc.machine.llvm.impl.PtrToInt;
import org.qbicc.machine.llvm.impl.SExtImpl;
import org.qbicc.machine.llvm.impl.SIToFP;
import org.qbicc.machine.llvm.impl.SRemImpl;
import org.qbicc.machine.llvm.impl.SdivImpl;
import org.qbicc.machine.llvm.impl.SelectImpl;
import org.qbicc.machine.llvm.impl.ShlImpl;
import org.qbicc.machine.llvm.impl.StoreImpl;
import org.qbicc.machine.llvm.impl.SubImpl;
import org.qbicc.machine.llvm.impl.SwitchImpl;
import org.qbicc.machine.llvm.impl.TruncImpl;
import org.qbicc.machine.llvm.impl.UIToFP;
import org.qbicc.machine.llvm.impl.URemImpl;
import org.qbicc.machine.llvm.impl.UdivImpl;
import org.qbicc.machine.llvm.impl.UnconditionalBranchImpl;
import org.qbicc.machine.llvm.impl.Unreachable;
import org.qbicc.machine.llvm.impl.VaArg;
import org.qbicc.machine.llvm.impl.ValueReturn;
import org.qbicc.machine.llvm.impl.VoidReturn;
import org.qbicc.machine.llvm.impl.XorImpl;
import org.qbicc.machine.llvm.impl.ZExtImpl;
import org.qbicc.machine.llvm.op.Alloca;
import org.qbicc.machine.llvm.op.Assignment;
import org.qbicc.machine.llvm.op.AtomicRmw;
import org.qbicc.machine.llvm.op.Binary;
import org.qbicc.machine.llvm.op.Branch;
import org.qbicc.machine.llvm.op.Call;
import org.qbicc.machine.llvm.op.CmpAndSwap;
import org.qbicc.machine.llvm.op.ExactBinary;
import org.qbicc.machine.llvm.op.ExtractValue;
import org.qbicc.machine.llvm.op.FastMathBinary;
import org.qbicc.machine.llvm.op.FastMathUnary;
import org.qbicc.machine.llvm.op.Fence;
import org.qbicc.machine.llvm.op.GetElementPtr;
import org.qbicc.machine.llvm.op.IndirectBranch;
import org.qbicc.machine.llvm.op.Instruction;
import org.qbicc.machine.llvm.op.LandingPad;
import org.qbicc.machine.llvm.op.Load;
import org.qbicc.machine.llvm.op.NuwNswBinary;
import org.qbicc.machine.llvm.op.OrderingConstraint;
import org.qbicc.machine.llvm.op.Phi;
import org.qbicc.machine.llvm.op.Return;
import org.qbicc.machine.llvm.op.Select;
import org.qbicc.machine.llvm.op.Store;
import org.qbicc.machine.llvm.op.Switch;
import org.qbicc.machine.llvm.op.YieldingInstruction;

final class BuilderImpl
implements LLBuilder {
    BasicBlockImpl block;
    AbstractValue debugLocation;

    BuilderImpl(BasicBlockImpl block) {
        this.block = block;
    }

    @Override
    public LLValue getDebugLocation() {
        return this.debugLocation;
    }

    @Override
    public LLValue setDebugLocation(LLValue debugLocation) {
        AbstractValue oldDebugLocation = this.debugLocation;
        this.debugLocation = (AbstractValue)debugLocation;
        return oldDebugLocation;
    }

    @Override
    public LLBasicBlock getCurrentBlock() {
        return this.block;
    }

    @Override
    public LLBasicBlock moveToBlock(LLBasicBlock block) {
        Assert.checkNotNullParam((String)"block", (Object)block);
        BasicBlockImpl oldBlock = this.block;
        this.block = (BasicBlockImpl)block;
        return oldBlock;
    }

    private <I extends Metable> I attachDbg(I instr) {
        if (this.debugLocation != null) {
            instr.meta("dbg", this.debugLocation);
        }
        return instr;
    }

    private <I extends AbstractEmittable> I append(I instr) {
        this.block.items.add(this.attachDbg(instr));
        return instr;
    }

    private <I extends AbstractEmittable> I appendTerminator(I instr) {
        if (this.block.terminator != null) {
            throw new IllegalStateException("Basic block already terminated");
        }
        this.block.terminator = this.attachDbg(instr);
        return instr;
    }

    private <I extends AbstractEmittable> I appendPhi(I instr) {
        this.block.phis.add(this.attachDbg(instr));
        return instr;
    }

    @Override
    public Phi phi(LLValue type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.appendPhi(new PhiImpl(this.block, (AbstractValue)type));
    }

    @Override
    public Branch br(LLBasicBlock dest) {
        Assert.checkNotNullParam((String)"dest", (Object)dest);
        return this.appendTerminator(new UnconditionalBranchImpl((BasicBlockImpl)dest));
    }

    @Override
    public Branch br(LLValue cond, LLBasicBlock ifTrue, LLBasicBlock ifFalse) {
        Assert.checkNotNullParam((String)"cond", (Object)cond);
        Assert.checkNotNullParam((String)"ifTrue", (Object)ifTrue);
        Assert.checkNotNullParam((String)"ifFalse", (Object)ifFalse);
        return this.appendTerminator(new ConditionalBranchImpl((AbstractValue)cond, (BasicBlockImpl)ifTrue, (BasicBlockImpl)ifFalse));
    }

    @Override
    public IndirectBranch indirectbr(LLValue address) {
        Assert.checkNotNullParam((String)"address", (Object)address);
        return this.appendTerminator(new IndirectBranchImpl((AbstractValue)address));
    }

    @Override
    public Return ret() {
        return this.appendTerminator(new VoidReturn());
    }

    @Override
    public Return ret(LLValue type, LLValue val) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"val", (Object)val);
        return this.appendTerminator(new ValueReturn((AbstractValue)type, (AbstractValue)val));
    }

    @Override
    public Switch switch_(LLValue type, LLValue value, LLBasicBlock defaultTarget) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"defaultTarget", (Object)defaultTarget);
        return this.appendTerminator(new SwitchImpl((AbstractValue)type, (AbstractValue)value, (BasicBlockImpl)defaultTarget));
    }

    @Override
    public Instruction unreachable() {
        return this.appendTerminator(new Unreachable());
    }

    @Override
    public Call invoke(LLValue type, LLValue function, LLBasicBlock normal, LLBasicBlock unwind) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"function", (Object)function);
        Assert.checkNotNullParam((String)"normal", (Object)normal);
        Assert.checkNotNullParam((String)"unwind", (Object)unwind);
        return this.appendTerminator(new InvokeImpl(this.block, (AbstractValue)type, (AbstractValue)function, (BasicBlockImpl)normal, (BasicBlockImpl)unwind));
    }

    @Override
    public LandingPad landingpad(LLValue resultType) {
        Assert.checkNotNullParam((String)"resultType", (Object)resultType);
        return this.append(new LandingPadImpl(this.block, (AbstractValue)resultType));
    }

    @Override
    public Assignment assign(LLValue value) {
        Assert.checkNotNullParam((String)"value", (Object)value);
        return this.append(new AssignmentImpl(this.block, (AbstractValue)value));
    }

    @Override
    public Select select(LLValue condType, LLValue cond, LLValue valueType, LLValue trueValue, LLValue falseValue) {
        return this.append(new SelectImpl(this.block, (AbstractValue)condType, (AbstractValue)cond, (AbstractValue)valueType, (AbstractValue)trueValue, (AbstractValue)falseValue));
    }

    @Override
    public NuwNswBinary add(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new AddImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public NuwNswBinary sub(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new SubImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public NuwNswBinary mul(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new MulImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public NuwNswBinary shl(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new ShlImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public ExactBinary udiv(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new UdivImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public ExactBinary sdiv(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new SdivImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public ExactBinary lshr(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new LshrImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public ExactBinary ashr(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new AshrImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathBinary fmul(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new FMulImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathBinary fcmp(FloatCondition cond, LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"cond", (Object)((Object)cond));
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new FCmpImpl(this.block, cond, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathBinary fadd(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new FAddImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathBinary fsub(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new FSubImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathBinary fdiv(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new FDivImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathBinary frem(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new FRemImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public FastMathUnary fneg(LLValue type, LLValue arg) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg", (Object)arg);
        return this.append(new FNegImpl(this.block, (AbstractValue)type, (AbstractValue)arg));
    }

    @Override
    public Binary icmp(IntCondition cond, LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"cond", (Object)((Object)cond));
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new IcmpImpl(this.block, cond, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public Binary and(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new AndImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public Binary or(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new OrImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public Binary xor(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new XorImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public Binary urem(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new URemImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public Binary srem(LLValue type, LLValue arg1, LLValue arg2) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"arg1", (Object)arg1);
        Assert.checkNotNullParam((String)"arg2", (Object)arg2);
        return this.append(new SRemImpl(this.block, (AbstractValue)type, (AbstractValue)arg1, (AbstractValue)arg2));
    }

    @Override
    public YieldingInstruction trunc(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new TruncImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction ftrunc(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new FTruncImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction fpext(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new FPExtImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction sext(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new SExtImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction zext(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new ZExtImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction bitcast(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new BitCastImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction addrspacecast(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new AddrSpaceCast(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction fptosi(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new FPToSI(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction fptoui(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new FPToUI(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction sitofp(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new SIToFP(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction uitofp(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new UIToFP(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction ptrtoint(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new PtrToInt(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction inttoptr(LLValue type, LLValue value, LLValue toType) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"toType", (Object)toType);
        return this.append(new IntToPtr(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)toType));
    }

    @Override
    public YieldingInstruction va_arg(LLValue vaListType, LLValue vaList, LLValue outputType) {
        Assert.checkNotNullParam((String)"vaListType", (Object)vaListType);
        Assert.checkNotNullParam((String)"vaList", (Object)vaList);
        Assert.checkNotNullParam((String)"outputType", (Object)outputType);
        return this.append(new VaArg(this.block, (AbstractValue)vaListType, (AbstractValue)vaList, (AbstractValue)outputType));
    }

    @Override
    public Call call(LLValue type, LLValue function) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"function", (Object)function);
        return this.append(new CallImpl(this.block, (AbstractValue)type, (AbstractValue)function));
    }

    @Override
    public Load load(LLValue type, LLValue pointeeType, LLValue pointer) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"pointeeType", (Object)pointeeType);
        Assert.checkNotNullParam((String)"pointer", (Object)pointer);
        return this.append(new LoadImpl(this.block, (AbstractValue)type, (AbstractValue)pointeeType, (AbstractValue)pointer));
    }

    @Override
    public Store store(LLValue type, LLValue value, LLValue pointeeType, LLValue pointer) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"pointeeType", (Object)pointeeType);
        Assert.checkNotNullParam((String)"pointer", (Object)pointer);
        return this.append(new StoreImpl((AbstractValue)type, (AbstractValue)value, (AbstractValue)pointeeType, (AbstractValue)pointer));
    }

    @Override
    public Fence fence(OrderingConstraint ordering) {
        Assert.checkNotNullParam((String)"ordering", (Object)((Object)ordering));
        return this.append(new FenceImpl(ordering));
    }

    @Override
    public AtomicRmw atomicrmw(LLValue type, LLValue value, LLValue pointeeType, LLValue pointer) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"pointeeType", (Object)pointeeType);
        Assert.checkNotNullParam((String)"pointer", (Object)pointer);
        return this.append(new AtomicRmwImpl(this.block, (AbstractValue)type, (AbstractValue)value, (AbstractValue)pointeeType, (AbstractValue)pointer));
    }

    @Override
    public GetElementPtr getelementptr(LLValue type, LLValue ptrType, LLValue pointer) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"ptrType", (Object)ptrType);
        Assert.checkNotNullParam((String)"pointer", (Object)pointer);
        return this.append(new GetElementPtrImpl(this.block, (AbstractValue)type, (AbstractValue)ptrType, (AbstractValue)pointer));
    }

    @Override
    public ExtractValue extractvalue(LLValue aggregateType, LLValue aggregate) {
        Assert.checkNotNullParam((String)"aggregateType", (Object)aggregateType);
        Assert.checkNotNullParam((String)"aggregate", (Object)aggregate);
        return this.append(new ExtractValueImpl(this.block, (AbstractValue)aggregateType, (AbstractValue)aggregate));
    }

    @Override
    public ExtractValue insertvalue(LLValue aggregateType, LLValue aggregate, LLValue insertType, LLValue insert) {
        Assert.checkNotNullParam((String)"aggregateType", (Object)aggregateType);
        Assert.checkNotNullParam((String)"aggregate", (Object)aggregate);
        Assert.checkNotNullParam((String)"insertType", (Object)insertType);
        Assert.checkNotNullParam((String)"insert", (Object)insert);
        return this.append(new InsertValueImpl(this.block, (AbstractValue)aggregateType, (AbstractValue)aggregate, (AbstractValue)insertType, (AbstractValue)insert));
    }

    @Override
    public Alloca alloca(LLValue type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.append(new AllocaImpl(this.block, (AbstractValue)type));
    }

    @Override
    public CmpAndSwap cmpAndSwap(LLValue pointerType, LLValue type, LLValue pointer, LLValue expect, LLValue update, OrderingConstraint successOrdering, OrderingConstraint failureOrdering) {
        Assert.checkNotNullParam((String)"pointerType", (Object)pointerType);
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"pointer", (Object)pointer);
        Assert.checkNotNullParam((String)"expect", (Object)expect);
        Assert.checkNotNullParam((String)"update", (Object)update);
        Assert.checkNotNullParam((String)"successOrdering", (Object)((Object)successOrdering));
        Assert.checkNotNullParam((String)"failureOrdering", (Object)((Object)failureOrdering));
        return this.append(new CmpAndSwapImpl(this.block, (AbstractValue)pointerType, (AbstractValue)type, (AbstractValue)pointer, (AbstractValue)expect, (AbstractValue)update, successOrdering, failureOrdering));
    }
}

