/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.AtomicRmw;
import org.qbicc.machine.llvm.op.OrderingConstraint;

final class AtomicRmwImpl
extends AbstractYieldingInstruction
implements AtomicRmw {
    final AbstractValue type;
    final AbstractValue value;
    final AbstractValue pointeeType;
    final AbstractValue pointer;
    int alignment;
    boolean volatile_;
    OrderingConstraint constraint;
    String syncScope;
    Operation operation;

    AtomicRmwImpl(BasicBlockImpl block, AbstractValue type, AbstractValue value, AbstractValue pointeeType, AbstractValue pointer) {
        super(block);
        this.type = type;
        this.value = value;
        this.pointeeType = pointeeType;
        this.pointer = pointer;
    }

    @Override
    public AtomicRmw comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public AtomicRmw meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public AtomicRmw align(int alignment) {
        Assert.checkMinimumParameter((String)"alignment", (int)1, (int)alignment);
        if (Integer.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power of two");
        }
        this.alignment = alignment;
        return this;
    }

    @Override
    public AtomicRmw volatile_() {
        this.volatile_ = true;
        return this;
    }

    @Override
    public AtomicRmw syncScope(String scopeName) {
        this.syncScope = (String)Assert.checkNotNullParam((String)"scopeName", (Object)scopeName);
        return this;
    }

    @Override
    public AtomicRmw xchg() {
        this.operation = Operation.xchg;
        return this;
    }

    @Override
    public AtomicRmw add() {
        this.operation = Operation.add;
        return this;
    }

    @Override
    public AtomicRmw sub() {
        this.operation = Operation.sub;
        return this;
    }

    @Override
    public AtomicRmw and() {
        this.operation = Operation.and;
        return this;
    }

    @Override
    public AtomicRmw nand() {
        this.operation = Operation.nand;
        return this;
    }

    @Override
    public AtomicRmw or() {
        this.operation = Operation.or;
        return this;
    }

    @Override
    public AtomicRmw xor() {
        this.operation = Operation.xor;
        return this;
    }

    @Override
    public AtomicRmw max() {
        this.operation = Operation.max;
        return this;
    }

    @Override
    public AtomicRmw min() {
        this.operation = Operation.min;
        return this;
    }

    @Override
    public AtomicRmw umax() {
        this.operation = Operation.umax;
        return this;
    }

    @Override
    public AtomicRmw umin() {
        this.operation = Operation.umin;
        return this;
    }

    @Override
    public AtomicRmw fadd() {
        this.operation = Operation.fadd;
        return this;
    }

    @Override
    public AtomicRmw fsub() {
        this.operation = Operation.fsub;
        return this;
    }

    @Override
    public AtomicRmw ordering(OrderingConstraint order) {
        this.constraint = (OrderingConstraint)((Object)Assert.checkNotNullParam((String)"order", (Object)((Object)order)));
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("atomicrmw");
        if (this.volatile_) {
            target.append(' ').append("volatile");
        }
        target.append(' ');
        target.append(this.operation.name());
        target.append(' ');
        this.type.appendTo(target);
        target.append(' ');
        this.pointer.appendTo(target);
        target.append(',').append(' ');
        this.pointeeType.appendTo(target);
        target.append(' ');
        this.value.appendTo(target);
        OrderingConstraint constraint = this.constraint;
        String syncScope = this.syncScope;
        if (syncScope != null) {
            target.append(' ').append("syncScope").append('(').append('\"').append(syncScope).append('\"').append(')');
        }
        target.append(' ').append(constraint.name());
        return this.appendTrailer(target);
    }

    static enum Operation {
        xchg,
        add,
        sub,
        and,
        nand,
        or,
        xor,
        max,
        min,
        umax,
        umin,
        fadd,
        fsub;

    }
}

