/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.Set;
import org.qbicc.machine.llvm.AsmFlag;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class AsmExpression
extends AbstractValue {
    private final String instruction;
    private final String constraints;
    private final Set<AsmFlag> flags;

    AsmExpression(String instruction, String constraints, Set<AsmFlag> flags) {
        this.instruction = (String)Assert.checkNotNullParam((String)"instruction", (Object)instruction);
        this.constraints = (String)Assert.checkNotNullParam((String)"constraints", (Object)constraints);
        this.flags = (Set)Assert.checkNotNullParam((String)"flags", flags);
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append("asm").append(' ');
        for (AsmFlag flag : this.flags) {
            target.append(flag.getLlvmString()).append(' ');
        }
        AsmExpression.appendEscapedString(target, this.instruction);
        target.append(',').append(' ');
        AsmExpression.appendEscapedString(target, this.constraints);
        return target;
    }
}

