/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.qbicc.machine.llvm.Array;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class ArrayImpl
extends AbstractValue
implements Array {
    final AbstractValue elementType;
    final ArrayList<AbstractValue> values = new ArrayList();

    ArrayImpl(LLValue elementType) {
        this.elementType = (AbstractValue)elementType;
    }

    @Override
    public Array item(LLValue value) {
        this.values.add((AbstractValue)value);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append('[');
        Iterator<AbstractValue> iterator = this.values.iterator();
        boolean multiLineOutput = false;
        if (this.values.size() > 20) {
            multiLineOutput = true;
            target.append('\n');
        }
        if (iterator.hasNext()) {
            int index = 0;
            target.append(' ');
            this.elementType.appendTo(target);
            target.append(' ');
            iterator.next().appendTo(target);
            while (iterator.hasNext()) {
                target.append(',');
                if (multiLineOutput) {
                    target.append(" ; " + index++ + " \n");
                }
                target.append(' ');
                this.elementType.appendTo(target);
                target.append(' ');
                iterator.next().appendTo(target);
            }
            if (index > 0 && multiLineOutput) {
                target.append(" ; " + index++ + " \n");
            }
        }
        target.append(' ');
        target.append(']');
        return target;
    }
}

