/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.Alloca;

final class AllocaImpl
extends AbstractYieldingInstruction
implements Alloca {
    private final AbstractValue type;
    private AbstractValue numElementsType;
    private AbstractValue numElements;
    private AbstractValue align;

    AllocaImpl(BasicBlockImpl block, AbstractValue type) {
        super(block);
        this.type = type;
    }

    @Override
    public Alloca elements(LLValue type, LLValue count) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"count", (Object)count);
        this.numElementsType = (AbstractValue)type;
        this.numElements = (AbstractValue)count;
        return this;
    }

    @Override
    public Alloca align(LLValue align) {
        Assert.checkNotNullParam((String)"align", (Object)align);
        this.align = (AbstractValue)align;
        return this;
    }

    @Override
    public Alloca comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Alloca meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("alloca");
        target.append(' ');
        this.type.appendTo(target);
        if (this.numElements != null) {
            target.append(',');
            target.append(' ');
            this.numElementsType.appendTo(target);
            target.append(' ');
            this.numElements.appendTo(target);
        }
        if (this.align != null) {
            target.append(',');
            target.append(' ');
            target.append("align");
            target.append(' ');
            this.align.appendTo(target);
        }
        return target;
    }
}

